/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.update.hierarchy;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.enum.ElementEnumeration;

public interface ParticipantFinder {
    public static final ParticipantFinder SIMPLE_SOURCE_FINDER = new FirstByRoleFinder(new String[]{"Client"});
    public static final ParticipantFinder SIMPLE_DESTINATION_FINDER = new FirstByRoleFinder(new String[]{"Supplier"});

    public Entity findValidParticipant(Entity var1);

    public static class FirstByRoleFinder
    implements ParticipantFinder {
        private String[] myRoles;

        public FirstByRoleFinder(String[] roles) {
            this.myRoles = roles;
        }

        public Entity findValidParticipant(Entity link) {
            int i = 0;
            while (i < this.myRoles.length) {
                ElementEnumeration participants = link.participants(this.myRoles[i]);
                if (participants.hasMoreElements()) {
                    return (Entity)participants.next();
                }
                ++i;
            }
            return null;
        }
    }
}

