/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.update.hierarchy;

import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.update.hierarchy.Messages;
import com.tssap.selena.model.update.hierarchy.Revisit;
import com.tssap.selena.model.update.hierarchy.SingleDiagramUpdater;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewFactoryEx;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class DiagramViewFactory
implements ViewFactoryEx,
ModelAccessListener {
    public static final String VIEW_TYPE = "com.tssap.selena.model.diagram";
    public static final String HIDDEN_VIEW_TYPE = "com.tssap.selena.model.diagram.hidden";
    private HashMap myUpdaters = new HashMap();

    public DiagramViewFactory() {
        ModelAccess.addModelAccessListener((ModelAccessListener)this);
    }

    public void modelCreated(ModelAccessEvent event) {
    }

    public void modelRemoved(ModelAccessEvent event) {
        this.checkThread();
        UniqueName modelUin = event.getModel().getUniqueName();
        HashSet<ReferenceCollectionInfo> toDeleteRcInfos = new HashSet<ReferenceCollectionInfo>();
        Iterator entries = this.myUpdaters.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry curEntry = entries.next();
            ReferenceCollectionInfo curRCInfo = (ReferenceCollectionInfo)curEntry.getKey();
            if (!curRCInfo.getModelUin().equals(modelUin)) continue;
            toDeleteRcInfos.add(curRCInfo);
        }
        Iterator toDeleteKeys = toDeleteRcInfos.iterator();
        while (toDeleteKeys.hasNext()) {
            ReferenceCollectionInfo curKey = (ReferenceCollectionInfo)toDeleteKeys.next();
            SingleDiagramUpdater updater = (SingleDiagramUpdater)this.myUpdaters.get(curKey);
            updater.shutDown();
        }
    }

    public boolean canCreateView(ReferenceCollection collection, String type) {
        return VIEW_TYPE.equals(type) || HIDDEN_VIEW_TYPE.equals(type);
    }

    public void stopListening(View view) {
        if (view instanceof SingleDiagramUpdater && this.myUpdaters.containsValue(view)) {
            SingleDiagramUpdater updaterToDelete = (SingleDiagramUpdater)view;
            UniqueName modelUin = updaterToDelete.getModelUin();
            UniqueName rcUin = updaterToDelete.getReferenceCollection().getUniqueName();
            ReferenceCollectionInfo infoToDelete = new ReferenceCollectionInfo(modelUin, rcUin);
            this.myUpdaters.remove(infoToDelete);
        }
    }

    public View createView(ReferenceCollection collection, String viewType, IProgressMonitor pm) {
        UniqueName modelUin = collection.getModel().getUniqueName();
        ReferenceCollectionInfo info = new ReferenceCollectionInfo(modelUin, collection.getUniqueName());
        SingleDiagramUpdater updater = (SingleDiagramUpdater)this.myUpdaters.get(info);
        if (updater != null) {
            Revisit.revisit();
            updater.reactivateDiagram();
        } else {
            if (pm != null) {
                pm.beginTask(Messages.getString("DiagramViewFactory.Opening_diagram"), 5);
            }
            updater = new SingleDiagramUpdater(viewType, collection, this, pm);
            this.myUpdaters.put(info, updater);
            if (pm != null) {
                pm.done();
            }
        }
        return updater;
    }

    public View createView(ReferenceCollection collection, String viewType) {
        return this.createView(collection, viewType, null);
    }

    private void checkThread() {
        Assert.isLegal((boolean)Thread.currentThread().equals(Display.getDefault().getThread()), (String)("Illegal thread : " + Thread.currentThread().getName()));
    }

    private class ReferenceCollectionInfo {
        private UniqueName myUin;
        private UniqueName myModelUin;

        public ReferenceCollectionInfo(UniqueName modelUin, UniqueName rcUin) {
            this.myUin = rcUin;
            this.myModelUin = modelUin;
        }

        public UniqueName getUin() {
            return this.myUin;
        }

        public UniqueName getModelUin() {
            return this.myModelUin;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReferenceCollectionInfo)) {
                return false;
            }
            ReferenceCollectionInfo info = (ReferenceCollectionInfo)obj;
            return this.getModelUin().equals(info.getModelUin()) && this.getUin().equals(info.getUin());
        }

        public int hashCode() {
            return (this.myModelUin.toString() + this.myUin.toString()).hashCode();
        }

        public String toString() {
            return "Model: " + this.getModelUin() + " UIN: " + this.getUin();
        }
    }
}

