/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.update.hierarchy;

import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.update.diagram.DispatchedTreeDeltaListener;
import com.tssap.selena.model.update.hierarchy.IDeltaDispatchingNode;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DeltaDispatchingNode
implements IDeltaDispatchingNode {
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    };
    private UniqueName myUin;
    private IDeltaDispatchingNode myParentNode;
    private Map myChildNodes;
    private Set myListeners;

    public DeltaDispatchingNode(UniqueName uin) {
        this.myUin = uin;
    }

    public void addChildNode(IDeltaDispatchingNode childNode) {
        if (this.myChildNodes == null) {
            this.myChildNodes = new HashMap();
        } else if (this.myChildNodes.containsKey(childNode.getNodeUin())) {
            throw new IllegalStateException("attempt to duplicate registration of child dispatching node");
        }
        ((DeltaDispatchingNode)childNode).setParentNode(this);
        this.myChildNodes.put(childNode.getNodeUin(), childNode);
    }

    public void addListener(DispatchedTreeDeltaListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new HashSet();
        }
        this.myListeners.add(listener);
    }

    public IDeltaDispatchingNode getChildNode(UniqueName uin) {
        if (this.myChildNodes == null) {
            return null;
        }
        return (IDeltaDispatchingNode)this.myChildNodes.get(uin);
    }

    public UniqueName getNodeUin() {
        return this.myUin;
    }

    public IDeltaDispatchingNode getParentNode() {
        return this.myParentNode;
    }

    public boolean haveChildren() {
        return this.myChildNodes != null && !this.myChildNodes.isEmpty();
    }

    public Iterator listeners() {
        if (this.myListeners == null) {
            return EMPTY_ITERATOR;
        }
        return this.myListeners.iterator();
    }

    public void removeChildNode(UniqueName uin) {
        if (this.myChildNodes == null) {
            return;
        }
        this.myChildNodes.remove(uin);
        if (this.myChildNodes.isEmpty()) {
            this.myChildNodes = null;
        }
    }

    public Enumeration childNodes() {
        if (this.myChildNodes == null) {
            return EmptyEnumeration.getEnumeration();
        }
        LinkedList result = new LinkedList();
        result.addAll(this.myChildNodes.values());
        return Collections.enumeration(result);
    }

    public void removeListener(DispatchedTreeDeltaListener listener) {
        if (this.myListeners != null) {
            this.myListeners.remove(listener);
        }
    }

    private void setParentNode(IDeltaDispatchingNode parentNode) {
        this.myParentNode = parentNode;
    }
}

