/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.update.hierarchy;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.update.diagram.DispatchedTreeDeltaListener;
import com.tssap.selena.model.update.hierarchy.DeltaDispatchingNode;
import com.tssap.selena.model.update.hierarchy.IDeltaDispatchingNode;
import com.tssap.selena.model.update.hierarchy.MissedDeletedDelta;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.TotalUpdateDeltaNode;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class DeltaDispatcher
implements ModelChangeListener {
    private static final DeltaDispatcher NULL_DISPATCHER = new DeltaDispatcher(){

        public void dispatchDelta(ModelDeltaNode rootModelDelta) {
        }

        public void registerListener(Element dispatchTarget, DispatchedTreeDeltaListener listener) {
        }

        public void removeListener(Element dispatchTarget, DispatchedTreeDeltaListener listener) {
        }

        public void removeListener(UniqueName dispatchTargetUin, DispatchedTreeDeltaListener listener) {
        }

        public void modelChanged(ModelChangeEvent changeEvent) {
            throw new IllegalStateException();
        }

        public ModelDeltaNode[] getParentDeltaChain(ModelDeltaNode dispatchedDelta) {
            throw new IllegalStateException();
        }
    };
    private static HashMap ourInstances = new HashMap();
    private static Disposer ourDisposer;
    private Model myModel;
    private IDeltaDispatchingNode myDispatchingTreeRoot;
    private HashMap myCachedDispatchingNodes = new HashMap();
    private DefferedRemoveListeners myDefferedListenersToRemove = new DefferedRemoveListeners();
    private DefferedAddListeners myDefferedListenersToAdd = new DefferedAddListeners();
    private ModelDeltaNode myCachedRootDelta;

    private DeltaDispatcher() {
    }

    public static DeltaDispatcher getInstance(UniqueName modelUin) {
        DeltaDispatcher dispatcher = (DeltaDispatcher)ourInstances.get(modelUin);
        if (dispatcher == null) {
            Model model = ModelAccess.getModel((UniqueName)modelUin);
            if (model == null || model.isDeleted()) {
                return NULL_DISPATCHER;
            }
            dispatcher = new DeltaDispatcher();
            dispatcher.registered(ModelAccess.getModel((UniqueName)modelUin));
            ourInstances.put(modelUin, dispatcher);
        }
        if (ourDisposer == null) {
            ourDisposer = new Disposer();
            ModelAccess.addModelAccessListener((ModelAccessListener)ourDisposer);
        }
        return dispatcher;
    }

    protected static void dropInstance(Model model) {
        DeltaDispatcher dispatcher = (DeltaDispatcher)ourInstances.remove(model.getUniqueName());
        if (dispatcher != null) {
            dispatcher.unregistered(model);
        }
    }

    public synchronized void modelChanged(ModelChangeEvent changeEvent) {
        ModelDeltaNode rootDeltaNode = changeEvent.getRootDelta();
        if (rootDeltaNode == null) {
            return;
        }
        this.myCachedRootDelta = rootDeltaNode;
        try {
            if (rootDeltaNode.getElementUniqueName().equals(this.myDispatchingTreeRoot.getNodeUin())) {
                this.dispatchDelta(rootDeltaNode);
            }
            Object var4_3 = null;
            this.myCachedRootDelta = null;
            this.myDefferedListenersToRemove.processRemoving();
            this.myDefferedListenersToAdd.processAdd();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.myCachedRootDelta = null;
            this.myDefferedListenersToRemove.processRemoving();
            this.myDefferedListenersToAdd.processAdd();
            throw throwable;
        }
    }

    public void registerListener(Element dispatchTarget, DispatchedTreeDeltaListener listener) {
        if (this.myCachedRootDelta == null) {
            this.primRegisterListener(dispatchTarget, listener);
        } else {
            this.myDefferedListenersToAdd.addListenerLater(dispatchTarget, listener);
        }
    }

    private void primRegisterListener(Element dispatchTarget, DispatchedTreeDeltaListener listener) {
        if (dispatchTarget == null || dispatchTarget.isDeleted()) {
            return;
        }
        if (!this.myModel.equals(dispatchTarget.getModel())) {
            throw new IllegalArgumentException("can not register listener for element in other model \n dispatcher model : " + this.myModel.getUniqueName() + "\n element model : " + dispatchTarget.getModel().getUniqueName());
        }
        IDeltaDispatchingNode dispatchingNode = this.registerDispatchingPath(dispatchTarget);
        dispatchingNode.addListener(listener);
    }

    public void removeListener(Element dispatchTarget, DispatchedTreeDeltaListener listener) {
        this.removeListener(dispatchTarget.getUniqueName(), listener);
    }

    public void removeListener(UniqueName dispatchTargetUin, DispatchedTreeDeltaListener listener) {
        if (this.myCachedRootDelta == null) {
            this.primRemoveListener(dispatchTargetUin, listener);
        } else {
            this.myDefferedListenersToRemove.removeListenerLater(dispatchTargetUin, listener);
        }
    }

    private void primRemoveListener(UniqueName dispatchTargetUin, DispatchedTreeDeltaListener listener) {
        IDeltaDispatchingNode dispatchingNode = (IDeltaDispatchingNode)this.myCachedDispatchingNodes.get(dispatchTargetUin);
        if (dispatchingNode == null) {
            return;
        }
        dispatchingNode.removeListener(listener);
        this.removeUnusedNodes(dispatchingNode);
    }

    public ModelDeltaNode[] getParentDeltaChain(ModelDeltaNode dispatchedDelta) {
        Stack result;
        if (this.myCachedRootDelta == null) {
            System.err.println("ATTENTION: Root delta was not cached");
            return null;
        }
        if (dispatchedDelta == null) {
            System.err.println("ATTENTION: getParentDeltaChain called for null");
        }
        if (DeltaDispatcher.findChildDeltaNode(this.myCachedRootDelta, dispatchedDelta, result = new Stack())) {
            Assert.isLegal((result.get(0) == this.myCachedRootDelta ? 1 : 0) != 0);
            Assert.isLegal((result.get(result.size() - 1) == dispatchedDelta ? 1 : 0) != 0);
            return result.toArray(new ModelDeltaNode[result.size()]);
        }
        return null;
    }

    private static boolean findChildDeltaNode(ModelDeltaNode delta, ModelDeltaNode searchPattern, Stack collectedResult) {
        collectedResult.push(delta);
        if (delta == searchPattern) {
            return true;
        }
        Enumeration children = delta.changedChildren();
        while (children.hasMoreElements()) {
            ModelDeltaNode next = (ModelDeltaNode)children.nextElement();
            if (!DeltaDispatcher.findChildDeltaNode(next, searchPattern, collectedResult)) continue;
            return true;
        }
        collectedResult.pop();
        return false;
    }

    private void dispatchDelta(ModelDeltaNode rootModelDelta) {
        if (rootModelDelta.isTotallyChanged()) {
            this.notifyTotalUpdate(this.myDispatchingTreeRoot);
            return;
        }
        if (this.myDispatchingTreeRoot == null) {
            return;
        }
        if (this.toNextLevel(rootModelDelta, this.myDispatchingTreeRoot)) {
            this.handleMovedFromDeltas(rootModelDelta);
        }
    }

    private void handleMovedFromDeltas(ModelDeltaNode deltaNode) {
        if (DeltaDispatcher.isMovedFromDelta(deltaNode)) {
            this.hack(deltaNode);
        } else {
            Enumeration subDeltas = deltaNode.changedChildren();
            while (subDeltas.hasMoreElements()) {
                this.handleMovedFromDeltas((ModelDeltaNode)subDeltas.nextElement());
            }
        }
    }

    private void removeUnusedNodes(IDeltaDispatchingNode node) {
        if (node.haveChildren()) {
            return;
        }
        if (node.listeners().hasNext()) {
            return;
        }
        if (!node.equals(this.myDispatchingTreeRoot)) {
            UniqueName nodeUin = node.getNodeUin();
            IDeltaDispatchingNode parentNode = node.getParentNode();
            parentNode.removeChildNode(nodeUin);
            this.myCachedDispatchingNodes.remove(nodeUin);
            this.removeUnusedNodes(parentNode);
        }
    }

    private IDeltaDispatchingNode registerDispatchingPath(Element dispatchTarget) {
        UniqueName targetUin = dispatchTarget.getUniqueName();
        IDeltaDispatchingNode targetNode = (IDeltaDispatchingNode)this.myCachedDispatchingNodes.get(targetUin);
        if (targetNode != null) {
            return targetNode;
        }
        targetNode = new DeltaDispatchingNode(targetUin);
        Entity parent = dispatchTarget.getParent();
        if (parent == null) {
            throw new RuntimeException("can not find parent for element: " + targetUin);
        }
        IDeltaDispatchingNode parentDispatchingNode = this.registerDispatchingPath((Element)parent);
        parentDispatchingNode.addChildNode(targetNode);
        this.myCachedDispatchingNodes.put(targetUin, targetNode);
        return targetNode;
    }

    private boolean toNextLevel(ModelDeltaNode deltaNode, IDeltaDispatchingNode dispatchingNode) {
        Assert.isLegal((boolean)deltaNode.getElementUniqueName().equals(dispatchingNode.getNodeUin()), (String)"Synchronisation fails between model-delta tree and dispatching tree");
        if (deltaNode.isDeleted() && !DeltaDispatcher.isMovedFromDelta(deltaNode) && !DeltaDispatcher.containsMovedFromChild(deltaNode)) {
            this.notifyMissedDeletedChildren(dispatchingNode);
            this.clearListenersForMissedDeletedDelta(dispatchingNode);
            return false;
        }
        this.fireListeners(deltaNode, dispatchingNode);
        boolean result = false;
        Map missedDeletedChildren = deltaNode.isDeleted() ? DeltaDispatcher.collectChildrenInDispatchTree(dispatchingNode) : null;
        Enumeration changedModelChildren = deltaNode.changedChildren();
        while (changedModelChildren.hasMoreElements()) {
            IDeltaDispatchingNode childDispatchingNode;
            ModelDeltaNode curChildDeltaNode = (ModelDeltaNode)changedModelChildren.nextElement();
            UniqueName curChangedUin = curChildDeltaNode.getElementUniqueName();
            if (missedDeletedChildren != null) {
                missedDeletedChildren.remove(curChangedUin);
            }
            if ((childDispatchingNode = dispatchingNode.getChildNode(curChangedUin)) != null) {
                result = this.toNextLevel(curChildDeltaNode, childDispatchingNode) || result;
                continue;
            }
            this.removeUnusedNodes(dispatchingNode);
        }
        if (missedDeletedChildren != null && !missedDeletedChildren.isEmpty()) {
            Iterator allMissed = missedDeletedChildren.entrySet().iterator();
            while (allMissed.hasNext()) {
                Map.Entry nextEntry = allMissed.next();
                IDeltaDispatchingNode nextMissedNode = (IDeltaDispatchingNode)nextEntry.getValue();
                UniqueName nextMissedUin = (UniqueName)nextEntry.getKey();
                Element nextMissedElement = this.getModel().findElement(nextMissedUin);
                if (nextMissedElement != null && !nextMissedElement.isDeleted()) continue;
                this.notifyMissedDeletedChildren(nextMissedNode);
                this.clearListenersForMissedDeletedDelta(nextMissedNode);
            }
            missedDeletedChildren.clear();
        }
        missedDeletedChildren = null;
        return result || DeltaDispatcher.isMovedFromDelta(deltaNode);
    }

    private void clearListenersForMissedDeletedDelta(IDeltaDispatchingNode dispatchingNode) {
        if (this.myDispatchingTreeRoot.getNodeUin().equals(dispatchingNode.getNodeUin())) {
            return;
        }
        HashSet uinsBelow = new HashSet();
        HashSet listenersBelow = new HashSet();
        DeltaDispatcher.removeListenersBelow(dispatchingNode, listenersBelow, uinsBelow);
        Iterator uins = uinsBelow.iterator();
        while (uins.hasNext()) {
            UniqueName nextUin = (UniqueName)uins.next();
            this.myCachedDispatchingNodes.remove(nextUin);
        }
        if (dispatchingNode.getParentNode() != null) {
            dispatchingNode.getParentNode().removeChildNode(dispatchingNode.getNodeUin());
        }
    }

    private void notifyMissedDeletedChildren(IDeltaDispatchingNode dispatchingNode) {
        Enumeration children = dispatchingNode.childNodes();
        while (children.hasMoreElements()) {
            IDeltaDispatchingNode next = (IDeltaDispatchingNode)children.nextElement();
            this.notifyMissedDeletedChildren(next);
        }
        if (dispatchingNode.listeners().hasNext()) {
            UniqueName uin = dispatchingNode.getNodeUin();
            Entity deletedEntity = this.getModel().findEntity(uin);
            if (deletedEntity == null || deletedEntity.isDeleted()) {
                MissedDeletedDelta missedDeletedDelta = new MissedDeletedDelta(uin);
                Iterator listeners = dispatchingNode.listeners();
                while (listeners.hasNext()) {
                    DispatchedTreeDeltaListener next = (DispatchedTreeDeltaListener)listeners.next();
                    next.modelChanged(missedDeletedDelta);
                }
            }
        }
    }

    private void fireListeners(ModelDeltaNode deltaNode, IDeltaDispatchingNode dispatchingNode) {
        Iterator listeners = dispatchingNode.listeners();
        while (listeners.hasNext()) {
            DispatchedTreeDeltaListener curListener = (DispatchedTreeDeltaListener)listeners.next();
            curListener.modelChanged(deltaNode);
            if (!deltaNode.isDeleted()) continue;
            listeners.remove();
        }
    }

    private void registered(Model model) {
        this.myModel = model;
        this.myModel.addModelDeltaListener((ModelChangeListener)this);
        this.myDispatchingTreeRoot = new DeltaDispatchingNode(this.myModel.getUniqueName());
        this.myCachedDispatchingNodes.put(this.myModel.getUniqueName(), this.myDispatchingTreeRoot);
    }

    private void unregistered(Model model) {
        Assert.isLegal((model != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)model.getUniqueName().equals(this.myModel.getUniqueName()));
        if (this.myModel != null) {
            this.myModel.removeModelDeltaListener((ModelChangeListener)this);
            this.myModel = null;
        }
        this.myDispatchingTreeRoot = null;
        this.myCachedDispatchingNodes.clear();
        this.myCachedDispatchingNodes = null;
    }

    private void notifyTotalUpdate(IDeltaDispatchingNode dispatchingNode) {
        TotalUpdateDeltaNode totalUpdateDeltaNode = new TotalUpdateDeltaNode(this.myModel, dispatchingNode.getNodeUin());
        totalUpdateDeltaNode.setTotalUpdateRequired();
        this.fireListeners((ModelDeltaNode)totalUpdateDeltaNode, dispatchingNode);
        Enumeration childDispatchingNodes = dispatchingNode.childNodes();
        while (childDispatchingNodes.hasMoreElements()) {
            IDeltaDispatchingNode curChild = (IDeltaDispatchingNode)childDispatchingNodes.nextElement();
            this.notifyTotalUpdate(curChild);
        }
    }

    private void hack(ModelDeltaNode delta) {
        IDeltaDispatchingNode dispatchingNode = (IDeltaDispatchingNode)this.myCachedDispatchingNodes.get(delta.getElementUniqueName());
        if (dispatchingNode == null || dispatchingNode == this.myDispatchingTreeRoot) {
            return;
        }
        HashSet cachedListenersBelow = new HashSet();
        HashSet uinsBelow = new HashSet();
        DeltaDispatcher.removeListenersBelow(dispatchingNode, cachedListenersBelow, uinsBelow);
        this.myCachedDispatchingNodes.keySet().removeAll(uinsBelow);
        IDeltaDispatchingNode parent = dispatchingNode.getParentNode();
        if (parent != null) {
            parent.removeChildNode(dispatchingNode.getNodeUin());
        }
        Iterator listeners = cachedListenersBelow.iterator();
        while (listeners.hasNext()) {
            DispatchedTreeDeltaListener next = (DispatchedTreeDeltaListener)listeners.next();
            next.dispatchingChainCorrupted(delta);
        }
    }

    private static void removeListenersBelow(IDeltaDispatchingNode dispatchingNode, Collection listeners, Collection uins) {
        uins.add(dispatchingNode.getNodeUin());
        Iterator it = dispatchingNode.listeners();
        while (it.hasNext()) {
            listeners.add(it.next());
            it.remove();
        }
        Enumeration children = dispatchingNode.childNodes();
        while (children.hasMoreElements()) {
            IDeltaDispatchingNode next = (IDeltaDispatchingNode)children.nextElement();
            DeltaDispatcher.removeListenersBelow(next, listeners, uins);
        }
    }

    private static boolean isMovedFromDelta(ModelDeltaNode deltaNode) {
        if (deltaNode.isDeleted()) {
            UniqueName movedToUin = deltaNode.getOriginalElementUniqueName();
            return movedToUin != null && !movedToUin.equals(deltaNode.getElementUniqueName());
        }
        return false;
    }

    private static boolean containsMovedFromChild(ModelDeltaNode deltaNode) {
        Enumeration subDeltas = deltaNode.changedChildren();
        while (subDeltas.hasMoreElements()) {
            ModelDeltaNode next = (ModelDeltaNode)subDeltas.nextElement();
            if (DeltaDispatcher.isMovedFromDelta(next)) {
                return true;
            }
            if (!DeltaDispatcher.containsMovedFromChild(next)) continue;
            return true;
        }
        return false;
    }

    private Model getModel() {
        return this.myModel;
    }

    private static Map collectChildrenInDispatchTree(IDeltaDispatchingNode dispatchingNode) {
        HashMap<UniqueName, IDeltaDispatchingNode> result = new HashMap<UniqueName, IDeltaDispatchingNode>();
        Enumeration childNodes = dispatchingNode.childNodes();
        while (childNodes.hasMoreElements()) {
            IDeltaDispatchingNode nextChild = (IDeltaDispatchingNode)childNodes.nextElement();
            result.put(nextChild.getNodeUin(), nextChild);
        }
        return result;
    }

    private class DefferedAddListeners {
        private HashMap myListenersMap;

        private DefferedAddListeners() {
        }

        public void processAdd() {
            Assert.isLegal((DeltaDispatcher.this.myCachedRootDelta == null ? 1 : 0) != 0);
            if (this.myListenersMap == null) {
                return;
            }
            Iterator entries = this.myListenersMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry nextEntry = entries.next();
                Element nextTarget = (Element)nextEntry.getKey();
                Collection listenersSet = (Collection)nextEntry.getValue();
                Iterator listeners = listenersSet.iterator();
                while (listeners.hasNext()) {
                    DispatchedTreeDeltaListener nextListener = (DispatchedTreeDeltaListener)listeners.next();
                    DeltaDispatcher.this.primRegisterListener(nextTarget, nextListener);
                }
            }
            this.myListenersMap.clear();
            this.myListenersMap = null;
        }

        public void addListenerLater(Element dispatchTarget, DispatchedTreeDeltaListener listener) {
            HashSet<DispatchedTreeDeltaListener> allListeners;
            if (this.myListenersMap == null) {
                this.myListenersMap = new HashMap();
            }
            if ((allListeners = (HashSet<DispatchedTreeDeltaListener>)this.myListenersMap.get(dispatchTarget)) == null) {
                allListeners = new HashSet<DispatchedTreeDeltaListener>();
                this.myListenersMap.put(dispatchTarget, allListeners);
            }
            allListeners.add(listener);
        }
    }

    private class DefferedRemoveListeners {
        private HashMap myListenersMap;

        private DefferedRemoveListeners() {
        }

        public void processRemoving() {
            Assert.isLegal((DeltaDispatcher.this.myCachedRootDelta == null ? 1 : 0) != 0);
            if (this.myListenersMap == null) {
                return;
            }
            Iterator entries = this.myListenersMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry nextEntry = entries.next();
                UniqueName nextTargetUin = (UniqueName)nextEntry.getKey();
                Collection listenersSet = (Collection)nextEntry.getValue();
                Iterator listeners = listenersSet.iterator();
                while (listeners.hasNext()) {
                    DispatchedTreeDeltaListener nextListener = (DispatchedTreeDeltaListener)listeners.next();
                    DeltaDispatcher.this.primRemoveListener(nextTargetUin, nextListener);
                }
            }
            this.myListenersMap.clear();
            this.myListenersMap = null;
        }

        public void removeListenerLater(UniqueName dispatchTargetUin, DispatchedTreeDeltaListener listener) {
            HashSet<DispatchedTreeDeltaListener> allListeners;
            if (this.myListenersMap == null) {
                this.myListenersMap = new HashMap();
            }
            if ((allListeners = (HashSet<DispatchedTreeDeltaListener>)this.myListenersMap.get(dispatchTargetUin)) == null) {
                allListeners = new HashSet<DispatchedTreeDeltaListener>();
                this.myListenersMap.put(dispatchTargetUin, allListeners);
            }
            allListeners.add(listener);
        }
    }

    private static class Disposer
    implements ModelAccessListener {
        private Disposer() {
        }

        public void modelCreated(ModelAccessEvent event) {
        }

        public void modelRemoved(ModelAccessEvent event) {
            Model model = event.getModel();
            if (model != null) {
                DeltaDispatcher.dropInstance(model);
            }
        }
    }
}

