/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.update.diagram;

import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.model.update.diagram.IUpdatableElement;
import com.tssap.selena.model.update.diagram.IUpdatableLink;
import com.tssap.selena.model.update.diagram.IUpdatableNode;
import com.tssap.selena.model.update.hierarchy.SingleDiagramUpdater;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class DiagramFactory {
    private static DiagramFactory myImplementation = null;

    protected static void setImplementation(DiagramFactory implementation) {
        if (implementation == null) {
            throw new NullPointerException("DiagramFactory: can not set null implementation");
        }
        myImplementation = implementation;
    }

    public static IDiagram createDiagram(SingleDiagramUpdater updater, IProgressMonitor pm) {
        if (myImplementation == null) {
            throw new NullPointerException("DiagramFactory: implementation was not setted");
        }
        return myImplementation.internalCreateDiagram(updater, updater.getReferenceCollection(), pm);
    }

    public static IUpdatableNode createNode(IUpdatableNode parent, Reference model) {
        if (myImplementation == null) {
            throw new NullPointerException("DiagramFactory: implementation was not setted");
        }
        return myImplementation.internalCreateNode(parent, model);
    }

    public static IUpdatableLink createLink(IUpdatableNode parentAndSource, IUpdatableElement target, Reference model) {
        if (myImplementation == null) {
            throw new NullPointerException("DiagramFactory: implementation was not setted");
        }
        return myImplementation.internalCreateLink(parentAndSource, target, model);
    }

    protected abstract IUpdatableNode internalCreateNode(IUpdatableNode var1, Reference var2);

    protected abstract IUpdatableLink internalCreateLink(IUpdatableNode var1, IUpdatableElement var2, Reference var3);

    protected abstract IDiagram internalCreateDiagram(SingleDiagramUpdater var1, ReferenceCollection var2, IProgressMonitor var3);
}

