/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.update;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

public class UpdatePlugin
extends Plugin {
    private static UpdatePlugin myself;
    private HashMap myTimers = new HashMap();

    public UpdatePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        myself = this;
    }

    public void startup() {
    }

    public static UpdatePlugin getInstance() {
        return myself;
    }

    public void shutdown() {
        Iterator it = this.myTimers.keySet().iterator();
        while (it.hasNext()) {
            String next = (String)it.next();
            System.out.println(next + ": " + this.myTimers.get(next));
        }
    }

    public void start(String key) {
        Timer timer = (Timer)this.myTimers.get(key);
        if (timer == null) {
            timer = new Timer();
            this.myTimers.put(key, timer);
        }
        timer.start();
    }

    public void stop(String key) {
        ((Timer)this.myTimers.get(key)).stop();
    }

    private static class Timer {
        private long[] myFirst50 = new long[51];
        private int count;
        private long time;
        private int isCounting;

        private Timer() {
        }

        public void start() {
            if (this.isCounting == 0) {
                this.time -= System.currentTimeMillis();
            }
            ++this.isCounting;
        }

        public void stop() {
            --this.isCounting;
            if (this.isCounting == 0) {
                this.time += System.currentTimeMillis();
                if (this.count < 50) {
                    this.myFirst50[this.count + 1] = this.time;
                }
                ++this.count;
            }
        }

        public String toString() {
            if (this.isCounting == 0) {
                String result = "counted " + this.count + " times, total time=" + this.time + "\n first 50:\n";
                int i = 1;
                while (i < Math.min(51, this.count)) {
                    result = result + "" + (this.myFirst50[i] - this.myFirst50[i - 1]) + ", ";
                    if (i % 10 == 0) {
                        result = result + "\n";
                    }
                    ++i;
                }
                return result;
            }
            return "invalid counter: counted " + this.count + " times";
        }
    }
}

