/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.metadata.core;

import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleGroupDescriptor;
import com.sap.tc.col.client.metadata.core.AbstractDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.GroupDescriptor;
import com.sap.tc.col.client.metadata.core.QueryDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleDescriptor;
import java.util.Collection;
import java.util.HashMap;

public class ServiceModuleGroupDescriptor
extends GroupDescriptor
implements IServiceModuleGroupDescriptor {
    private HashMap mAspects;
    private HashMap mQueries;
    private ServiceModuleDescriptor mModuleDescriptor;
    private AspectDescriptor aspectDescriptor;

    public ServiceModuleGroupDescriptor(String name, ServiceModuleDescriptor moduleDescriptor) {
        super(name);
        this.mModuleDescriptor = moduleDescriptor;
        moduleDescriptor.addModuleGroupDescriptor(this);
        this.mAspects = new HashMap();
        this.mQueries = new HashMap();
    }

    public void addDescriptor(AbstractDescriptor descriptor) {
        if (descriptor instanceof AspectDescriptor) {
            this.addAspectDescriptor((AspectDescriptor)descriptor);
        } else if (descriptor instanceof QueryDescriptor) {
            this.addQueryDescriptor((QueryDescriptor)descriptor);
        } else {
            throw new IllegalArgumentException("Descriptor type " + descriptor.getClass().getName() + " not allowed for service module groups");
        }
    }

    public AbstractDescriptor getDescriptor(String name) {
        AbstractDescriptor desc = (AspectDescriptor)this.getAspectDescriptor(name);
        if (desc == null) {
            desc = (QueryDescriptor)this.getQueryDescriptor(name);
        }
        return desc;
    }

    public AbstractDescriptor[] getDescriptors() {
        Collection allDescriptors = this.mAspects.values();
        allDescriptors.addAll(this.mQueries.values());
        AbstractDescriptor[] descriptors = new AbstractDescriptor[allDescriptors.size()];
        allDescriptors.toArray(descriptors);
        return descriptors;
    }

    public void addAspectDescriptor(AspectDescriptor aspect) {
        this.mAspects.put(aspect.getName(), aspect);
    }

    public IAspectDescriptor getAspectDescriptor(String aspectname) {
        return (IAspectDescriptor)this.mAspects.get(aspectname);
    }

    public IAspectDescriptor[] getAspectDescriptors() {
        IAspectDescriptor[] descriptors = new AspectDescriptor[this.mAspects.size()];
        this.mAspects.values().toArray(descriptors);
        return descriptors;
    }

    public void addQueryDescriptor(QueryDescriptor query) {
        this.mQueries.put(query.getName(), query);
    }

    public IQueryDescriptor getQueryDescriptor(String queryname) {
        return (IQueryDescriptor)this.mQueries.get(queryname);
    }

    public IQueryDescriptor[] getQueryDescriptors() {
        IQueryDescriptor[] descriptors = new QueryDescriptor[this.mQueries.size()];
        this.mQueries.values().toArray(descriptors);
        return descriptors;
    }
}

