/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.metadata.core;

import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleGroupDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.client.metadata.core.AbstractDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.KeyAspectDescriptor;
import com.sap.tc.col.client.metadata.core.QueryDescriptor;
import com.sap.tc.col.client.metadata.core.RelationDescriptor;
import com.sap.tc.col.client.metadata.core.ServiceModuleGroupDescriptor;
import com.sap.tc.col.client.metadata.core.StructureDescriptor;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class ServiceModuleDescriptor
extends AbstractDescriptor
implements IServiceModuleDescriptor {
    private HashMap mAttributes = new HashMap();
    private Locale mLocale;
    private StructureDescriptor mRelationIndexStructure = null;
    private StructureDescriptor mInputFieldsStructure = null;
    private StructureDescriptor mMessageStructure = null;
    private StructureDescriptor mReturnCodeStructure = null;
    private StructureDescriptor mInputOptionsStructure = null;
    private StructureDescriptor mSortingOptionsStructure = null;
    private StructureDescriptor mSelectionsStructure = null;
    private String mConfiguration;
    private String mConfigurationDescription;
    private String description;
    private HashMap queries = new HashMap();
    private HashMap relations = new HashMap();
    private HashMap aspectDescriptors = new HashMap();
    private HashMap mModuleGroups = new HashMap();

    public ServiceModuleDescriptor(String name, String description, String configuration, String configurationDescription, Locale locale) {
        super(name);
        this.description = description;
        this.mConfiguration = configuration;
        this.mConfigurationDescription = configurationDescription;
        this.mLocale = locale;
    }

    public String getDescription() {
        return this.description;
    }

    public void addQueryDescriptor(QueryDescriptor queryDescriptor) {
        if (queryDescriptor != null) {
            this.queries.put(queryDescriptor.getName(), queryDescriptor);
        }
    }

    public IQueryDescriptor[] getQueryDescriptors() {
        IQueryDescriptor[] tmpArr = new QueryDescriptor[this.queries.size()];
        this.queries.values().toArray(tmpArr);
        return tmpArr;
    }

    public IQueryDescriptor getQueryDescriptor(String name) {
        return (IQueryDescriptor)this.queries.get(name);
    }

    public void addRelationDescriptor(RelationDescriptor relationDescriptor) {
        AspectDescriptor srcasp;
        if (relationDescriptor != null) {
            this.relations.put(relationDescriptor.getName(), relationDescriptor);
            relationDescriptor.setServiceModuleDescriptor(this);
        }
        if ((srcasp = (AspectDescriptor)this.getAspectDescriptor(relationDescriptor.getSourceAspectDescriptor().getName())) != null) {
            srcasp.addRelationDescriptor(relationDescriptor);
        }
    }

    public IRelationDescriptor[] getRelationDescriptors() {
        IRelationDescriptor[] tmpArr = new RelationDescriptor[this.relations.size()];
        this.relations.values().toArray(tmpArr);
        return tmpArr;
    }

    public IRelationDescriptor getRelationDescriptor(String name) {
        return (IRelationDescriptor)this.relations.get(name);
    }

    void addAspectDescriptor(AspectDescriptor aspectDescriptor) {
        if (aspectDescriptor != null && this.getAspectDescriptor(aspectDescriptor.getName()) != aspectDescriptor) {
            this.aspectDescriptors.put(aspectDescriptor.getName(), aspectDescriptor);
        }
    }

    public IAspectDescriptor[] getAspectDescriptors() {
        IAspectDescriptor[] tmpArr = new AspectDescriptor[this.aspectDescriptors.size()];
        this.aspectDescriptors.values().toArray(tmpArr);
        return tmpArr;
    }

    public IKeyAspectDescriptor[] getKeyAspectDescriptors() {
        HashSet<IKeyAspectDescriptor> tmpSet = new HashSet<IKeyAspectDescriptor>();
        Iterator it = this.aspectDescriptors.values().iterator();
        while (it.hasNext()) {
            AspectDescriptor descriptor = (AspectDescriptor)it.next();
            if (descriptor == null) continue;
            tmpSet.add(descriptor.getKeyDescriptor());
        }
        IKeyAspectDescriptor[] tmpArr = new KeyAspectDescriptor[tmpSet.size()];
        ((AbstractCollection)tmpSet).toArray(tmpArr);
        return tmpArr;
    }

    public IKeyAspectDescriptor getKeyAspectDescriptor(String aspectName) {
        IKeyAspectDescriptor[] keyDescriptors = this.getKeyAspectDescriptors();
        IKeyAspectDescriptor keyDescriptor = null;
        int i = 0;
        while (i < keyDescriptors.length) {
            keyDescriptor = keyDescriptors[i];
            if (keyDescriptor.getName().equals(aspectName)) {
                return keyDescriptor;
            }
            ++i;
        }
        return null;
    }

    public IAspectDescriptor getAspectDescriptor(String aspectName) {
        return (IAspectDescriptor)this.aspectDescriptors.get(aspectName);
    }

    public void addAttribute(String attributeName, String value) {
        this.mAttributes.put(attributeName, value);
    }

    public String getAttributeStringValue(String attributeName) {
        return (String)this.mAttributes.get(attributeName);
    }

    public String[] getAttributeNames() {
        String[] attributes = new String[this.mAttributes.size()];
        this.mAttributes.keySet().toArray(attributes);
        return attributes;
    }

    public void addModuleGroupDescriptor(ServiceModuleGroupDescriptor aModuleGroupDescriptor) {
        if (aModuleGroupDescriptor != null) {
            this.mModuleGroups.put(aModuleGroupDescriptor.getName(), aModuleGroupDescriptor);
        }
    }

    public IServiceModuleGroupDescriptor getServiceModuleGroupDescriptor(String name) {
        return (IServiceModuleGroupDescriptor)this.mModuleGroups.get(name);
    }

    public IServiceModuleGroupDescriptor[] getServiceModuleGroupDescriptors() {
        IServiceModuleGroupDescriptor[] groupDescriptors = new ServiceModuleGroupDescriptor[this.mModuleGroups.size()];
        this.mModuleGroups.values().toArray(groupDescriptors);
        return groupDescriptors;
    }

    public IStructureDescriptor getRelationIndexStructure() {
        if (this.mRelationIndexStructure == null) {
            this.mRelationIndexStructure = new StructureDescriptor(this, "SCOOL_RELATION_INDEX", new FieldDescriptor[]{new FieldDescriptor("INRECORD", "INTEGER"), new FieldDescriptor("OUTRECORD", "INTEGER")});
        }
        return this.mRelationIndexStructure;
    }

    public IStructureDescriptor getInputFieldsStructure() {
        if (this.mInputFieldsStructure == null) {
            this.mInputFieldsStructure = new StructureDescriptor(this, "SCOL_UPDATE_FIELDS", new FieldDescriptor[]{new FieldDescriptor("INKEY", "INTEGER"), new FieldDescriptor("FIELDNAME", "STRING")});
        }
        return this.mInputFieldsStructure;
    }

    public IStructureDescriptor getMessageStructure() {
        if (this.mMessageStructure == null) {
            this.mMessageStructure = new StructureDescriptor(this, "SCOL_MESSAGE_TRANSPORT", new FieldDescriptor[]{new FieldDescriptor("INRECORD", "INTEGER"), new FieldDescriptor("FAILED", "BOOLEAN"), new FieldDescriptor("MESSAGE_TYPE", "STRING"), new FieldDescriptor("MESSAGE_CODE", "STRING"), new FieldDescriptor("MESSAGE_TEXT", "STRING"), new FieldDescriptor("MESSAGE_VARS", "STRING"), new FieldDescriptor("EXTENSION", "STRING"), new FieldDescriptor("ASPECT_NAME", "STRING"), new FieldDescriptor("ASPECT_KEY", "STRING"), new FieldDescriptor("ASPECT_FIELD", "STRING"), new FieldDescriptor("MESSAGE_CATEGORY", "INTEGER")});
        }
        return this.mMessageStructure;
    }

    public IStructureDescriptor getReturnCodeStructure() {
        if (this.mReturnCodeStructure == null) {
            this.mReturnCodeStructure = new StructureDescriptor(this, "SCOL_RETURN_CODE", new FieldDescriptor[]{new FieldDescriptor("INRECORD", "INTEGER"), new FieldDescriptor("FAILED", "BOOLEAN")});
        }
        return this.mReturnCodeStructure;
    }

    Locale getLocale() {
        return this.mLocale;
    }

    public void clearAspectRowAttributes() {
        Iterator aspIt = this.aspectDescriptors.values().iterator();
        while (aspIt.hasNext()) {
            AspectDescriptor asp = (AspectDescriptor)aspIt.next();
            asp.clearRowAttributes();
        }
    }

    public String getConfigurationDescription() {
        return this.mConfigurationDescription;
    }

    public String getConfigurationName() {
        return this.mConfiguration;
    }

    public IStructureDescriptor getInputOptionsStructure() {
        if (this.mInputOptionsStructure == null) {
            this.mInputOptionsStructure = new StructureDescriptor(this, "SCOL_QUERY_OPTIONS_ROWS", new FieldDescriptor[]{new FieldDescriptor("ROWS", "INTEGER"), new FieldDescriptor("PAGE_MODE", "STRING"), new FieldDescriptor("QUERY_ID", "STRING"), new FieldDescriptor("START_ROW", "INTEGER")});
        }
        return this.mInputOptionsStructure;
    }

    public IStructureDescriptor getSortingOptionsStructure() {
        if (this.mSortingOptionsStructure == null) {
            this.mSortingOptionsStructure = new StructureDescriptor(this, "SCOL_SORTING_LINE", new FieldDescriptor[]{new FieldDescriptor("FIELD", "STRING")});
        }
        return this.mSortingOptionsStructure;
    }

    public IStructureDescriptor getSelectionsStructure() {
        if (this.mSelectionsStructure == null) {
            this.mSelectionsStructure = new StructureDescriptor(this, "SCOL_SELECTION", new FieldDescriptor[]{new FieldDescriptor("FIELDNAME", "STRING"), new FieldDescriptor("OPTION", "STRING"), new FieldDescriptor("LOW", "STRING"), new FieldDescriptor("HIGH", "STRING")});
        }
        return this.mSelectionsStructure;
    }
}

