/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.col.client.metadata.core;

import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectGroupDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.core.AbstractDescriptor;
import com.sap.tc.col.client.metadata.core.AspectActionDescriptor;
import com.sap.tc.col.client.metadata.core.AspectDescriptor;
import com.sap.tc.col.client.metadata.core.FieldDescriptor;
import com.sap.tc.col.client.metadata.core.GroupDescriptor;
import com.sap.tc.col.client.metadata.core.RelationDescriptor;
import java.util.Collection;
import java.util.HashMap;

public class AspectGroupDescriptor
extends GroupDescriptor
implements IAspectGroupDescriptor {
    private HashMap mFields;
    private HashMap mRelations;
    private HashMap mActions;
    private AspectDescriptor mAspectDescriptor;

    public AspectGroupDescriptor(String name, AspectDescriptor aspectDescriptor) {
        super(name);
        this.mAspectDescriptor = aspectDescriptor;
        aspectDescriptor.addAspectGroupDescriptor(this);
        this.mFields = new HashMap();
        this.mRelations = new HashMap();
        this.mActions = new HashMap();
    }

    public AspectDescriptor getAspectDescriptor() {
        return this.mAspectDescriptor;
    }

    public void addDescriptor(AbstractDescriptor descriptor) {
        if (descriptor instanceof FieldDescriptor) {
            this.addFieldDescriptor((FieldDescriptor)descriptor);
        } else if (descriptor instanceof RelationDescriptor) {
            this.addRelationDescriptor((RelationDescriptor)descriptor);
        } else if (descriptor instanceof AspectActionDescriptor) {
            this.addAspectActionDescriptor((AspectActionDescriptor)descriptor);
        } else {
            throw new IllegalArgumentException("Descriptor type " + descriptor.getClass().getName() + " not allowed for aspect groups");
        }
    }

    public AbstractDescriptor getDescriptor(String name) {
        AbstractDescriptor desc = (FieldDescriptor)this.getFieldDescriptor(name);
        if (desc == null) {
            desc = (RelationDescriptor)this.getRelationDescriptor(name);
        }
        if (desc == null) {
            desc = (AspectActionDescriptor)this.getAspectActionDescriptor(name);
        }
        return desc;
    }

    public AbstractDescriptor[] getDescriptors() {
        Collection allDescriptors = this.mFields.values();
        allDescriptors.addAll(this.mRelations.values());
        allDescriptors.addAll(this.mActions.values());
        AbstractDescriptor[] descriptors = new AbstractDescriptor[allDescriptors.size()];
        allDescriptors.toArray(descriptors);
        return descriptors;
    }

    public void addFieldDescriptor(FieldDescriptor field) {
        this.mFields.put(field.getName(), field);
    }

    public IFieldDescriptor getFieldDescriptor(String fieldname) {
        return (FieldDescriptor)this.mFields.get(fieldname);
    }

    public IFieldDescriptor[] getFieldDescriptors() {
        IFieldDescriptor[] descriptors = new FieldDescriptor[this.mFields.size()];
        this.mFields.values().toArray(descriptors);
        return descriptors;
    }

    public void addRelationDescriptor(RelationDescriptor relation) {
        this.mRelations.put(relation.getName(), relation);
    }

    public IRelationDescriptor getRelationDescriptor(String relationname) {
        return (IRelationDescriptor)this.mRelations.get(relationname);
    }

    public IRelationDescriptor[] getRelationDescriptors() {
        IRelationDescriptor[] descriptors = new RelationDescriptor[this.mRelations.size()];
        this.mRelations.values().toArray(descriptors);
        return descriptors;
    }

    public void addAspectActionDescriptor(AspectActionDescriptor aspectAction) {
        this.mActions.put(aspectAction.getName(), aspectAction);
    }

    public IAspectActionDescriptor getAspectActionDescriptor(String actionname) {
        return (AspectActionDescriptor)this.mActions.get(actionname);
    }

    public IAspectActionDescriptor[] getAspectActionDescriptors() {
        IAspectActionDescriptor[] descriptors = new AspectActionDescriptor[this.mActions.size()];
        this.mActions.values().toArray(descriptors);
        return descriptors;
    }
}

