/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sap.pj.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    private static final long oldSerialVersionUID = 7227256952085334351L;
    private static final long newSerialVersionUID = 2504952983494636987L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myName", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("myIsReadableFlg", Boolean.TYPE), new ObjectStreamField("myIsWritableFlg", Boolean.TYPE), new ObjectStreamField("myDescription", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("myMinDegree", Integer.TYPE), new ObjectStreamField("myMaxDegree", Integer.TYPE), new ObjectStreamField("myRefMBeanClassName", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("isReadable", Boolean.TYPE), new ObjectStreamField("isWritable", Boolean.TYPE), new ObjectStreamField("description", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("minDegree", Integer.TYPE), new ObjectStreamField("maxDegree", Integer.TYPE), new ObjectStreamField("referencedMBeanClassName", class$java$lang$String == null ? (class$java$lang$String = RoleInfo.class$("java.lang.String")) : class$java$lang$String)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    public static int ROLE_CARDINALITY_INFINITY;
    private String name = null;
    private boolean isReadable;
    private boolean isWritable;
    private String description = null;
    private int minDegree;
    private int maxDegree;
    private String referencedMBeanClassName = null;
    static /* synthetic */ Class class$java$lang$String;

    public RoleInfo(String theName, String theRefMBeanClassName, boolean theIsReadable, boolean theIsWritable, int theMinDegree, int theMaxDegree, String theDescription) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        this.init(theName, theRefMBeanClassName, theIsReadable, theIsWritable, theMinDegree, theMaxDegree, theDescription);
    }

    public RoleInfo(String theName, String theRefMBeanClassName, boolean theIsReadable, boolean theIsWritable) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(theName, theRefMBeanClassName, theIsReadable, theIsWritable, 1, 1, null);
        }
        catch (InvalidRoleInfoException exc) {
            // empty catch block
        }
    }

    public RoleInfo(String theName, String theRefMBeanClassName) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(theName, theRefMBeanClassName, true, true, 1, 1, null);
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public RoleInfo(RoleInfo theRoleInfo) throws IllegalArgumentException {
        if (theRoleInfo == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        try {
            this.init(theRoleInfo.getName(), theRoleInfo.getRefMBeanClassName(), theRoleInfo.isReadable(), theRoleInfo.isWritable(), theRoleInfo.getMinDegree(), theRoleInfo.getMaxDegree(), theRoleInfo.getDescription());
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public String getRefMBeanClassName() {
        return this.referencedMBeanClassName;
    }

    public boolean checkMinDegree(int theValue) {
        return theValue >= ROLE_CARDINALITY_INFINITY && (this.minDegree == ROLE_CARDINALITY_INFINITY || theValue >= this.minDegree);
    }

    public boolean checkMaxDegree(int theValue) {
        return theValue >= ROLE_CARDINALITY_INFINITY && (this.maxDegree == ROLE_CARDINALITY_INFINITY || theValue != ROLE_CARDINALITY_INFINITY && theValue <= this.maxDegree);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("role info name: " + this.name);
        result.append("; isReadable: " + this.isReadable);
        result.append("; isWritable: " + this.isWritable);
        result.append("; description: " + this.description);
        result.append("; minimum degree: " + this.minDegree);
        result.append("; maximum degree: " + this.maxDegree);
        result.append("; MBean class: " + this.referencedMBeanClassName);
        return result.toString();
    }

    private void init(String theName, String theRefMBeanClassName, boolean theIsReadable, boolean theIsWritable, int theMinDegree, int theMaxDegree, String theDescription) throws IllegalArgumentException, InvalidRoleInfoException {
        if (theName == null || theRefMBeanClassName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        this.name = theName;
        this.isReadable = theIsReadable;
        this.isWritable = theIsWritable;
        if (theDescription != null) {
            this.description = theDescription;
        }
        boolean invalidRoleInfoFlg = false;
        StringBuffer excMsgStrB = new StringBuffer();
        if (theMaxDegree != ROLE_CARDINALITY_INFINITY && (theMinDegree == ROLE_CARDINALITY_INFINITY || theMinDegree > theMaxDegree)) {
            excMsgStrB.append("Minimum degree ");
            excMsgStrB.append(theMinDegree);
            excMsgStrB.append(" is greater than maximum degree ");
            excMsgStrB.append(theMaxDegree);
            invalidRoleInfoFlg = true;
        } else if (theMinDegree < ROLE_CARDINALITY_INFINITY || theMaxDegree < ROLE_CARDINALITY_INFINITY) {
            excMsgStrB.append("Minimum or maximum degree has an illegal value, must be [0, ROLE_CARDINALITY_INFINITY].");
            invalidRoleInfoFlg = true;
        }
        if (invalidRoleInfoFlg) {
            throw new InvalidRoleInfoException(excMsgStrB.toString());
        }
        this.minDegree = theMinDegree;
        this.maxDegree = theMaxDegree;
        this.referencedMBeanClassName = theRefMBeanClassName;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.name = (String)fields.get("myName", null);
            if (fields.defaulted("myName")) {
                throw new NullPointerException("myName");
            }
            this.isReadable = fields.get("myIsReadableFlg", false);
            if (fields.defaulted("myIsReadableFlg")) {
                throw new NullPointerException("myIsReadableFlg");
            }
            this.isWritable = fields.get("myIsWritableFlg", false);
            if (fields.defaulted("myIsWritableFlg")) {
                throw new NullPointerException("myIsWritableFlg");
            }
            this.description = (String)fields.get("myDescription", null);
            if (fields.defaulted("myDescription")) {
                throw new NullPointerException("myDescription");
            }
            this.minDegree = fields.get("myMinDegree", 0);
            if (fields.defaulted("myMinDegree")) {
                throw new NullPointerException("myMinDegree");
            }
            this.maxDegree = fields.get("myMaxDegree", 0);
            if (fields.defaulted("myMaxDegree")) {
                throw new NullPointerException("myMaxDegree");
            }
            this.referencedMBeanClassName = (String)fields.get("myRefMBeanClassName", null);
            if (fields.defaulted("myRefMBeanClassName")) {
                throw new NullPointerException("myRefMBeanClassName");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myName", this.name);
            fields.put("myIsReadableFlg", this.isReadable);
            fields.put("myIsWritableFlg", this.isWritable);
            fields.put("myDescription", this.description);
            fields.put("myMinDegree", this.minDegree);
            fields.put("myMaxDegree", this.maxDegree);
            fields.put("myRefMBeanClassName", this.referencedMBeanClassName);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = (String)AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 7227256952085334351L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 2504952983494636987L;
        }
        ROLE_CARDINALITY_INFINITY = -1;
    }
}

