/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sap.pj.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    private static final long oldSerialVersionUID = -8179019472410837190L;
    private static final long newSerialVersionUID = 4611072955724144607L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myTypeName", class$java$lang$String == null ? (class$java$lang$String = RelationTypeSupport.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("myRoleName2InfoMap", class$java$util$HashMap == null ? (class$java$util$HashMap = RelationTypeSupport.class$("java.util.HashMap")) : class$java$util$HashMap), new ObjectStreamField("myIsInRelServFlg", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("typeName", class$java$lang$String == null ? (class$java$lang$String = RelationTypeSupport.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("roleName2InfoMap", class$java$util$Map == null ? (class$java$util$Map = RelationTypeSupport.class$("java.util.Map")) : class$java$util$Map), new ObjectStreamField("isInRelationService", Boolean.TYPE)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String typeName = null;
    private Map roleName2InfoMap = new HashMap();
    private boolean isInRelationService = false;
    private static String localClassName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$Map;

    public RelationTypeSupport(String theRelTypeName, RoleInfo[] theRoleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRelTypeName == null || theRoleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", theRelTypeName);
        }
        this.initMembers(theRelTypeName, theRoleInfoArray);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    protected RelationTypeSupport(String theRelTypeName) {
        if (theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("Protected constructor: entering", theRelTypeName);
        }
        this.typeName = theRelTypeName;
        if (this.isTraceOn()) {
            this.trace("Protected constructor: exiting", null);
        }
    }

    public String getRelationTypeName() {
        return this.typeName;
    }

    public List getRoleInfos() {
        return new ArrayList(this.roleName2InfoMap.values());
    }

    public RoleInfo getRoleInfo(String theRoleInfoName) throws IllegalArgumentException, RoleInfoNotFoundException {
        RoleInfo result;
        if (theRoleInfoName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: entering", theRoleInfoName);
        }
        if ((result = (RoleInfo)this.roleName2InfoMap.get(theRoleInfoName)) == null) {
            StringBuffer excMsgStrB = new StringBuffer();
            String excMsg = "No role info for role ";
            excMsgStrB.append(excMsg);
            excMsgStrB.append(theRoleInfoName);
            throw new RoleInfoNotFoundException(excMsgStrB.toString());
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: exiting", null);
        }
        return result;
    }

    protected void addRoleInfo(RoleInfo theRoleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRoleInfo == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            this.debug("addRoleInfo: entering", theRoleInfo.toString());
        }
        if (this.isInRelationService) {
            String excMsg = "Relation type cannot be updated as it is declared in the Relation Service.";
            throw new RuntimeException(excMsg);
        }
        String roleName = theRoleInfo.getName();
        if (this.roleName2InfoMap.containsKey(roleName)) {
            StringBuffer excMsgStrB = new StringBuffer();
            String excMsg = "Two role infos provided for role ";
            excMsgStrB.append(excMsg);
            excMsgStrB.append(roleName);
            throw new InvalidRelationTypeException(excMsgStrB.toString());
        }
        this.roleName2InfoMap.put(roleName, new RoleInfo(theRoleInfo));
        if (this.isDebugOn()) {
            this.debug("addRoleInfo: exiting", null);
        }
    }

    void setRelationServiceFlag(boolean theFlg) {
        this.isInRelationService = theFlg;
    }

    private void initMembers(String theRelTypeName, RoleInfo[] theRoleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRelTypeName == null || theRoleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            this.debug("initMembers: entering", theRelTypeName);
        }
        this.typeName = theRelTypeName;
        RelationTypeSupport.checkRoleInfos(theRoleInfoArray);
        int i = 0;
        while (i < theRoleInfoArray.length) {
            RoleInfo currRoleInfo = theRoleInfoArray[i];
            this.roleName2InfoMap.put(new String(currRoleInfo.getName()), new RoleInfo(currRoleInfo));
            ++i;
        }
        if (this.isDebugOn()) {
            this.debug("initMembers: exiting", null);
        }
    }

    static void checkRoleInfos(RoleInfo[] theRoleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRoleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (theRoleInfoArray.length == 0) {
            String excMsg = "No role info provided.";
            throw new InvalidRelationTypeException(excMsg);
        }
        ArrayList<String> roleNameList = new ArrayList<String>();
        int i = 0;
        while (i < theRoleInfoArray.length) {
            RoleInfo currRoleInfo = theRoleInfoArray[i];
            if (currRoleInfo == null) {
                String excMsg = "Null role info provided.";
                throw new InvalidRelationTypeException(excMsg);
            }
            String roleName = currRoleInfo.getName();
            if (roleNameList.contains(roleName)) {
                StringBuffer excMsgStrB = new StringBuffer();
                String excMsg = "Two role infos provided for role ";
                excMsgStrB.append(excMsg);
                excMsgStrB.append(roleName);
                throw new InvalidRelationTypeException(excMsgStrB.toString());
            }
            roleNameList.add(roleName);
            ++i;
        }
    }

    private boolean isTraceOn() {
        return false;
    }

    private void trace(String methodName, String info) {
    }

    private boolean isDebugOn() {
        return false;
    }

    private void debug(String methodName, String info) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField fields = in.readFields();
            this.typeName = (String)fields.get("myTypeName", null);
            if (fields.defaulted("myTypeName")) {
                throw new NullPointerException("myTypeName");
            }
            this.roleName2InfoMap = (Map)fields.get("myRoleName2InfoMap", null);
            if (fields.defaulted("myRoleName2InfoMap")) {
                throw new NullPointerException("myRoleName2InfoMap");
            }
            this.isInRelationService = fields.get("myIsInRelServFlg", false);
            if (fields.defaulted("myIsInRelServFlg")) {
                throw new NullPointerException("myIsInRelServFlg");
            }
        } else {
            in.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("myTypeName", this.typeName);
            fields.put("myRoleName2InfoMap", (HashMap)this.roleName2InfoMap);
            fields.put("myIsInRelServFlg", this.isInRelationService);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = (String)AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -8179019472410837190L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 4611072955724144607L;
        }
        localClassName = "RelationTypeSupport";
    }
}

