/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationService;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    private String myRelId = null;
    private ObjectName myRelServiceName = null;
    private MBeanServer myRelServiceMBeanServer = null;
    private String myRelTypeName = null;
    private HashMap myRoleName2ValueMap = new HashMap();
    private Boolean myInRelServFlg = null;
    private static String localClassName = "RelationSupport";

    public RelationSupport(String theRelId, ObjectName theRelServiceName, String theRelTypeName, RoleList theRoleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.initMembers(theRelId, theRelServiceName, null, theRelTypeName, theRoleList);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    public RelationSupport(String theRelId, ObjectName theRelServiceName, MBeanServer theRelServiceMBeanServer, String theRelTypeName, RoleList theRoleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (theRelServiceMBeanServer == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.initMembers(theRelId, theRelServiceName, theRelServiceMBeanServer, theRelTypeName, theRoleList);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    public List getRole(String theRoleName) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getRole: entering", theRoleName);
        }
        ArrayList result = (ArrayList)this.getRoleInt(theRoleName, false, null, false);
        if (this.isTraceOn()) {
            this.trace("getRole: exiting", null);
        }
        return result;
    }

    public RoleResult getRoles(String[] theRoleNameArray) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (theRoleNameArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: entering", null);
        }
        RoleResult result = this.getRolesInt(theRoleNameArray, false, null);
        if (this.isTraceOn()) {
            this.trace("getRoles: exiting", null);
        }
        return result;
    }

    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        if (this.isTraceOn()) {
            this.trace("getAllRoles: entering", null);
        }
        RoleResult result = null;
        try {
            result = this.getAllRolesInt(false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: exiting", null);
        }
        return result;
    }

    public RoleList retrieveAllRoles() {
        if (this.isTraceOn()) {
            this.trace("retrieveAllRoles: entering", null);
        }
        RoleList result = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            result = new RoleList(new ArrayList(this.myRoleName2ValueMap.values()));
        }
        if (this.isTraceOn()) {
            this.trace("retrieveAllRoles: exiting", null);
        }
        return result;
    }

    public Integer getRoleCardinality(String theRoleName) throws IllegalArgumentException, RoleNotFoundException {
        if (theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleCardinality: entering", theRoleName);
        }
        Role role = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            role = (Role)this.myRoleName2ValueMap.get(theRoleName);
        }
        if (role == null) {
            int pbType = 1;
            try {
                RelationService.throwRoleProblemException(pbType, theRoleName);
            }
            catch (InvalidRoleValueException exc) {
                // empty catch block
            }
        }
        ArrayList roleValue = (ArrayList)role.getRoleValue();
        if (this.isTraceOn()) {
            this.trace("getRoleCardinality: exiting", null);
        }
        return new Integer(roleValue.size());
    }

    public void setRole(Role theRole) throws IllegalArgumentException, RoleNotFoundException, RelationTypeNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (theRole == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("setRole: entering", theRole.toString());
        }
        Object result = this.setRoleInt(theRole, false, null, false);
        if (this.isTraceOn()) {
            this.trace("setRole: exiting", null);
        }
    }

    public RoleResult setRoles(RoleList theRoleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (theRoleList == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("setRoles: entering", theRoleList.toString());
        }
        RoleResult result = this.setRolesInt(theRoleList, false, null);
        if (this.isTraceOn()) {
            this.trace("setRoles: exiting", null);
        }
        return result;
    }

    public void handleMBeanUnregistration(ObjectName theObjName, String theRoleName) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (theObjName == null || theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("handleMBeanUnregistration: entering", "theObjName " + theObjName + ", theRoleName " + theRoleName);
        }
        this.handleMBeanUnregistrationInt(theObjName, theRoleName, false, null);
        if (this.isTraceOn()) {
            this.trace("handleMBeanUnregistration: exiting", null);
        }
    }

    public Map getReferencedMBeans() {
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: entering", null);
        }
        HashMap<ObjectName, ArrayList<String>> refMBeanMap = new HashMap<ObjectName, ArrayList<String>>();
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            Iterator roleIter = this.myRoleName2ValueMap.values().iterator();
            while (roleIter.hasNext()) {
                Role currRole = (Role)roleIter.next();
                String currRoleName = currRole.getRoleName();
                ArrayList currRefMBeanList = (ArrayList)currRole.getRoleValue();
                Iterator mbeanIter = ((AbstractList)currRefMBeanList).iterator();
                while (mbeanIter.hasNext()) {
                    ObjectName currRoleObjName = (ObjectName)mbeanIter.next();
                    ArrayList<String> mbeanRoleNameList = (ArrayList<String>)refMBeanMap.get(currRoleObjName);
                    boolean newRefFlg = false;
                    if (mbeanRoleNameList == null) {
                        newRefFlg = true;
                        mbeanRoleNameList = new ArrayList<String>();
                    }
                    mbeanRoleNameList.add(currRoleName);
                    if (!newRefFlg) continue;
                    refMBeanMap.put(currRoleObjName, mbeanRoleNameList);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: exiting", null);
        }
        return refMBeanMap;
    }

    public String getRelationTypeName() {
        return this.myRelTypeName;
    }

    public ObjectName getRelationServiceName() {
        return this.myRelServiceName;
    }

    public String getRelationId() {
        return this.myRelId;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.myRelServiceMBeanServer = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public Boolean isInRelationService() {
        Boolean result = null;
        Boolean bl = this.myInRelServFlg;
        synchronized (bl) {
            result = new Boolean(this.myInRelServFlg);
        }
        return result;
    }

    public void setRelationServiceManagementFlag(Boolean theFlg) throws IllegalArgumentException {
        if (theFlg == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        Boolean bl = this.myInRelServFlg;
        synchronized (bl) {
            this.myInRelServFlg = new Boolean(theFlg);
        }
    }

    Object getRoleInt(String theRoleName, boolean theRelServCallFlg, RelationService theRelServ, boolean theMultiRoleFlg) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (theRoleName == null || theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = "theRoleName " + theRoleName;
            this.debug("getRoleInt: entering", str);
        }
        int pbType = 0;
        Role role = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            role = (Role)this.myRoleName2ValueMap.get(theRoleName);
        }
        if (role == null) {
            pbType = 1;
        } else {
            Integer status = null;
            if (theRelServCallFlg) {
                try {
                    status = theRelServ.checkRoleReading(theRoleName, this.myRelTypeName);
                }
                catch (RelationTypeNotFoundException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            Object[] params = new Object[]{theRoleName, this.myRelTypeName};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            try {
                status = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleReading", params, signature);
            }
            catch (MBeanException exc1) {
                throw new RuntimeException("incorrect relation type");
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (InstanceNotFoundException exc3) {
                throw new RelationServiceNotRegisteredException(exc3.getMessage());
            }
            pbType = status;
        }
        Serializable result = null;
        if (pbType == 0) {
            result = !theMultiRoleFlg ? (ArrayList)((ArrayList)role.getRoleValue()).clone() : (Role)role.clone();
        } else {
            if (!theMultiRoleFlg) {
                try {
                    RelationService.throwRoleProblemException(pbType, theRoleName);
                    return null;
                }
                catch (InvalidRoleValueException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            result = new RoleUnresolved(theRoleName, null, pbType);
        }
        if (this.isDebugOn()) {
            this.debug("getRoleInt: exiting", null);
        }
        return result;
    }

    RoleResult getRolesInt(String[] theRoleNameArray, boolean theRelServCallFlg, RelationService theRelServ) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (theRoleNameArray == null || theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            this.debug("getRolesInt: entering", null);
        }
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnresList = new RoleUnresolvedList();
        int i = 0;
        while (i < theRoleNameArray.length) {
            String currRoleName = theRoleNameArray[i];
            Object currResult = null;
            try {
                currResult = this.getRoleInt(currRoleName, theRelServCallFlg, theRelServ, true);
            }
            catch (RoleNotFoundException exc) {
                return null;
            }
            if (currResult instanceof Role) {
                try {
                    roleList.add((Role)currResult);
                }
                catch (IllegalArgumentException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            if (currResult instanceof RoleUnresolved) {
                try {
                    roleUnresList.add((RoleUnresolved)currResult);
                }
                catch (IllegalArgumentException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            ++i;
        }
        RoleResult result = new RoleResult(roleList, roleUnresList);
        if (this.isDebugOn()) {
            this.debug("getRolesInt: exiting", null);
        }
        return result;
    }

    RoleResult getAllRolesInt(boolean theRelServCallFlg, RelationService theRelServ) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            this.debug("getAllRolesInt: entering", null);
        }
        ArrayList roleNameList = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            roleNameList = new ArrayList(this.myRoleName2ValueMap.keySet());
        }
        String[] roleNames = new String[roleNameList.size()];
        int i = 0;
        Iterator roleNameIter = ((AbstractList)roleNameList).iterator();
        while (roleNameIter.hasNext()) {
            String currRoleName;
            roleNames[i] = currRoleName = (String)roleNameIter.next();
            ++i;
        }
        RoleResult result = this.getRolesInt(roleNames, theRelServCallFlg, theRelServ);
        if (this.isDebugOn()) {
            this.debug("getAllRolesInt: exiting", null);
        }
        return result;
    }

    Object setRoleInt(Role theRole, boolean theRelServCallFlg, RelationService theRelServ, boolean theMultiRoleFlg) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (theRole == null || theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = "theRole " + theRole + ", theRelServCallFlg " + theRelServCallFlg + ", theMultiRoleFlg " + theMultiRoleFlg;
            this.debug("setRoleInt: entering", str);
        }
        String roleName = theRole.getRoleName();
        int pbType = 0;
        Role role = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            role = (Role)this.myRoleName2ValueMap.get(roleName);
        }
        ArrayList oldRoleValue = null;
        Boolean initFlg = null;
        if (role == null) {
            initFlg = new Boolean(true);
            oldRoleValue = new ArrayList();
        } else {
            initFlg = new Boolean(false);
            oldRoleValue = (ArrayList)role.getRoleValue();
        }
        try {
            Integer status = null;
            if (theRelServCallFlg) {
                status = theRelServ.checkRoleWriting(theRole, this.myRelTypeName, initFlg);
            } else {
                Object[] params = new Object[]{theRole, this.myRelTypeName, initFlg};
                String[] signature = new String[]{"javax.management.relation.Role", "java.lang.String", "java.lang.Boolean"};
                status = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleWriting", params, signature);
            }
            pbType = status;
        }
        catch (MBeanException exc2) {
            Exception wrappedExc = exc2.getTargetException();
            if (wrappedExc instanceof RelationTypeNotFoundException) {
                throw (RelationTypeNotFoundException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        catch (ReflectionException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        catch (RelationTypeNotFoundException exc4) {
            throw new RuntimeException(exc4.getMessage());
        }
        catch (InstanceNotFoundException exc5) {
            throw new RelationServiceNotRegisteredException(exc5.getMessage());
        }
        Serializable result = null;
        if (pbType == 0) {
            if (!initFlg.booleanValue()) {
                this.sendRoleUpdateNotification(theRole, oldRoleValue, theRelServCallFlg, theRelServ);
                this.updateRelationServiceMap(theRole, oldRoleValue, theRelServCallFlg, theRelServ);
            }
            HashMap hashMap2 = this.myRoleName2ValueMap;
            synchronized (hashMap2) {
                this.myRoleName2ValueMap.put(roleName, (Role)theRole.clone());
            }
            if (theMultiRoleFlg) {
                result = theRole;
            }
        } else {
            if (!theMultiRoleFlg) {
                RelationService.throwRoleProblemException(pbType, roleName);
                return null;
            }
            result = new RoleUnresolved(roleName, theRole.getRoleValue(), pbType);
        }
        if (this.isDebugOn()) {
            this.debug("setRoleInt: exiting", null);
        }
        return result;
    }

    private void sendRoleUpdateNotification(Role theNewRole, List theOldRoleValue, boolean theRelServCallFlg, RelationService theRelServ) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (theNewRole == null || theOldRoleValue == null || theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = "theNewRole " + theNewRole + ", theOldRoleValue " + theOldRoleValue + ", theRelServCallFlg " + theRelServCallFlg;
            this.debug("sendRoleUpdateNotification: entering", str);
        }
        if (theRelServCallFlg) {
            try {
                theRelServ.sendRoleUpdateNotification(this.myRelId, theNewRole, theOldRoleValue);
            }
            catch (RelationNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{this.myRelId, theNewRole, (ArrayList)theOldRoleValue};
        String[] signature = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "sendRoleUpdateNotification", params, signature);
        }
        catch (ReflectionException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (InstanceNotFoundException exc2) {
            throw new RelationServiceNotRegisteredException(exc2.getMessage());
        }
        catch (MBeanException exc3) {
            Exception wrappedExc = exc3.getTargetException();
            if (wrappedExc instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        if (this.isDebugOn()) {
            this.debug("sendRoleUpdateNotification: exiting", null);
        }
    }

    private void updateRelationServiceMap(Role theNewRole, List theOldRoleValue, boolean theRelServCallFlg, RelationService theRelServ) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (theNewRole == null || theOldRoleValue == null || theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = "theNewRole " + theNewRole + ", theOldRoleValue " + theOldRoleValue + ", theRelServCallFlg " + theRelServCallFlg;
            this.debug("updateRelationServiceMap: entering", str);
        }
        if (theRelServCallFlg) {
            try {
                theRelServ.updateRoleMap(this.myRelId, theNewRole, theOldRoleValue);
            }
            catch (RelationNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{this.myRelId, theNewRole, theOldRoleValue};
        String[] signature = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "updateRoleMap", params, signature);
        }
        catch (ReflectionException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (InstanceNotFoundException exc2) {
            throw new RelationServiceNotRegisteredException(exc2.getMessage());
        }
        catch (MBeanException exc3) {
            Exception wrappedExc = exc3.getTargetException();
            if (wrappedExc instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        if (this.isDebugOn()) {
            this.debug("updateRelationServiceMap: exiting", null);
        }
    }

    RoleResult setRolesInt(RoleList theRoleList, boolean theRelServCallFlg, RelationService theRelServ) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (theRoleList == null || theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = "theRoleList " + theRoleList + ", theRelServCallFlg " + theRelServCallFlg;
            this.debug("setRolesInt: entering", str);
        }
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnresList = new RoleUnresolvedList();
        Iterator roleIter = ((AbstractList)theRoleList).iterator();
        while (roleIter.hasNext()) {
            Role currRole = (Role)roleIter.next();
            Object currResult = null;
            try {
                currResult = this.setRoleInt(currRole, theRelServCallFlg, theRelServ, true);
            }
            catch (RoleNotFoundException exc1) {
            }
            catch (InvalidRoleValueException exc2) {
                // empty catch block
            }
            if (currResult instanceof Role) {
                try {
                    roleList.add((Role)currResult);
                    continue;
                }
                catch (IllegalArgumentException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            if (!(currResult instanceof RoleUnresolved)) continue;
            try {
                roleUnresList.add((RoleUnresolved)currResult);
            }
            catch (IllegalArgumentException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        RoleResult result = new RoleResult(roleList, roleUnresList);
        if (this.isDebugOn()) {
            this.debug("setRolesInt: exiting", null);
        }
        return result;
    }

    private void initMembers(String theRelId, ObjectName theRelServiceName, MBeanServer theRelServiceMBeanServer, String theRelTypeName, RoleList theRoleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (theRelId == null || theRelServiceName == null || theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            StringBuffer strB = new StringBuffer("theRelId " + theRelId + ", theRelServiceName " + theRelServiceName.toString() + ", theRelTypeName " + theRelTypeName);
            if (theRoleList != null) {
                strB.append(", theRoleList " + theRoleList.toString());
            }
            this.debug("initMembers: entering", strB.toString());
        }
        this.myRelId = theRelId;
        this.myRelServiceName = theRelServiceName;
        this.myRelServiceMBeanServer = theRelServiceMBeanServer;
        this.myRelTypeName = theRelTypeName;
        this.initRoleMap(theRoleList);
        this.myInRelServFlg = new Boolean(false);
        if (this.isDebugOn()) {
            this.debug("initMembers: exiting", null);
        }
    }

    private void initRoleMap(RoleList theRoleList) throws InvalidRoleValueException {
        if (theRoleList == null) {
            return;
        }
        if (this.isDebugOn()) {
            this.debug("initRoleMap: entering", theRoleList.toString());
        }
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            Iterator roleIter = ((AbstractList)theRoleList).iterator();
            while (roleIter.hasNext()) {
                Role currRole = (Role)roleIter.next();
                String currRoleName = currRole.getRoleName();
                if (this.myRoleName2ValueMap.containsKey(currRoleName)) {
                    StringBuffer excMsgStrB = new StringBuffer("Role name ");
                    excMsgStrB.append(currRoleName);
                    excMsgStrB.append(" used for two roles.");
                    throw new InvalidRoleValueException(excMsgStrB.toString());
                }
                this.myRoleName2ValueMap.put(currRoleName, (Role)currRole.clone());
            }
        }
        if (this.isDebugOn()) {
            this.debug("initRoleMap: exiting", null);
        }
    }

    void handleMBeanUnregistrationInt(ObjectName theObjName, String theRoleName, boolean theRelServCallFlg, RelationService theRelServ) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (theObjName == null || theRoleName == null || theRelServCallFlg && theRelServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = "theObjName " + theObjName + ", theRoleName " + theRoleName + ", theRelServCallFlg " + theRelServCallFlg;
            this.debug("handleMBeanUnregistrationInt: entering", str);
        }
        Role role = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            role = (Role)this.myRoleName2ValueMap.get(theRoleName);
        }
        if (role == null) {
            StringBuffer excMsgStrB = new StringBuffer();
            String excMsg = "No role with name ";
            excMsgStrB.append(excMsg);
            excMsgStrB.append(theRoleName);
            throw new RoleNotFoundException(excMsgStrB.toString());
        }
        ArrayList currRoleValue = (ArrayList)role.getRoleValue();
        ArrayList newRoleValue = (ArrayList)currRoleValue.clone();
        ((AbstractCollection)newRoleValue).remove(theObjName);
        Role newRole = new Role(theRoleName, newRoleValue);
        Object result = this.setRoleInt(newRole, theRelServCallFlg, theRelServ, false);
        if (this.isDebugOn()) {
            this.debug("handleMBeanUnregistrationInt: exiting", null);
        }
    }

    private boolean isTraceOn() {
        return false;
    }

    private void trace(String methodName, String info) {
    }

    private boolean isDebugOn() {
        return false;
    }

    private void debug(String methodName, String info) {
    }
}

