/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sap.jmx.ObjectNameFactory;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;

public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private HashMap myRelId2ObjMap = new HashMap();
    private HashMap myRelId2RelTypeMap = new HashMap();
    private HashMap myRelMBeanObjName2RelIdMap = new HashMap();
    private HashMap myRelType2ObjMap = new HashMap();
    private HashMap myRelType2RelIdsMap = new HashMap();
    private HashMap myRefedMBeanObjName2RelIdsMap = new HashMap();
    private boolean myPurgeFlg = true;
    private Long myNtfSeqNbrCounter = new Long(0L);
    private ObjectName myObjName = null;
    private MBeanServer myMBeanServer = null;
    private MBeanServerNotificationFilter myUnregNtfFilter = null;
    private ArrayList myUnregNtfList = new ArrayList();
    private static String localClassName = "RelationService";

    public RelationService(boolean theImmediatePurgeFlg) {
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.setPurgeFlag(theImmediatePurgeFlg);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    public void isActive() throws RelationServiceNotRegisteredException {
        if (this.myMBeanServer == null) {
            String excMsg = "Relation Service not registered in the MBean Server.";
            throw new RelationServiceNotRegisteredException(excMsg);
        }
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.myMBeanServer = server;
        this.myObjName = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public boolean getPurgeFlag() {
        return this.myPurgeFlg;
    }

    public void setPurgeFlag(boolean thePurgeFlg) {
        this.myPurgeFlg = thePurgeFlg;
    }

    private Long getNotificationSequenceNumber() {
        Long result = null;
        Long l = this.myNtfSeqNbrCounter;
        synchronized (l) {
            result = new Long(this.myNtfSeqNbrCounter + 1L);
            this.myNtfSeqNbrCounter = new Long(result);
        }
        return result;
    }

    public void createRelationType(String theRelTypeName, RoleInfo[] theRoleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRelTypeName == null || theRoleInfoArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("createRelationType: entering", theRelTypeName);
        }
        RelationTypeSupport relType = new RelationTypeSupport(theRelTypeName, theRoleInfoArray);
        this.addRelationTypeInt(relType);
        if (this.isTraceOn()) {
            this.trace("createRelationType: exiting", null);
        }
    }

    public void addRelationType(RelationType theRelTypeObj) throws IllegalArgumentException, InvalidRelationTypeException {
        List roleInfoList;
        if (theRelTypeObj == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("addRelationType: entering", null);
        }
        if ((roleInfoList = theRelTypeObj.getRoleInfos()) == null) {
            String excMsg = "No role info provided.";
            throw new InvalidRelationTypeException(excMsg);
        }
        RoleInfo[] roleInfoArray = new RoleInfo[roleInfoList.size()];
        int i = 0;
        Iterator roleInfoIter = roleInfoList.iterator();
        while (roleInfoIter.hasNext()) {
            RoleInfo currRoleInfo;
            roleInfoArray[i] = currRoleInfo = (RoleInfo)roleInfoIter.next();
            ++i;
        }
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        this.addRelationTypeInt(theRelTypeObj);
        if (this.isTraceOn()) {
            this.trace("addRelationType: exiting", null);
        }
    }

    public List getAllRelationTypeNames() {
        ArrayList result = null;
        HashMap hashMap = this.myRelType2ObjMap;
        synchronized (hashMap) {
            result = new ArrayList(this.myRelType2ObjMap.keySet());
        }
        return result;
    }

    public List getRoleInfos(String theRelTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleInfos: entering", theRelTypeName);
        }
        RelationType relType = this.getRelationType(theRelTypeName);
        if (this.isTraceOn()) {
            this.trace("getRoleInfos: exiting", null);
        }
        return relType.getRoleInfos();
    }

    public RoleInfo getRoleInfo(String theRelTypeName, String theRoleInfoName) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        if (theRelTypeName == null || theRoleInfoName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = "theRelTypeName " + theRelTypeName + ", theRoleInfoName " + theRoleInfoName;
            this.trace("getRoleInfo: entering", str);
        }
        RelationType relType = this.getRelationType(theRelTypeName);
        RoleInfo roleInfo = relType.getRoleInfo(theRoleInfoName);
        if (this.isTraceOn()) {
            this.trace("getRoleInfo: exiting", null);
        }
        return roleInfo;
    }

    public void removeRelationType(String theRelTypeName) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationTypeNotFoundException {
        this.isActive();
        if (theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("removeRelationType: entering", theRelTypeName);
        }
        RelationType relType = this.getRelationType(theRelTypeName);
        ArrayList relIdList = null;
        HashMap hashMap = this.myRelType2RelIdsMap;
        synchronized (hashMap) {
            ArrayList relIdList1 = (ArrayList)this.myRelType2RelIdsMap.get(theRelTypeName);
            if (relIdList1 != null) {
                relIdList = (ArrayList)relIdList1.clone();
            }
        }
        HashMap hashMap2 = this.myRelType2ObjMap;
        synchronized (hashMap2) {
            this.myRelType2ObjMap.remove(theRelTypeName);
        }
        HashMap hashMap3 = this.myRelType2RelIdsMap;
        synchronized (hashMap3) {
            this.myRelType2RelIdsMap.remove(theRelTypeName);
        }
        if (relIdList != null) {
            Iterator relIdIter = ((AbstractList)relIdList).iterator();
            while (relIdIter.hasNext()) {
                String currRelId = (String)relIdIter.next();
                try {
                    this.removeRelation(currRelId);
                }
                catch (RelationNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("removeRelationType: exiting", null);
        }
    }

    public void createRelation(String theRelId, String theRelTypeName, RoleList theRoleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        this.isActive();
        if (theRelId == null || theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            StringBuffer strB = new StringBuffer("theRelId " + theRelId + ", theRelTypeName " + theRelTypeName);
            if (theRoleList != null) {
                strB.append(", theRoleList " + theRoleList.toString());
            }
            this.trace("createRelation: entering", strB.toString());
        }
        RelationSupport relObj = new RelationSupport(theRelId, this.myObjName, theRelTypeName, theRoleList);
        this.addRelationInt(true, relObj, null, theRelId, theRelTypeName, theRoleList);
        if (this.isTraceOn()) {
            this.trace("createRelation: exiting", null);
        }
    }

    public void addRelation(ObjectName theRelObjectName) throws IllegalArgumentException, RelationServiceNotRegisteredException, NoSuchMethodException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        if (theRelObjectName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("addRelation: entering", theRelObjectName.toString());
        }
        this.isActive();
        if (!this.myMBeanServer.isInstanceOf(theRelObjectName, "javax.management.relation.Relation")) {
            String excMsg = "This MBean does not implement the Relation interface.";
            throw new NoSuchMethodException(excMsg);
        }
        String relId = null;
        try {
            relId = (String)this.myMBeanServer.getAttribute(theRelObjectName, "RelationId");
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc2) {
            throw new RuntimeException(exc2.getMessage());
        }
        catch (AttributeNotFoundException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        if (relId == null) {
            String excMsg = "This MBean does not provide a relation id.";
            throw new InvalidRelationIdException(excMsg);
        }
        ObjectName relServObjName = null;
        try {
            relServObjName = (ObjectName)this.myMBeanServer.getAttribute(theRelObjectName, "RelationServiceName");
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc2) {
            throw new RuntimeException(exc2.getMessage());
        }
        catch (AttributeNotFoundException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        boolean badRelServFlg = false;
        if (relServObjName == null) {
            badRelServFlg = true;
        } else if (!relServObjName.equals(this.myObjName)) {
            badRelServFlg = true;
        }
        if (badRelServFlg) {
            String excMsg = "The Relation Service referenced in the MBean is not the current one.";
            throw new InvalidRelationServiceException(excMsg);
        }
        String relTypeName = null;
        try {
            relTypeName = (String)this.myMBeanServer.getAttribute(theRelObjectName, "RelationTypeName");
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc2) {
            throw new RuntimeException(exc2.getMessage());
        }
        catch (AttributeNotFoundException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        if (relTypeName == null) {
            String excMsg = "No relation type provided.";
            throw new RelationTypeNotFoundException(excMsg);
        }
        RoleList roleList = null;
        try {
            roleList = (RoleList)this.myMBeanServer.invoke(theRelObjectName, "retrieveAllRoles", null, null);
        }
        catch (MBeanException exc1) {
            throw new RuntimeException(exc1.getTargetException().getMessage());
        }
        catch (ReflectionException exc2) {
            throw new RuntimeException(exc2.getMessage());
        }
        this.addRelationInt(false, null, theRelObjectName, relId, relTypeName, roleList);
        HashMap hashMap = this.myRelMBeanObjName2RelIdMap;
        synchronized (hashMap) {
            this.myRelMBeanObjName2RelIdMap.put(theRelObjectName, relId);
        }
        try {
            this.myMBeanServer.setAttribute(theRelObjectName, new Attribute("RelationServiceManagementFlag", new Boolean(true)));
        }
        catch (Exception exc) {
            // empty catch block
        }
        ArrayList<ObjectName> newRefList = new ArrayList<ObjectName>();
        newRefList.add(theRelObjectName);
        this.updateUnregistrationListener(newRefList, null);
        if (this.isTraceOn()) {
            this.trace("addRelation: exiting", null);
        }
    }

    public ObjectName isRelationMBean(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        Object result;
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("isRelationMBean", theRelId);
        }
        if ((result = this.getRelation(theRelId)) instanceof ObjectName) {
            return (ObjectName)result;
        }
        return null;
    }

    public String isRelation(ObjectName theObjName) throws IllegalArgumentException {
        if (theObjName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("isRelation", theObjName.toString());
        }
        String result = null;
        HashMap hashMap = this.myRelMBeanObjName2RelIdMap;
        synchronized (hashMap) {
            String relId = (String)this.myRelMBeanObjName2RelIdMap.get(theObjName);
            if (relId != null) {
                result = relId;
            }
        }
        return result;
    }

    public Boolean hasRelation(String theRelId) throws IllegalArgumentException {
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("hasRelation", theRelId);
        }
        try {
            Object result = this.getRelation(theRelId);
            return new Boolean(true);
        }
        catch (RelationNotFoundException exc) {
            return new Boolean(false);
        }
    }

    public List getAllRelationIds() {
        ArrayList result = null;
        HashMap hashMap = this.myRelId2ObjMap;
        synchronized (hashMap) {
            result = new ArrayList(this.myRelId2ObjMap.keySet());
        }
        return result;
    }

    public Integer checkRoleReading(String theRoleName, String theRelTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRoleName == null || theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = "theRoleName " + theRoleName + ", theRelTypeName " + theRelTypeName;
            this.trace("checkRoleReading: entering", str);
        }
        Integer result = null;
        RelationType relType = this.getRelationType(theRelTypeName);
        try {
            RoleInfo roleInfo = relType.getRoleInfo(theRoleName);
            result = this.checkRoleInt(1, theRoleName, null, roleInfo, false);
        }
        catch (RoleInfoNotFoundException exc) {
            result = new Integer(1);
        }
        if (this.isTraceOn()) {
            this.trace("checkRoleReading: exiting", null);
        }
        return result;
    }

    public Integer checkRoleWriting(Role theRole, String theRelTypeName, Boolean theInitFlg) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRole == null || theRelTypeName == null || theInitFlg == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = new String("theRole " + theRole.toString() + ", theRelTypeName " + theRelTypeName + ", theInitFlg " + theInitFlg);
            this.trace("checkRoleWriting: entering", str);
        }
        RelationType relType = this.getRelationType(theRelTypeName);
        String roleName = theRole.getRoleName();
        ArrayList roleValue = (ArrayList)theRole.getRoleValue();
        boolean writeChkFlg = true;
        if (theInitFlg.booleanValue()) {
            writeChkFlg = false;
        }
        RoleInfo roleInfo = null;
        try {
            roleInfo = relType.getRoleInfo(roleName);
        }
        catch (RoleInfoNotFoundException exc) {
            if (this.isTraceOn()) {
                this.trace("checkRoleWriting: exiting", null);
            }
            return new Integer(1);
        }
        Integer result = this.checkRoleInt(2, roleName, roleValue, roleInfo, writeChkFlg);
        if (this.isTraceOn()) {
            this.trace("checkRoleWriting: exiting", null);
        }
        return result;
    }

    public void sendRelationCreationNotification(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("sendRelationCreationNotification: entering", theRelId);
        }
        StringBuffer ntfMsg = new StringBuffer("Creation of relation ");
        ntfMsg.append(theRelId);
        this.sendNotificationInt(1, ntfMsg.toString(), theRelId, null, null, null, null);
        if (this.isTraceOn()) {
            this.trace("sendRelationCreationNotification: exiting", null);
        }
    }

    public void sendRoleUpdateNotification(String theRelId, Role theNewRole, List theOldRoleValue) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null || theNewRole == null || theOldRoleValue == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = new String("theRelId " + theRelId + ", theNewRole " + theNewRole.toString() + ", theOldRoleValue " + theOldRoleValue.toString());
            this.trace("sendRoleUpdateNotification: entering", str);
        }
        String roleName = theNewRole.getRoleName();
        ArrayList newRoleVal = (ArrayList)theNewRole.getRoleValue();
        String newRoleValString = Role.roleValueToString(newRoleVal);
        String oldRoleValString = Role.roleValueToString(theOldRoleValue);
        StringBuffer ntfMsg = new StringBuffer("Value of role ");
        ntfMsg.append(roleName);
        ntfMsg.append(" has changed\nOld value:\n");
        ntfMsg.append(oldRoleValString);
        ntfMsg.append("\nNew value:\n");
        ntfMsg.append(newRoleValString);
        this.sendNotificationInt(2, ntfMsg.toString(), theRelId, null, roleName, newRoleVal, theOldRoleValue);
        if (this.isTraceOn()) {
            this.trace("sendRoleUpdateNotification: exiting", null);
        }
    }

    public void sendRelationRemovalNotification(String theRelId, List theUnregMBeanList) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            StringBuffer strB = new StringBuffer("theRelId " + theRelId);
            if (theUnregMBeanList != null) {
                strB.append(", theUnregMBeanList " + theUnregMBeanList.toString());
            }
            this.trace("sendRelationRemovalNotification: entering", strB.toString());
        }
        StringBuffer ntfMsg = new StringBuffer("Removal of relation ");
        ntfMsg.append(theRelId);
        this.sendNotificationInt(3, ntfMsg.toString(), theRelId, theUnregMBeanList, null, null, null);
        if (this.isTraceOn()) {
            this.trace("sendRelationRemovalNotification: exiting", null);
        }
    }

    public void updateRoleMap(String theRelId, Role theNewRole, List theOldRoleValue) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (theRelId == null || theNewRole == null || theOldRoleValue == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = new String("theRelId " + theRelId + ", theNewRole " + theNewRole.toString() + ", theOldRoleValue " + theOldRoleValue.toString());
            this.trace("updateRoleMap: entering", str);
        }
        this.isActive();
        Object result = this.getRelation(theRelId);
        String roleName = theNewRole.getRoleName();
        ArrayList newRoleValue = (ArrayList)theNewRole.getRoleValue();
        ArrayList oldRoleValue = (ArrayList)((ArrayList)theOldRoleValue).clone();
        ArrayList<ObjectName> newRefList = new ArrayList<ObjectName>();
        Iterator newRoleIter = ((AbstractList)newRoleValue).iterator();
        while (newRoleIter.hasNext()) {
            ObjectName currObjName = (ObjectName)newRoleIter.next();
            int currObjNamePos = oldRoleValue.indexOf(currObjName);
            if (currObjNamePos == -1) {
                boolean isNewFlg = this.addNewMBeanReference(currObjName, theRelId, roleName);
                if (!isNewFlg) continue;
                newRefList.add(currObjName);
                continue;
            }
            oldRoleValue.remove(currObjNamePos);
        }
        ArrayList<ObjectName> obsRefList = new ArrayList<ObjectName>();
        Iterator oldRoleIter = ((AbstractList)oldRoleValue).iterator();
        while (oldRoleIter.hasNext()) {
            ObjectName currObjName = (ObjectName)oldRoleIter.next();
            boolean noLongerRefFlg = this.removeMBeanReference(currObjName, theRelId, roleName, false);
            if (!noLongerRefFlg) continue;
            obsRefList.add(currObjName);
        }
        this.updateUnregistrationListener(newRefList, obsRefList);
        if (this.isTraceOn()) {
            this.trace("updateRoleMap: exiting", null);
        }
    }

    public void removeRelation(String theRelId) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        Object result;
        this.isActive();
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("removeRelation: entering", theRelId);
        }
        if ((result = this.getRelation(theRelId)) instanceof ObjectName) {
            ArrayList<ObjectName> obsRefList = new ArrayList<ObjectName>();
            obsRefList.add((ObjectName)result);
            this.updateUnregistrationListener(null, obsRefList);
        }
        this.sendRelationRemovalNotification(theRelId, null);
        ArrayList<ObjectName> refMBeanList = new ArrayList<ObjectName>();
        ArrayList<ObjectName> nonRefObjNameList = new ArrayList<ObjectName>();
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            Iterator refMBeanIter = this.myRefedMBeanObjName2RelIdsMap.keySet().iterator();
            while (refMBeanIter.hasNext()) {
                ObjectName currRefObjName = (ObjectName)refMBeanIter.next();
                HashMap relIdMap = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(currRefObjName);
                if (relIdMap.containsKey(theRelId)) {
                    relIdMap.remove(theRelId);
                    refMBeanList.add(currRefObjName);
                }
                if (!relIdMap.isEmpty()) continue;
                nonRefObjNameList.add(currRefObjName);
            }
            Iterator nonRefObjNameIter = ((AbstractList)nonRefObjNameList).iterator();
            while (nonRefObjNameIter.hasNext()) {
                ObjectName currRefObjName = (ObjectName)nonRefObjNameIter.next();
                this.myRefedMBeanObjName2RelIdsMap.remove(currRefObjName);
            }
        }
        HashMap hashMap2 = this.myRelId2ObjMap;
        synchronized (hashMap2) {
            this.myRelId2ObjMap.remove(theRelId);
        }
        if (result instanceof ObjectName) {
            HashMap hashMap3 = this.myRelMBeanObjName2RelIdMap;
            synchronized (hashMap3) {
                this.myRelMBeanObjName2RelIdMap.remove((ObjectName)result);
            }
        }
        String relTypeName = null;
        HashMap hashMap4 = this.myRelId2RelTypeMap;
        synchronized (hashMap4) {
            relTypeName = (String)this.myRelId2RelTypeMap.get(theRelId);
            this.myRelId2RelTypeMap.remove(theRelId);
        }
        HashMap hashMap5 = this.myRelType2RelIdsMap;
        synchronized (hashMap5) {
            ArrayList relIdList = (ArrayList)this.myRelType2RelIdsMap.get(relTypeName);
            if (relIdList != null) {
                ((AbstractCollection)relIdList).remove(theRelId);
                if (relIdList.isEmpty()) {
                    this.myRelType2RelIdsMap.remove(relTypeName);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("removeRelation: exiting", null);
        }
    }

    public void purgeRelations() throws RelationServiceNotRegisteredException {
        ObjectName unregMBeanName;
        MBeanServerNotification currNtf;
        Iterator unregNtfIter;
        if (this.isTraceOn()) {
            this.trace("purgeRelations: entering", null);
        }
        this.isActive();
        ArrayList localUnregNtfList = null;
        ArrayList arrayList = this.myUnregNtfList;
        synchronized (arrayList) {
            localUnregNtfList = (ArrayList)this.myUnregNtfList.clone();
            this.myUnregNtfList = new ArrayList();
        }
        ArrayList<ObjectName> obsRefList = new ArrayList<ObjectName>();
        HashMap<ObjectName, HashMap> localMBean2RelIdMap = new HashMap<ObjectName, HashMap>();
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            unregNtfIter = ((AbstractList)localUnregNtfList).iterator();
            while (unregNtfIter.hasNext()) {
                currNtf = (MBeanServerNotification)unregNtfIter.next();
                unregMBeanName = currNtf.getMBeanName();
                obsRefList.add(unregMBeanName);
                HashMap relIdMap = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(unregMBeanName);
                localMBean2RelIdMap.put(unregMBeanName, relIdMap);
                this.myRefedMBeanObjName2RelIdsMap.remove(unregMBeanName);
            }
        }
        this.updateUnregistrationListener(null, obsRefList);
        unregNtfIter = ((AbstractList)localUnregNtfList).iterator();
        while (unregNtfIter.hasNext()) {
            currNtf = (MBeanServerNotification)unregNtfIter.next();
            unregMBeanName = currNtf.getMBeanName();
            HashMap localRelIdMap = (HashMap)localMBean2RelIdMap.get(unregMBeanName);
            Set localRelIdSet = localRelIdMap.keySet();
            Iterator relIdIter = localRelIdSet.iterator();
            while (relIdIter.hasNext()) {
                String currRelId = (String)relIdIter.next();
                ArrayList localRoleNameList = (ArrayList)localRelIdMap.get(currRelId);
                try {
                    this.handleReferenceUnregistration(currRelId, unregMBeanName, localRoleNameList);
                }
                catch (RelationNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
                catch (RoleNotFoundException exc2) {
                    throw new RuntimeException(exc2.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("purgeRelations: exiting", null);
        }
    }

    public Map findReferencingRelations(ObjectName theMBeanName, String theRelTypeName, String theRoleName) throws IllegalArgumentException {
        if (theMBeanName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = new String("theMBeanName " + theMBeanName.toString() + ", theRelTypeName " + theRelTypeName + ", theRoleName " + theRoleName);
            this.trace("findReferencingRelations: entering", str);
        }
        HashMap result = new HashMap();
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            HashMap relId2RoleNamesMap = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(theMBeanName);
            if (relId2RoleNamesMap != null) {
                String currRelId;
                Iterator<Object> relIdIter;
                Set allRelIdSet = relId2RoleNamesMap.keySet();
                ArrayList<Object> relIdList = null;
                if (theRelTypeName == null) {
                    relIdList = new ArrayList(allRelIdSet);
                } else {
                    relIdList = new ArrayList();
                    relIdIter = allRelIdSet.iterator();
                    while (relIdIter.hasNext()) {
                        currRelId = (String)relIdIter.next();
                        String currRelTypeName = null;
                        HashMap hashMap2 = this.myRelId2RelTypeMap;
                        synchronized (hashMap2) {
                            currRelTypeName = (String)this.myRelId2RelTypeMap.get(currRelId);
                        }
                        if (!currRelTypeName.equals(theRelTypeName)) continue;
                        relIdList.add(currRelId);
                    }
                }
                relIdIter = ((AbstractList)relIdList).iterator();
                while (relIdIter.hasNext()) {
                    currRelId = (String)relIdIter.next();
                    ArrayList currRoleNameList = (ArrayList)relId2RoleNamesMap.get(currRelId);
                    if (theRoleName == null) {
                        result.put(currRelId, (ArrayList)currRoleNameList.clone());
                        continue;
                    }
                    if (!currRoleNameList.contains(theRoleName)) continue;
                    ArrayList<String> dummyList = new ArrayList<String>();
                    dummyList.add(theRoleName);
                    result.put(currRelId, dummyList);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("findReferencingRelations: exiting", null);
        }
        return result;
    }

    public Map findAssociatedMBeans(ObjectName theMBeanName, String theRelTypeName, String theRoleName) throws IllegalArgumentException {
        if (theMBeanName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = new String("theMBeanName " + theMBeanName.toString() + ", theRelTypeName " + theRelTypeName + ", theRoleName " + theRoleName);
            this.trace("findAssociatedMBeans: entering", str);
        }
        HashMap relId2RoleNamesMap = (HashMap)this.findReferencingRelations(theMBeanName, theRelTypeName, theRoleName);
        HashMap<ObjectName, ArrayList<String>> result = new HashMap<ObjectName, ArrayList<String>>();
        Iterator relIdIter = relId2RoleNamesMap.keySet().iterator();
        while (relIdIter.hasNext()) {
            String currRelId = (String)relIdIter.next();
            HashMap objName2RoleNamesMap = null;
            try {
                objName2RoleNamesMap = (HashMap)this.getReferencedMBeans(currRelId);
            }
            catch (RelationNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
            Iterator objNameIter = objName2RoleNamesMap.keySet().iterator();
            while (objNameIter.hasNext()) {
                ObjectName currObjName = (ObjectName)objNameIter.next();
                if (currObjName.equals(theMBeanName)) continue;
                ArrayList<String> currRelIdList = (ArrayList<String>)result.get(currObjName);
                if (currRelIdList == null) {
                    currRelIdList = new ArrayList<String>();
                    currRelIdList.add(currRelId);
                    result.put(currObjName, currRelIdList);
                    continue;
                }
                currRelIdList.add(currRelId);
            }
        }
        if (this.isTraceOn()) {
            this.trace("findReferencingRelations: exiting", null);
        }
        return result;
    }

    public List findRelationsOfType(String theRelTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("findRelationsOfType: entering", theRelTypeName);
        }
        RelationType relType = this.getRelationType(theRelTypeName);
        ArrayList result = new ArrayList();
        HashMap hashMap = this.myRelType2RelIdsMap;
        synchronized (hashMap) {
            ArrayList result1 = (ArrayList)this.myRelType2RelIdsMap.get(theRelTypeName);
            if (result1 != null) {
                result = (ArrayList)result1.clone();
            }
        }
        if (this.isTraceOn()) {
            this.trace("findRelationsOfType: exiting", null);
        }
        return result;
    }

    public List getRole(String theRelId, String theRoleName) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        if (theRelId == null || theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = "theRelId " + theRelId + ", theRoleName " + theRoleName;
            this.trace("getRole: entering", str);
        }
        this.isActive();
        Object relObj = this.getRelation(theRelId);
        ArrayList result = null;
        if (relObj instanceof RelationSupport) {
            result = (ArrayList)((RelationSupport)relObj).getRoleInt(theRoleName, true, this, false);
        } else {
            Object[] params = new Object[]{theRoleName};
            String[] signature = new String[]{"java.lang.String"};
            try {
                result = (ArrayList)this.myMBeanServer.invoke((ObjectName)relObj, "getRole", params, signature);
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (MBeanException exc3) {
                Exception wrappedExc = exc3.getTargetException();
                if (wrappedExc instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)wrappedExc;
                }
                throw new RuntimeException(wrappedExc.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRole: exiting", null);
        }
        return result;
    }

    public RoleResult getRoles(String theRelId, String[] theRoleNameArray) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null || theRoleNameArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: entering", theRelId);
        }
        this.isActive();
        Object relObj = this.getRelation(theRelId);
        RoleResult result = null;
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getRolesInt(theRoleNameArray, true, this);
        } else {
            Object[] params = new Object[]{theRoleNameArray};
            String[] signature = new String[1];
            try {
                signature[0] = theRoleNameArray.getClass().getName();
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                result = (RoleResult)this.myMBeanServer.invoke((ObjectName)relObj, "getRoles", params, signature);
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (MBeanException exc3) {
                throw new RuntimeException(exc3.getTargetException().getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: exiting", null);
        }
        return result;
    }

    public RoleResult getAllRoles(String theRelId) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: entering", theRelId);
        }
        Object relObj = this.getRelation(theRelId);
        RoleResult result = null;
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getAllRolesInt(true, this);
        } else {
            try {
                result = (RoleResult)this.myMBeanServer.getAttribute((ObjectName)relObj, "AllRoles");
            }
            catch (Exception exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: exiting", null);
        }
        return result;
    }

    public Integer getRoleCardinality(String theRelId, String theRoleName) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        if (theRelId == null || theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = "theRelId " + theRelId + ", theRoleName " + theRoleName;
            this.trace("getRoleCardinality: entering", str);
        }
        Object relObj = this.getRelation(theRelId);
        Integer result = null;
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getRoleCardinality(theRoleName);
        } else {
            Object[] params = new Object[]{theRoleName};
            String[] signature = new String[]{"java.lang.String"};
            try {
                result = (Integer)this.myMBeanServer.invoke((ObjectName)relObj, "getRoleCardinality", params, signature);
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (MBeanException exc3) {
                Exception wrappedExc = exc3.getTargetException();
                if (wrappedExc instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)wrappedExc;
                }
                throw new RuntimeException(wrappedExc.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRoleCardinality: exiting", null);
        }
        return result;
    }

    public void setRole(String theRelId, Role theRole) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        if (theRelId == null || theRole == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = new String("theRelId " + theRelId + ", theRole " + theRole.toString());
            this.trace("setRole: entering", str);
        }
        this.isActive();
        Object relObj = this.getRelation(theRelId);
        if (relObj instanceof RelationSupport) {
            try {
                ((RelationSupport)relObj).setRoleInt(theRole, true, this, false);
            }
            catch (RelationTypeNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{theRole};
        String[] signature = new String[]{"javax.management.relation.Role"};
        try {
            this.myMBeanServer.setAttribute((ObjectName)relObj, new Attribute("Role", theRole));
        }
        catch (InstanceNotFoundException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (ReflectionException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        catch (MBeanException exc2) {
            Exception wrappedExc = exc2.getTargetException();
            if (wrappedExc instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)wrappedExc;
            }
            if (wrappedExc instanceof InvalidRoleValueException) {
                throw (InvalidRoleValueException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        catch (AttributeNotFoundException exc4) {
            throw new RuntimeException(exc4.getMessage());
        }
        catch (InvalidAttributeValueException exc5) {
            throw new RuntimeException(exc5.getMessage());
        }
        if (this.isTraceOn()) {
            this.trace("setRole: exiting", null);
        }
    }

    public RoleResult setRoles(String theRelId, RoleList theRoleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null || theRoleList == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            String str = new String("theRelId " + theRelId + ", theRoleList " + theRoleList.toString());
            this.trace("setRoles: entering", str);
        }
        this.isActive();
        Object relObj = this.getRelation(theRelId);
        RoleResult result = null;
        if (relObj instanceof RelationSupport) {
            try {
                result = ((RelationSupport)relObj).setRolesInt(theRoleList, true, this);
            }
            catch (RelationTypeNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{theRoleList};
        String[] signature = new String[]{"javax.management.relation.RoleList"};
        try {
            result = (RoleResult)this.myMBeanServer.invoke((ObjectName)relObj, "setRoles", params, signature);
        }
        catch (InstanceNotFoundException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (ReflectionException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        catch (MBeanException exc2) {
            throw new RuntimeException(exc2.getTargetException().getMessage());
        }
        if (this.isTraceOn()) {
            this.trace("setRoles: exiting", null);
        }
        return result;
    }

    public Map getReferencedMBeans(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: entering", theRelId);
        }
        Object relObj = this.getRelation(theRelId);
        HashMap result = null;
        if (relObj instanceof RelationSupport) {
            result = (HashMap)((RelationSupport)relObj).getReferencedMBeans();
        } else {
            try {
                result = (HashMap)this.myMBeanServer.getAttribute((ObjectName)relObj, "ReferencedMBeans");
            }
            catch (Exception exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: exiting", null);
        }
        return result;
    }

    public String getRelationTypeName(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("getRelationTypeName: entering", theRelId);
        }
        Object relObj = this.getRelation(theRelId);
        String result = null;
        if (relObj instanceof RelationSupport) {
            result = ((RelationSupport)relObj).getRelationTypeName();
        } else {
            try {
                result = (String)this.myMBeanServer.getAttribute((ObjectName)relObj, "RelationTypeName");
            }
            catch (Exception exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        if (this.isTraceOn()) {
            this.trace("getRelationTypeName: exiting", null);
        }
        return result;
    }

    public void handleNotification(Notification theNtf, Object theHandback) {
        String ntfType;
        if (theNtf == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isTraceOn()) {
            this.trace("handleNotification: entering", theNtf.toString());
        }
        if (theNtf instanceof MBeanServerNotification && (ntfType = theNtf.getType()).equals("JMX.mbean.unregistered")) {
            ObjectName mbeanName = ((MBeanServerNotification)theNtf).getMBeanName();
            boolean isRefedMBeanFlg = false;
            HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
            synchronized (hashMap) {
                if (this.myRefedMBeanObjName2RelIdsMap.containsKey(mbeanName)) {
                    ArrayList arrayList = this.myUnregNtfList;
                    synchronized (arrayList) {
                        this.myUnregNtfList.add(theNtf);
                    }
                    isRefedMBeanFlg = true;
                }
                if (isRefedMBeanFlg && this.myPurgeFlg) {
                    try {
                        this.purgeRelations();
                    }
                    catch (Exception exc) {
                        throw new RuntimeException(exc.getMessage());
                    }
                }
            }
            String relId = null;
            HashMap hashMap2 = this.myRelMBeanObjName2RelIdMap;
            synchronized (hashMap2) {
                relId = (String)this.myRelMBeanObjName2RelIdMap.get(mbeanName);
            }
            if (relId != null) {
                try {
                    this.removeRelation(relId);
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("handleNotification: exiting", null);
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.isTraceOn()) {
            this.trace("getNotificationInfo: entering", null);
        }
        MBeanNotificationInfo[] ntfInfoArray = new MBeanNotificationInfo[1];
        String[] ntfTypes = new String[]{"jmx.relation.creation.basic", "jmx.relation.creation.mbean", "jmx.relation.update.basic", "jmx.relation.update.mbean", "jmx.relation.removal.basic", "jmx.relation.removal.mbean"};
        String ntfDesc = "Sent when a relation is created, updated or deleted.";
        ntfInfoArray[0] = new MBeanNotificationInfo(ntfTypes, "RelationNotification", ntfDesc);
        if (this.isTraceOn()) {
            this.trace("getNotificationInfo: exiting", null);
        }
        return ntfInfoArray;
    }

    private void addRelationTypeInt(RelationType theRelTypeObj) throws IllegalArgumentException, InvalidRelationTypeException {
        if (theRelTypeObj == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            this.debug("addRelationTypeInt: entering", null);
        }
        String relTypeName = theRelTypeObj.getRelationTypeName();
        try {
            RelationType relType = this.getRelationType(relTypeName);
            if (relType != null) {
                String excMsg = "There is already a relation type in the Relation Service with name ";
                StringBuffer excMsgStrB = new StringBuffer(excMsg);
                excMsgStrB.append(relTypeName);
                throw new InvalidRelationTypeException(excMsgStrB.toString());
            }
        }
        catch (RelationTypeNotFoundException relationTypeNotFoundException) {
            // empty catch block
        }
        HashMap hashMap = this.myRelType2ObjMap;
        synchronized (hashMap) {
            this.myRelType2ObjMap.put(relTypeName, theRelTypeObj);
        }
        if (theRelTypeObj instanceof RelationTypeSupport) {
            ((RelationTypeSupport)theRelTypeObj).setRelationServiceFlag(true);
        }
        if (this.isDebugOn()) {
            this.debug("addRelationTypeInt: exiting", null);
        }
    }

    RelationType getRelationType(String theRelTypeName) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (theRelTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            this.debug("getRelationType: entering", theRelTypeName);
        }
        RelationType relType = null;
        HashMap hashMap = this.myRelType2ObjMap;
        synchronized (hashMap) {
            relType = (RelationType)this.myRelType2ObjMap.get(theRelTypeName);
        }
        if (relType == null) {
            String excMsg = "No relation type created in the Relation Service with the name ";
            StringBuffer excMsgStrB = new StringBuffer(excMsg);
            excMsgStrB.append(theRelTypeName);
            throw new RelationTypeNotFoundException(excMsgStrB.toString());
        }
        if (this.isDebugOn()) {
            this.debug("getRelationType: exiting", null);
        }
        return relType;
    }

    Object getRelation(String theRelId) throws IllegalArgumentException, RelationNotFoundException {
        if (theRelId == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            this.debug("getRelation: entering", theRelId);
        }
        Object rel = null;
        HashMap hashMap = this.myRelId2ObjMap;
        synchronized (hashMap) {
            rel = this.myRelId2ObjMap.get(theRelId);
        }
        if (rel == null) {
            StringBuffer excMsgStrB = new StringBuffer();
            String excMsg = "No relation associated to relation id ";
            excMsgStrB.append(excMsg);
            excMsgStrB.append(theRelId);
            throw new RelationNotFoundException(excMsgStrB.toString());
        }
        if (this.isDebugOn()) {
            this.debug("getRelation: exiting", null);
        }
        return rel;
    }

    private boolean addNewMBeanReference(ObjectName theObjName, String theRelId, String theRoleName) throws IllegalArgumentException {
        if (theObjName == null || theRelId == null || theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = new String("theObjName " + theObjName.toString() + ", theRelId " + theRelId + ", theRoleName " + theRoleName);
            this.debug("addNewMBeanReference: entering", str);
        }
        boolean isNewFlg = false;
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            HashMap<String, ArrayList<String>> mbeanRefMap = (HashMap<String, ArrayList<String>>)this.myRefedMBeanObjName2RelIdsMap.get(theObjName);
            if (mbeanRefMap == null) {
                isNewFlg = true;
                ArrayList<String> roleNames = new ArrayList<String>();
                roleNames.add(theRoleName);
                mbeanRefMap = new HashMap<String, ArrayList<String>>();
                mbeanRefMap.put(theRelId, roleNames);
                this.myRefedMBeanObjName2RelIdsMap.put(theObjName, mbeanRefMap);
            } else {
                ArrayList<String> roleNames = (ArrayList<String>)mbeanRefMap.get(theRelId);
                if (roleNames == null) {
                    roleNames = new ArrayList<String>();
                    roleNames.add(theRoleName);
                    mbeanRefMap.put(theRelId, roleNames);
                } else {
                    roleNames.add(theRoleName);
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("addNewMBeanReference: exiting", null);
        }
        return isNewFlg;
    }

    private boolean removeMBeanReference(ObjectName theObjName, String theRelId, String theRoleName, boolean theAllRolesFlg) throws IllegalArgumentException {
        if (theObjName == null || theRelId == null || theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = new String("theObjName " + theObjName.toString() + ", theRelId " + theRelId + ", theRoleName " + theRoleName + ", theAllRolesFlg " + theAllRolesFlg);
            this.debug("removeMBeanReference: entering", str);
        }
        boolean noLongerRefFlg = false;
        HashMap hashMap = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (hashMap) {
            int obsRefIdx;
            HashMap mbeanRefMap = (HashMap)this.myRefedMBeanObjName2RelIdsMap.get(theObjName);
            if (mbeanRefMap == null) {
                if (this.isDebugOn()) {
                    this.debug("removeMBeanReference: exiting", null);
                }
                boolean bl = true;
                return bl;
            }
            ArrayList roleNames = new ArrayList();
            if (!theAllRolesFlg && (obsRefIdx = (roleNames = (ArrayList)mbeanRefMap.get(theRelId)).indexOf(theRoleName)) != -1) {
                roleNames.remove(obsRefIdx);
            }
            if (roleNames.isEmpty() || theAllRolesFlg) {
                mbeanRefMap.remove(theRelId);
            }
            if (mbeanRefMap.isEmpty()) {
                this.myRefedMBeanObjName2RelIdsMap.remove(theObjName);
                noLongerRefFlg = true;
            }
        }
        if (this.isDebugOn()) {
            this.debug("removeMBeanReference: exiting", null);
        }
        return noLongerRefFlg;
    }

    private void updateUnregistrationListener(List theNewRefList, List theObsRefList) throws RelationServiceNotRegisteredException {
        if (theNewRefList != null && theObsRefList != null && theNewRefList.isEmpty() && theObsRefList.isEmpty()) {
            return;
        }
        if (this.isDebugOn()) {
            StringBuffer strB = new StringBuffer();
            if (theNewRefList != null) {
                strB.append("theNewRefList " + theNewRefList.toString());
            }
            if (theObsRefList != null) {
                strB.append(", theObsRefList" + theObsRefList.toString());
            }
            this.debug("updateUnregistrationListener: entering", strB.toString());
        }
        this.isActive();
        if (theNewRefList != null || theObsRefList != null) {
            boolean newListenerFlg = false;
            if (this.myUnregNtfFilter == null) {
                this.myUnregNtfFilter = new MBeanServerNotificationFilter();
                newListenerFlg = true;
            }
            MBeanServerNotificationFilter mBeanServerNotificationFilter = this.myUnregNtfFilter;
            synchronized (mBeanServerNotificationFilter) {
                if (theNewRefList != null) {
                    Iterator newRefIter = theNewRefList.iterator();
                    while (newRefIter.hasNext()) {
                        ObjectName newObjName = (ObjectName)newRefIter.next();
                        this.myUnregNtfFilter.enableObjectName(newObjName);
                    }
                }
                if (theObsRefList != null) {
                    Iterator obsRefIter = theObsRefList.iterator();
                    while (obsRefIter.hasNext()) {
                        ObjectName obsObjName = (ObjectName)obsRefIter.next();
                        this.myUnregNtfFilter.disableObjectName(obsObjName);
                    }
                }
                ObjectName mbeanServerDelegateName = null;
                mbeanServerDelegateName = ObjectNameFactory.getMBeanServerDelegateName();
                if (newListenerFlg) {
                    try {
                        this.myMBeanServer.addNotificationListener(mbeanServerDelegateName, this, (NotificationFilter)this.myUnregNtfFilter, null);
                    }
                    catch (InstanceNotFoundException exc) {
                        throw new RelationServiceNotRegisteredException(exc.getMessage());
                    }
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("updateUnregistrationListener: exiting", null);
        }
    }

    private void addRelationInt(boolean theRelBaseFlg, RelationSupport theRelObj, ObjectName theRelObjName, String theRelId, String theRelTypeName, RoleList theRoleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        if (theRelId == null || theRelTypeName == null || theRelBaseFlg && (theRelObj == null || theRelObjName != null) || !theRelBaseFlg && (theRelObjName == null || theRelObj != null)) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            StringBuffer strB = new StringBuffer("theRelBaseFlg " + theRelBaseFlg + ", theRelId " + theRelId + ", theRelTypeName " + theRelTypeName);
            if (theRelObjName != null) {
                strB.append(",  theRelObjName " + theRelObjName.toString());
            }
            if (theRoleList != null) {
                strB.append(", theRoleList " + theRoleList.toString());
            }
            this.debug("addRelationInt: entering", strB.toString());
        }
        this.isActive();
        try {
            Object rel = this.getRelation(theRelId);
            if (rel != null) {
                String excMsg = "There is already a relation with id ";
                StringBuffer excMsgStrB = new StringBuffer(excMsg);
                excMsgStrB.append(theRelId);
                throw new InvalidRelationIdException(excMsgStrB.toString());
            }
        }
        catch (RelationNotFoundException exc) {
            // empty catch block
        }
        RelationType relType = this.getRelationType(theRelTypeName);
        ArrayList roleInfoList = (ArrayList)((ArrayList)relType.getRoleInfos()).clone();
        if (theRoleList != null) {
            Iterator roleIter = ((AbstractList)theRoleList).iterator();
            while (roleIter.hasNext()) {
                Role currRole = (Role)roleIter.next();
                String currRoleName = currRole.getRoleName();
                ArrayList currRoleValue = (ArrayList)currRole.getRoleValue();
                RoleInfo roleInfo = null;
                try {
                    roleInfo = relType.getRoleInfo(currRoleName);
                }
                catch (RoleInfoNotFoundException exc) {
                    throw new RoleNotFoundException(exc.getMessage());
                }
                Integer status = this.checkRoleInt(2, currRoleName, currRoleValue, roleInfo, false);
                int pbType = status;
                if (pbType != 0) {
                    RelationService.throwRoleProblemException(pbType, currRoleName);
                }
                int roleInfoIdx = roleInfoList.indexOf(roleInfo);
                roleInfoList.remove(roleInfoIdx);
            }
        }
        this.initialiseMissingRoles(theRelBaseFlg, theRelObj, theRelObjName, theRelId, theRelTypeName, roleInfoList);
        HashMap hashMap = this.myRelId2ObjMap;
        synchronized (hashMap) {
            if (theRelBaseFlg) {
                this.myRelId2ObjMap.put(theRelId, theRelObj);
            } else {
                this.myRelId2ObjMap.put(theRelId, theRelObjName);
            }
        }
        HashMap hashMap2 = this.myRelId2RelTypeMap;
        synchronized (hashMap2) {
            this.myRelId2RelTypeMap.put(theRelId, theRelTypeName);
        }
        HashMap hashMap3 = this.myRelType2RelIdsMap;
        synchronized (hashMap3) {
            ArrayList<String> relIdList = (ArrayList<String>)this.myRelType2RelIdsMap.get(theRelTypeName);
            boolean firstRelFlg = false;
            if (relIdList == null) {
                firstRelFlg = true;
                relIdList = new ArrayList<String>();
            }
            relIdList.add(theRelId);
            if (firstRelFlg) {
                this.myRelType2RelIdsMap.put(theRelTypeName, relIdList);
            }
        }
        Iterator roleIter = ((AbstractList)theRoleList).iterator();
        while (roleIter.hasNext()) {
            Role currRole = (Role)roleIter.next();
            ArrayList dummyList = new ArrayList();
            try {
                this.updateRoleMap(theRelId, currRole, dummyList);
            }
            catch (RelationNotFoundException exc) {
                // empty catch block
            }
        }
        try {
            this.sendRelationCreationNotification(theRelId);
        }
        catch (RelationNotFoundException exc) {
            // empty catch block
        }
        if (this.isDebugOn()) {
            this.debug("addRelationInt: exiting", null);
        }
    }

    private Integer checkRoleInt(int theChkType, String theRoleName, List theRoleValue, RoleInfo theRoleInfo, boolean theWriteChkFlg) throws IllegalArgumentException {
        boolean isWritable;
        String expName;
        if (theRoleName == null || theRoleInfo == null || theChkType == 2 && theRoleValue == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            StringBuffer strB = new StringBuffer("theChkType " + theChkType + ", theRoleName " + theRoleName + ", theRoleInfo " + theRoleInfo.toString() + ", theWriteChkFlg " + theWriteChkFlg);
            if (theRoleValue != null) {
                strB.append(", theRoleValue " + theRoleValue.toString());
            }
            this.debug("checkRoleInt: entering", strB.toString());
        }
        if (!theRoleName.equals(expName = theRoleInfo.getName())) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(1);
        }
        if (theChkType == 1) {
            boolean isReadable = theRoleInfo.isReadable();
            if (!isReadable) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(2);
            }
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(0);
        }
        if (theWriteChkFlg && !(isWritable = theRoleInfo.isWritable())) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(3);
        }
        int refNbr = theRoleValue.size();
        boolean chkMinFlg = theRoleInfo.checkMinDegree(refNbr);
        if (!chkMinFlg) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(4);
        }
        boolean chkMaxFlg = theRoleInfo.checkMaxDegree(refNbr);
        if (!chkMaxFlg) {
            if (this.isDebugOn()) {
                this.debug("checkRoleInt: exiting", null);
            }
            return new Integer(5);
        }
        String expClassName = theRoleInfo.getRefMBeanClassName();
        Iterator refMBeanIter = theRoleValue.iterator();
        while (refMBeanIter.hasNext()) {
            ObjectName currObjName = (ObjectName)refMBeanIter.next();
            if (currObjName == null) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(7);
            }
            try {
                boolean classSts = this.myMBeanServer.isInstanceOf(currObjName, expClassName);
                if (classSts) continue;
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(6);
            }
            catch (InstanceNotFoundException exc) {
                if (this.isDebugOn()) {
                    this.debug("checkRoleInt: exiting", null);
                }
                return new Integer(7);
            }
        }
        if (this.isDebugOn()) {
            this.debug("checkRoleInt: exiting", null);
        }
        return new Integer(0);
    }

    private void initialiseMissingRoles(boolean theRelBaseFlg, RelationSupport theRelObj, ObjectName theRelObjName, String theRelId, String theRelTypeName, List theRoleInfoList) throws IllegalArgumentException, RelationServiceNotRegisteredException, InvalidRoleValueException {
        if (theRelBaseFlg && (theRelObj == null || theRelObjName != null) || !theRelBaseFlg && (theRelObjName == null || theRelObj != null) || theRelId == null || theRelTypeName == null || theRoleInfoList == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            StringBuffer strB = new StringBuffer("theRelBaseFlg " + theRelBaseFlg + ", theRelId " + theRelId + ", theRelTypeName " + theRelTypeName + ", theRoleInfoList " + theRoleInfoList);
            if (theRelObjName != null) {
                strB.append(theRelObjName.toString());
            }
            this.debug("initialiseMissingRoles: entering", strB.toString());
        }
        this.isActive();
        Iterator roleInfoIter = theRoleInfoList.iterator();
        while (roleInfoIter.hasNext()) {
            RoleInfo currRoleInfo = (RoleInfo)roleInfoIter.next();
            String roleName = currRoleInfo.getName();
            ArrayList emptyValue = new ArrayList();
            Role role = new Role(roleName, emptyValue);
            if (theRelBaseFlg) {
                try {
                    theRelObj.setRoleInt(role, true, this, false);
                    continue;
                }
                catch (RoleNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
                catch (RelationNotFoundException exc2) {
                    throw new RuntimeException(exc2.getMessage());
                }
                catch (RelationTypeNotFoundException exc3) {
                    throw new RuntimeException(exc3.getMessage());
                }
            }
            Object[] params = new Object[]{role};
            String[] signature = new String[]{"javax.management.relation.Role"};
            try {
                this.myMBeanServer.setAttribute(theRelObjName, new Attribute("Role", role));
            }
            catch (InstanceNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (ReflectionException exc3) {
                throw new RuntimeException(exc3.getMessage());
            }
            catch (MBeanException exc2) {
                Exception wrappedExc = exc2.getTargetException();
                if (wrappedExc instanceof InvalidRoleValueException) {
                    throw (InvalidRoleValueException)wrappedExc;
                }
                throw new RuntimeException(wrappedExc.getMessage());
            }
            catch (AttributeNotFoundException exc4) {
                throw new RuntimeException(exc4.getMessage());
            }
            catch (InvalidAttributeValueException exc5) {
                throw new RuntimeException(exc5.getMessage());
            }
        }
        if (this.isDebugOn()) {
            this.debug("initializeMissingRoles: exiting", null);
        }
    }

    static void throwRoleProblemException(int thePbType, String theRoleName) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException {
        if (theRoleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        int excType = 0;
        String excMsgPart = null;
        switch (thePbType) {
            case 1: {
                excMsgPart = " does not exist in relation.";
                excType = 1;
                break;
            }
            case 2: {
                excMsgPart = " is not readable.";
                excType = 1;
                break;
            }
            case 3: {
                excMsgPart = " is not writable.";
                excType = 1;
                break;
            }
            case 4: {
                excMsgPart = " has a number of MBean references less than the expected minimum degree.";
                excType = 2;
                break;
            }
            case 5: {
                excMsgPart = " has a number of MBean references greater than the expected maximum degree.";
                excType = 2;
                break;
            }
            case 6: {
                excMsgPart = " has an MBean reference to an MBean not of the expected class of references for that role.";
                excType = 2;
                break;
            }
            case 7: {
                excMsgPart = " has a reference to null or to an MBean not registered.";
                excType = 2;
            }
        }
        StringBuffer excMsgStrB = new StringBuffer(theRoleName);
        excMsgStrB.append(excMsgPart);
        String excMsg = excMsgStrB.toString();
        if (excType == 1) {
            throw new RoleNotFoundException(excMsg);
        }
        if (excType == 2) {
            throw new InvalidRoleValueException(excMsg);
        }
    }

    private void sendNotificationInt(int theIntNtfType, String theMsg, String theRelId, List theUnregMBeanList, String theRoleName, List theRoleNewValue, List theOldRoleValue) throws IllegalArgumentException, RelationNotFoundException {
        if (theMsg == null || theRelId == null || theIntNtfType != 3 && theUnregMBeanList != null || theIntNtfType == 2 && (theRoleName == null || theRoleNewValue == null || theOldRoleValue == null)) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            StringBuffer strB = new StringBuffer("theIntNtfType " + theIntNtfType + ", theMsg " + theMsg + ", theRelId " + theRelId);
            if (theUnregMBeanList != null) {
                strB.append(", theUnregMBeanList " + theUnregMBeanList.toString());
            }
            if (theRoleName != null) {
                strB.append(", theRoleName " + theRoleName);
            }
            if (theRoleNewValue != null) {
                strB.append(", theRoleNewValue " + theRoleNewValue.toString());
            }
            if (theOldRoleValue != null) {
                strB.append(", theOldRoleValue " + theOldRoleValue.toString());
            }
            this.debug("sendNotificationInt: entering", strB.toString());
        }
        String relTypeName = null;
        HashMap hashMap = this.myRelId2RelTypeMap;
        synchronized (hashMap) {
            relTypeName = (String)this.myRelId2RelTypeMap.get(theRelId);
        }
        ObjectName relObjName = this.isRelationMBean(theRelId);
        String ntfType = null;
        if (relObjName != null) {
            switch (theIntNtfType) {
                case 1: {
                    ntfType = "jmx.relation.creation.mbean";
                    break;
                }
                case 2: {
                    ntfType = "jmx.relation.update.mbean";
                    break;
                }
                case 3: {
                    ntfType = "jmx.relation.removal.mbean";
                }
            }
        } else {
            switch (theIntNtfType) {
                case 1: {
                    ntfType = "jmx.relation.creation.basic";
                    break;
                }
                case 2: {
                    ntfType = "jmx.relation.update.basic";
                    break;
                }
                case 3: {
                    ntfType = "jmx.relation.removal.basic";
                }
            }
        }
        Long seqNbr = this.getNotificationSequenceNumber();
        Date currDate = new Date();
        long timeStamp = currDate.getTime();
        RelationNotification ntf = null;
        if (ntfType.equals("jmx.relation.creation.basic") || ntfType.equals("jmx.relation.creation.mbean") || ntfType.equals("jmx.relation.removal.basic") || ntfType.equals("jmx.relation.removal.mbean")) {
            ntf = new RelationNotification(ntfType, this, seqNbr, timeStamp, theMsg, theRelId, relTypeName, relObjName, theUnregMBeanList);
        } else if (ntfType.equals("jmx.relation.update.basic") || ntfType.equals("jmx.relation.update.mbean")) {
            ntf = new RelationNotification(ntfType, this, seqNbr, timeStamp, theMsg, theRelId, relTypeName, relObjName, theRoleName, theRoleNewValue, theOldRoleValue);
        }
        this.sendNotification(ntf);
        if (this.isDebugOn()) {
            this.debug("sendNotificationInt: exiting", null);
        }
    }

    private void handleReferenceUnregistration(String theRelId, ObjectName theObjName, List theRoleNameList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException {
        if (theRelId == null || theRoleNameList == null || theObjName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        if (this.isDebugOn()) {
            String str = new String("theRelId " + theRelId + ", theRoleNameList " + theRoleNameList.toString() + "theObjName " + theObjName.toString());
            this.debug("handleReferenceUnregistration: entering", str);
        }
        this.isActive();
        String currRelTypeName = this.getRelationTypeName(theRelId);
        Object relObj = this.getRelation(theRelId);
        boolean deleteRelFlg = false;
        Iterator roleNameIter = theRoleNameList.iterator();
        while (roleNameIter.hasNext()) {
            if (deleteRelFlg) break;
            String currRoleName = (String)roleNameIter.next();
            int currRoleRefNbr = this.getRoleCardinality(theRelId, currRoleName);
            int currRoleNewRefNbr = currRoleRefNbr - 1;
            RoleInfo currRoleInfo = null;
            try {
                currRoleInfo = this.getRoleInfo(currRelTypeName, currRoleName);
            }
            catch (RelationTypeNotFoundException exc1) {
                throw new RuntimeException(exc1.getMessage());
            }
            catch (RoleInfoNotFoundException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            boolean chkMinFlg = currRoleInfo.checkMinDegree(currRoleNewRefNbr);
            if (chkMinFlg) continue;
            deleteRelFlg = true;
        }
        if (deleteRelFlg) {
            this.removeRelation(theRelId);
        } else {
            Iterator roleNameIter2 = theRoleNameList.iterator();
            while (roleNameIter2.hasNext()) {
                String currRoleName = (String)roleNameIter2.next();
                if (relObj instanceof RelationSupport) {
                    try {
                        ((RelationSupport)relObj).handleMBeanUnregistrationInt(theObjName, currRoleName, true, this);
                        continue;
                    }
                    catch (RelationTypeNotFoundException exc3) {
                        throw new RuntimeException(exc3.getMessage());
                    }
                    catch (InvalidRoleValueException exc4) {
                        throw new RuntimeException(exc4.getMessage());
                    }
                }
                Object[] params = new Object[]{theObjName, currRoleName};
                String[] signature = new String[]{"javax.management.ObjectName", "java.lang.String"};
                try {
                    this.myMBeanServer.invoke((ObjectName)relObj, "handleMBeanUnregistration", params, signature);
                }
                catch (InstanceNotFoundException exc1) {
                    throw new RuntimeException(exc1.getMessage());
                }
                catch (ReflectionException exc3) {
                    throw new RuntimeException(exc3.getMessage());
                }
                catch (MBeanException exc2) {
                    Exception wrappedExc = exc2.getTargetException();
                    throw new RuntimeException(wrappedExc.getMessage());
                }
            }
        }
        if (this.isDebugOn()) {
            this.debug("handleReferenceUnregistration: exiting", null);
        }
    }

    private boolean isTraceOn() {
        return false;
    }

    private void trace(String methodName, String info) {
    }

    private boolean isDebugOn() {
        return false;
    }

    private void debug(String methodName, String info) {
    }
}

