/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class TabularType
extends OpenType
implements Serializable {
    static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType;
    private List indexNames;
    private transient Integer myHashCode = null;
    private transient String myToString = null;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;

    public TabularType(String typeName, String description, CompositeType rowType, String[] indexNames) throws OpenDataException {
        super((class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = TabularType.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName(), typeName, description);
        if (rowType == null) {
            throw new IllegalArgumentException("Argument rowType cannot be null.");
        }
        TabularType.checkForNullElement(indexNames, "indexNames");
        TabularType.checkForEmptyString(indexNames, "indexNames");
        int i = 0;
        while (i < indexNames.length) {
            if (!rowType.containsKey(indexNames[i])) {
                throw new OpenDataException("Argument's element value indexNames[" + i + "]=\"" + indexNames[i] + "\" is not a valid item name for rowType.");
            }
            ++i;
        }
        this.rowType = rowType;
        ArrayList<String> tmpList = new ArrayList<String>(indexNames.length + 1);
        int i2 = 0;
        while (i2 < indexNames.length) {
            tmpList.add(indexNames[i2]);
            ++i2;
        }
        this.indexNames = Collections.unmodifiableList(tmpList);
    }

    private static void checkForNullElement(Object[] arg, String argName) {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("Argument " + argName + "[] cannot be null or empty.");
        }
        int i = 0;
        while (i < arg.length) {
            if (arg[i] == null) {
                throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be null.");
            }
            ++i;
        }
    }

    private static void checkForEmptyString(String[] arg, String argName) {
        int i = 0;
        while (i < arg.length) {
            if (arg[i].trim().equals("")) {
                throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be an empty string.");
            }
            ++i;
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List getIndexNames() {
        return this.indexNames;
    }

    public boolean isValue(Object obj) {
        TabularData value;
        if (obj == null) {
            return false;
        }
        try {
            value = (TabularData)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.equals(value.getTabularType());
    }

    public boolean equals(Object obj) {
        TabularType other;
        if (obj == null) {
            return false;
        }
        try {
            other = (TabularType)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        if (!this.rowType.equals(other.rowType)) {
            return false;
        }
        return this.indexNames.equals(other.indexNames);
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getTypeName().hashCode();
            value += this.rowType.hashCode();
            Iterator k = this.indexNames.iterator();
            while (k.hasNext()) {
                value += k.next().hashCode();
            }
            this.myHashCode = new Integer(value);
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            StringBuffer result = new StringBuffer().append(this.getClass().getName()).append("(name=").append(this.getTypeName()).append(",rowType=").append(this.rowType.toString()).append(",indexNames=(");
            int i = 0;
            Iterator k = this.indexNames.iterator();
            while (k.hasNext()) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(k.next().toString());
                ++i;
            }
            result.append("))");
            this.myToString = result.toString();
        }
        return this.myToString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

