/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.management.openmbean.OpenDataException;

public abstract class OpenType
implements Serializable {
    static final long serialVersionUID = -9195195325186646468L;
    public static final String[] ALLOWED_CLASSNAMES = new String[]{"java.lang.Void", "java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.util.Date", "javax.management.ObjectName", (class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = OpenType.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName(), (class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = OpenType.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName()};
    private String className;
    private String description;
    private String typeName;
    private transient boolean isArray = false;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;

    protected OpenType(String className, String typeName, String description) throws OpenDataException {
        String eltClassName;
        if (className == null || className.trim().equals("")) {
            throw new IllegalArgumentException("Argument className cannot be null or empty.");
        }
        if (typeName == null || typeName.trim().equals("")) {
            throw new IllegalArgumentException("Argument typeName cannot be null or empty.");
        }
        if (description == null || description.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty.");
        }
        className = className.trim();
        typeName = typeName.trim();
        description = description.trim();
        int n = 0;
        while (className.startsWith("[", n)) {
            ++n;
        }
        boolean isArray = false;
        if (n > 0) {
            eltClassName = className.substring(n + 1, className.length() - 1);
            isArray = true;
        } else {
            eltClassName = className;
        }
        boolean ok = false;
        int i = 0;
        while (i < ALLOWED_CLASSNAMES.length) {
            if (ALLOWED_CLASSNAMES[i].equals(eltClassName)) {
                ok = true;
                break;
            }
            ++i;
        }
        if (!ok) {
            throw new OpenDataException("Argument className=\"" + className + "\" is not one of the allowed Java class names for open data.");
        }
        this.className = className;
        this.typeName = typeName;
        this.description = description;
        this.isArray = isArray;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public abstract boolean isValue(Object var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.isArray = this.className.startsWith("[");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

