/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenType;

public class OpenMBeanOperationInfoSupport
extends MBeanOperationInfo
implements OpenMBeanOperationInfo,
Serializable {
    static final long serialVersionUID = 4996859732565369366L;
    private OpenType returnOpenType;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanOperationInfoSupport(String name, String description, OpenMBeanParameterInfo[] signature, OpenType returnOpenType, int impact) {
        super(name, description, signature == null ? null : OpenMBeanOperationInfoSupport.arrayCopyCast(signature), returnOpenType == null ? null : returnOpenType.getClassName(), impact);
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("Argument name cannot be null or empty.");
        }
        if (description == null || description.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty.");
        }
        if (returnOpenType == null) {
            throw new IllegalArgumentException("Argument returnOpenType cannot be null.");
        }
        if (impact != 1 && impact != 2 && impact != 0) {
            throw new IllegalArgumentException("Argument impact can be only one of ACTION, ACTION_INFO or INFO.");
        }
        this.returnOpenType = returnOpenType;
    }

    private static MBeanParameterInfo[] arrayCopyCast(OpenMBeanParameterInfo[] src) throws ArrayStoreException {
        MBeanParameterInfo[] dst = new MBeanParameterInfo[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    public OpenType getReturnOpenType() {
        return this.returnOpenType;
    }

    public boolean equals(Object obj) {
        OpenMBeanOperationInfo other;
        if (obj == null) {
            return false;
        }
        try {
            other = (OpenMBeanOperationInfo)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        if (!this.getReturnOpenType().equals(other.getReturnOpenType())) {
            return false;
        }
        return this.getImpact() == other.getImpact();
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getName().hashCode();
            value += Arrays.asList(this.getSignature()).hashCode();
            value += this.getReturnOpenType().hashCode();
            this.myHashCode = new Integer(value += this.getImpact());
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(name=" + this.getName() + ",signature=" + Arrays.asList(this.getSignature()).toString() + ",return=" + this.getReturnOpenType().toString() + ",impact=" + this.getImpact() + ")";
        }
        return this.myToString;
    }
}

