/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo,
Serializable {
    static final long serialVersionUID = -4867215622149721849L;
    private OpenType openType;
    private Object defaultValue = null;
    private Set legalValues = null;
    private Comparable minValue = null;
    private Comparable maxValue = null;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, openType == null ? null : openType.getClassName(), description, isReadable, isWritable, isIs);
        if (name == null || name.trim().equals("")) {
            throw new IllegalArgumentException("Argument name cannot be null or empty.");
        }
        if (openType == null) {
            throw new IllegalArgumentException("Argument openType cannot be null.");
        }
        if (description == null || description.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty.");
        }
        this.openType = openType;
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs);
        if (defaultValue != null) {
            if (openType.isArray() || openType instanceof TabularType) {
                throw new OpenDataException("Default value not supported for ArrayType and TabularType.");
            }
            if (!openType.isValue(defaultValue)) {
                throw new OpenDataException("Argument defaultValue's class [\"" + defaultValue.getClass().getName() + "\"] does not match the one defined in openType[\"" + openType.getClassName() + "\"].");
            }
            this.defaultValue = defaultValue;
        }
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Object[] legalValues) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue);
        if (legalValues != null && legalValues.length > 0) {
            if (openType instanceof TabularType || openType.isArray()) {
                throw new OpenDataException("Legal values not supported for TabularType and arrays");
            }
            int i = 0;
            while (i < legalValues.length) {
                if (!openType.isValue(legalValues[i])) {
                    throw new OpenDataException("Element legalValues[" + i + "]=" + legalValues[i] + " is not a valid value for the specified openType [" + openType.toString() + "].");
                }
                ++i;
            }
            HashSet<Object> tmpSet = new HashSet<Object>(legalValues.length + 1, 1.0f);
            int i2 = 0;
            while (i2 < legalValues.length) {
                tmpSet.add(legalValues[i2]);
                ++i2;
            }
            this.legalValues = Collections.unmodifiableSet(tmpSet);
        }
        if (this.hasDefaultValue() && this.hasLegalValues() && !this.legalValues.contains(defaultValue)) {
            throw new OpenDataException("defaultValue is not contained in legalValues");
        }
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Comparable minValue, Comparable maxValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue);
        if (minValue != null) {
            if (!openType.isValue(minValue)) {
                throw new OpenDataException("Argument minValue's class [\"" + minValue.getClass().getName() + "\"] does not match openType's definition [\"" + openType.getClassName() + "\"].");
            }
            this.minValue = minValue;
        }
        if (maxValue != null) {
            if (!openType.isValue(maxValue)) {
                throw new OpenDataException("Argument maxValue's class [\"" + maxValue.getClass().getName() + "\"] does not match openType's definition [\"" + openType.getClassName() + "\"].");
            }
            this.maxValue = maxValue;
        }
        if (this.hasMinValue() && this.hasMaxValue() && minValue.compareTo(maxValue) > 0) {
            throw new OpenDataException("minValue cannot be greater than maxValue.");
        }
        if (this.hasDefaultValue() && this.hasMinValue() && minValue.compareTo((Comparable)defaultValue) > 0) {
            throw new OpenDataException("minValue cannot be greater than defaultValue.");
        }
        if (this.hasDefaultValue() && this.hasMaxValue() && ((Comparable)defaultValue).compareTo(maxValue) > 0) {
            throw new OpenDataException("defaultValue cannot be greater than maxValue.");
        }
    }

    public OpenType getOpenType() {
        return this.openType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Set getLegalValues() {
        return this.legalValues;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    public boolean hasMinValue() {
        return this.minValue != null;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    public boolean isValue(Object obj) {
        boolean result = this.hasDefaultValue() && obj == null ? true : (!this.openType.isValue(obj) ? false : (this.hasLegalValues() && !this.legalValues.contains(obj) ? false : (this.hasMinValue() && this.minValue.compareTo(obj) > 0 ? false : !this.hasMaxValue() || this.maxValue.compareTo(obj) >= 0)));
        return result;
    }

    public boolean equals(Object obj) {
        OpenMBeanAttributeInfo other;
        if (obj == null) {
            return false;
        }
        try {
            other = (OpenMBeanAttributeInfo)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getOpenType().equals(other.getOpenType())) {
            return false;
        }
        if (this.isReadable() != other.isReadable() || this.isWritable() != other.isWritable() || this.isIs() != other.isIs()) {
            return false;
        }
        if (this.hasDefaultValue() ? !this.defaultValue.equals(other.getDefaultValue()) : other.hasDefaultValue()) {
            return false;
        }
        if (this.hasMinValue() ? !this.minValue.equals(other.getMinValue()) : other.hasMinValue()) {
            return false;
        }
        if (this.hasMaxValue() ? !this.maxValue.equals(other.getMaxValue()) : other.hasMaxValue()) {
            return false;
        }
        return !(this.hasLegalValues() ? !this.legalValues.equals(other.getLegalValues()) : other.hasLegalValues());
    }

    public int hashCode() {
        if (this.myHashCode == null) {
            int value = 0;
            value += this.getName().hashCode();
            value += this.openType.hashCode();
            if (this.hasDefaultValue()) {
                value += this.defaultValue.hashCode();
            }
            if (this.hasMinValue()) {
                value += this.minValue.hashCode();
            }
            if (this.hasMaxValue()) {
                value += this.maxValue.hashCode();
            }
            if (this.hasLegalValues()) {
                value += this.legalValues.hashCode();
            }
            this.myHashCode = new Integer(value);
        }
        return this.myHashCode;
    }

    public String toString() {
        if (this.myToString == null) {
            this.myToString = this.getClass().getName() + "(name=" + this.getName() + ",openType=" + this.openType.toString() + ",default=" + String.valueOf(this.defaultValue) + ",min=" + String.valueOf(this.minValue) + ",max=" + String.valueOf(this.maxValue) + ",legals=" + String.valueOf(this.legalValues) + ")";
        }
        return this.myToString;
    }
}

