/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeDataSupport
implements CompositeData,
Serializable {
    static final long serialVersionUID = 8003518976613702244L;
    private SortedMap contents = new TreeMap();
    private CompositeType compositeType;

    public CompositeDataSupport(CompositeType compositeType, String[] itemNames, Object[] itemValues) throws OpenDataException {
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument compositeType cannot be null.");
        }
        Set namesSet = compositeType.keySet();
        CompositeDataSupport.checkForNullElement(itemNames, "itemNames");
        CompositeDataSupport.checkForEmptyString(itemNames, "itemNames");
        if (itemValues == null || itemValues.length == 0) {
            throw new IllegalArgumentException("Argument itemValues[] cannot be null or empty.");
        }
        if (itemNames.length != itemValues.length) {
            throw new IllegalArgumentException("Array arguments itemNames[] and itemValues[] should be of same length (got " + itemNames.length + " and " + itemValues.length + ").");
        }
        if (itemNames.length != namesSet.size()) {
            throw new OpenDataException("The size of array arguments itemNames[] and itemValues[] should be equal to the number of items defined in argument compositeType (found " + itemNames.length + " elements in itemNames[] and itemValues[]," + " expecting " + namesSet.size() + " elements according to compositeType.");
        }
        if (!Arrays.asList(itemNames).containsAll(namesSet)) {
            throw new OpenDataException("Argument itemNames[] does not contain all names defined in the compositeType of this instance.");
        }
        int i = 0;
        while (i < itemValues.length) {
            OpenType itemType = compositeType.getType(itemNames[i]);
            if (itemValues[i] != null && !itemType.isValue(itemValues[i])) {
                throw new OpenDataException("Argument's element itemValues[" + i + "]=\"" + itemValues[i] + "\" is not a valid value for" + "this item (itemName=" + itemNames[i] + ",itemType=" + itemType + ").");
            }
            ++i;
        }
        this.compositeType = compositeType;
        int i2 = 0;
        while (i2 < itemNames.length) {
            this.contents.put(itemNames[i2], itemValues[i2]);
            ++i2;
        }
    }

    public CompositeDataSupport(CompositeType compositeType, Map items) throws OpenDataException {
        this(compositeType, items == null ? null : items.keySet().toArray(new String[items.size()]), items == null ? null : items.values().toArray());
    }

    private static void checkForNullElement(Object[] arg, String argName) {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("Argument " + argName + "[] cannot be null or empty.");
        }
        int i = 0;
        while (i < arg.length) {
            if (arg[i] == null) {
                throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be null.");
            }
            ++i;
        }
    }

    private static void checkForEmptyString(String[] arg, String argName) {
        int i = 0;
        while (i < arg.length) {
            if (arg[i].trim().equals("")) {
                throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be an empty string.");
            }
            ++i;
        }
    }

    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    public Object get(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Argument key cannot be a null or empty String.");
        }
        if (!this.contents.containsKey(key.trim())) {
            throw new InvalidKeyException("Argument key=\"" + key.trim() + "\" is not an existing item name for this CompositeData instance.");
        }
        return this.contents.get(key.trim());
    }

    public Object[] getAll(String[] keys) {
        if (keys == null || keys.length == 0) {
            return new Object[0];
        }
        Object[] results = new Object[keys.length];
        int i = 0;
        while (i < keys.length) {
            results[i] = this.get(keys[i]);
            ++i;
        }
        return results;
    }

    public boolean containsKey(String key) {
        if (key == null || key.trim().equals("")) {
            return false;
        }
        return this.contents.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    public boolean equals(Object obj) {
        CompositeData other;
        if (obj == null) {
            return false;
        }
        try {
            other = (CompositeData)obj;
        }
        catch (ClassCastException e) {
            return false;
        }
        if (!this.getCompositeType().equals(other.getCompositeType())) {
            return false;
        }
        Iterator iter = this.contents.entrySet().iterator();
        while (iter.hasNext()) {
            boolean ok;
            Map.Entry entry = iter.next();
            boolean bl = entry.getValue() == null ? other.get((String)entry.getKey()) == null : (ok = entry.getValue().equals(other.get((String)entry.getKey())));
            if (ok) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        result += this.compositeType.hashCode();
        Iterator iter = this.contents.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            result += entry.getValue() == null ? 0 : entry.getValue().hashCode();
        }
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "(compositeType=" + this.compositeType.toString() + ",contents=" + this.contents.toString() + ")";
    }
}

