/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final String[] types = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private transient String[] derivedGauge = new String[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient int[] status = new int[16];
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "StringMonitor";
    }

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        if (!this.isActive()) {
            this.isActive = true;
            int i = 0;
            while (i < this.elementCount) {
                this.status[i] = 2;
                ++i;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        } else if (this.isTraceOn()) {
            this.trace("start", "the string monitor is already activated");
        }
    }

    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        if (this.isActive()) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the string monitor is already deactivated");
        }
    }

    public synchronized void setGranularityPeriod(long period) throws IllegalArgumentException {
        super.setGranularityPeriod(period);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public String getDerivedGauge(ObjectName object) {
        int index = this.indexOf(object);
        if (index != -1) {
            return this.derivedGauge[index];
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp(ObjectName object) {
        int index = this.indexOf(object);
        if (index != -1) {
            return this.derivedGaugeTimestamp[index];
        }
        return 0L;
    }

    public synchronized String getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    public synchronized void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("The string to compare cannot be null.");
        }
        this.stringToCompare = value;
        int i = 0;
        while (i < this.elementCount) {
            this.status[i] = 2;
            ++i;
        }
    }

    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public synchronized void setNotifyMatch(boolean value) {
        this.notifyMatch = value;
    }

    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public synchronized void setNotifyDiffer(boolean value) {
        this.notifyDiffer = value;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    private void updateDerivedGauge(Object scanString, int index) {
        this.derivedGaugeTimestamp[index] = new Date().getTime();
        this.derivedGauge[index] = (String)scanString;
    }

    private void updateNotifications(int index) {
        if (this.status[index] == 2) {
            if (this.derivedGauge[index].equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.stringToCompare, index);
                }
                this.status[index] = 1;
            } else {
                if (this.notifyDiffer) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.stringToCompare, index);
                }
                this.status[index] = 0;
            }
        } else if (this.status[index] == 0) {
            if (this.derivedGauge[index].equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.stringToCompare, index);
                }
                this.status[index] = 1;
            }
        } else if (this.status[index] == 1 && !this.derivedGauge[index].equals(this.stringToCompare)) {
            if (this.notifyDiffer) {
                this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.stringToCompare, index);
            }
            this.status[index] = 0;
        }
    }

    void notifyAlarmClock(int index) {
        block17: {
            Object scan_string = null;
            String notif_type = null;
            try {
                if (!this.isActive()) break block17;
                if (this.getObservedObject(index) == null || this.getObservedAttribute() == null) {
                    return;
                }
                try {
                    scan_string = this.server.getAttribute(this.getObservedObject(index), this.getObservedAttribute());
                    if (scan_string == null) {
                        return;
                    }
                }
                catch (NullPointerException np_ex) {
                    if ((this.alreadyNotifieds[index] & 8) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(index, 8);
                    throw new MonitorSettingException("The string monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException inf_ex) {
                    if ((this.alreadyNotifieds[index] & 1) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.setAlreadyNotified(index, 1);
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException anf_ex) {
                    if ((this.alreadyNotifieds[index] & 2) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(index, 2);
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mb_ex) {
                    if ((this.alreadyNotifieds[index] & 8) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(index, 8);
                    throw new MonitorSettingException(mb_ex.getMessage());
                }
                catch (ReflectionException ref_ex) {
                    if ((this.alreadyNotifieds[index] & 2) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(index, 2);
                    throw new MonitorSettingException(ref_ex.getMessage());
                }
                if (!(scan_string instanceof String)) {
                    if ((this.alreadyNotifieds[index] & 4) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.setAlreadyNotified(index, 4);
                    throw new MonitorSettingException("The observed attribute type must be a string type.");
                }
                this.resetAllAlreadyNotified(index);
                this.updateDerivedGauge(scan_string, index);
                this.updateNotifications(index);
            }
            catch (MonitorSettingException ms_ex) {
                this.sendNotification(notif_type, this.derivedGaugeTimestamp[index], ms_ex.getMessage(), this.derivedGauge[index], null, index);
                this.status[index] = 2;
            }
        }
    }

    void insertSpecificElementAt(int index) {
        this.insertStringElementAt(this.derivedGauge, "", index);
        this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), index);
        this.insertintElementAt(this.status, 2, index);
    }

    void removeSpecificElementAt(int index) {
        this.removeStringElementAt(this.derivedGauge, index);
        this.removelongElementAt(this.derivedGaugeTimestamp, index);
        this.removeintElementAt(this.status, index);
    }

    private static class StringAlarmClock
    extends TimerTask {
        StringMonitor listener = null;

        public StringAlarmClock(StringMonitor listener) {
            this.listener = listener;
        }

        public void run() {
            if (this.listener.isActive()) {
                int i = 0;
                while (i < this.listener.elementCount) {
                    this.listener.notifyAlarmClock(i);
                    ++i;
                }
            }
        }
    }
}

