/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private List observedObjects = new ArrayList();
    private String observedAttribute = null;
    private long granularityPeriod = 10000L;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server = null;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected String dbgTag = "Monitor";
    transient boolean isActive = false;
    transient long sequenceNumber = 0L;

    boolean isTraceOn() {
        return false;
    }

    void trace(String clz, String func, String info) {
    }

    void trace(String func, String info) {
    }

    boolean isDebugOn() {
        return false;
    }

    void debug(String clz, String func, String info) {
    }

    void debug(String func, String info) {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister", "initialize the reference on the MBean server");
        }
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister", "stop the monitor");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public abstract void start();

    public abstract void stop();

    public synchronized ObjectName getObservedObject() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return (ObjectName)this.observedObjects.get(0);
    }

    public synchronized void setObservedObject(ObjectName object) throws IllegalArgumentException {
        while (!this.observedObjects.isEmpty()) {
            this.removeObservedObject((ObjectName)this.observedObjects.get(0));
        }
        this.addObservedObject(object);
    }

    public void addObservedObject(ObjectName object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("The object to observe cannot be null.");
        }
        if (this.observedObjects.contains(object)) {
            return;
        }
        this.observedObjects.add(object);
        int value = 0;
        value &= 0xFFFFFFFE;
        value &= 0xFFFFFFFD;
        this.insertintElementAt(this.alreadyNotifieds, value &= 0xFFFFFFFB, this.elementCount);
        this.updateDeprecatedAlreadyNotified();
        this.insertSpecificElementAt(this.elementCount);
        ++this.elementCount;
    }

    public void removeObservedObject(ObjectName object) {
        if (this.observedObjects.contains(object)) {
            int index = this.observedObjects.indexOf(object);
            this.observedObjects.remove(object);
            this.removeintElementAt(this.alreadyNotifieds, index);
            this.updateDeprecatedAlreadyNotified();
            this.removeSpecificElementAt(index);
            --this.elementCount;
        }
    }

    public boolean containsObservedObject(ObjectName object) {
        return this.observedObjects.contains(object);
    }

    public ObjectName[] getObservedObjects() {
        ObjectName[] objects = new ObjectName[this.elementCount];
        int i = 0;
        while (i < this.elementCount) {
            objects[i] = (ObjectName)this.observedObjects.get(i);
            ++i;
        }
        return objects;
    }

    public synchronized String getObservedAttribute() {
        return this.observedAttribute;
    }

    public synchronized void setObservedAttribute(String attribute) throws IllegalArgumentException {
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute to observe cannot be null.");
        }
        this.observedAttribute = attribute;
        int i = 0;
        while (i < this.elementCount) {
            this.resetAlreadyNotified(i, 6);
            ++i;
        }
    }

    public synchronized long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public synchronized void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("The granularity period must be greater than zero.");
        }
        this.granularityPeriod = period;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    ObjectName getObservedObject(int index) throws ArrayIndexOutOfBoundsException {
        return (ObjectName)this.observedObjects.get(index);
    }

    void updateDeprecatedAlreadyNotified() {
        this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
    }

    void setAlreadyNotified(int index, int mask) {
        int n = index;
        this.alreadyNotifieds[n] = this.alreadyNotifieds[n] | mask;
        if (index == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    void resetAlreadyNotified(int index, int mask) {
        int n = index;
        this.alreadyNotifieds[n] = this.alreadyNotifieds[n] & ~mask;
        if (index == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    void resetAllAlreadyNotified(int index) {
        this.alreadyNotifieds[index] = 0;
        if (index == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    void insertintElementAt(int[] array, int value, int index) {
        this.ensureintCapacity(array, this.elementCount + 1);
        System.arraycopy(array, index, array, index + 1, this.elementCount - index);
        array[index] = value;
    }

    void insertlongElementAt(long[] array, long value, int index) {
        this.ensurelongCapacity(array, this.elementCount + 1);
        System.arraycopy(array, index, array, index + 1, this.elementCount - index);
        array[index] = value;
    }

    void insertbooleanElementAt(boolean[] array, boolean value, int index) {
        this.ensurebooleanCapacity(array, this.elementCount + 1);
        System.arraycopy(array, index, array, index + 1, this.elementCount - index);
        array[index] = value;
    }

    void insertNumberElementAt(Number[] array, Number value, int index) {
        this.ensureNumberCapacity(array, this.elementCount + 1);
        System.arraycopy(array, index, array, index + 1, this.elementCount - index);
        array[index] = value;
    }

    void insertStringElementAt(String[] array, String value, int index) {
        this.ensureStringCapacity(array, this.elementCount + 1);
        System.arraycopy(array, index, array, index + 1, this.elementCount - index);
        array[index] = value;
    }

    void removeintElementAt(int[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    void removelongElementAt(long[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    void removebooleanElementAt(boolean[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    void removeNumberElementAt(Number[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    void removeStringElementAt(String[] array, int index) {
        if (index < 0 || index >= this.elementCount) {
            return;
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(array, index + 1, array, index, j);
        }
    }

    void ensureintCapacity(int[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            int[] oldArray = array;
            int newCapacity = oldCapacity + 16;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            array = new int[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, this.elementCount);
        }
    }

    void ensurelongCapacity(long[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            long[] oldArray = array;
            int newCapacity = oldCapacity + 16;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            array = new long[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, this.elementCount);
        }
    }

    void ensurebooleanCapacity(boolean[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            boolean[] oldArray = array;
            int newCapacity = oldCapacity + 16;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            array = new boolean[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, this.elementCount);
        }
    }

    void ensureNumberCapacity(Number[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            Number[] oldArray = array;
            int newCapacity = oldCapacity + 16;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            array = new Number[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, this.elementCount);
        }
    }

    void ensureStringCapacity(String[] array, int minCapacity) {
        int oldCapacity = array.length;
        if (minCapacity > oldCapacity) {
            String[] oldArray = array;
            int newCapacity = oldCapacity + 16;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            array = new String[newCapacity];
            System.arraycopy(oldArray, 0, array, 0, this.elementCount);
        }
    }

    int indexOf(ObjectName object) {
        return this.observedObjects.indexOf(object);
    }

    abstract void insertSpecificElementAt(int var1);

    abstract void removeSpecificElementAt(int var1);

    void sendNotification(String type, long timeStamp, String msg, Object derGauge, Object trigger, int index) {
        MonitorNotification notif = null;
        Monitor monitor = this;
        synchronized (monitor) {
            ++this.sequenceNumber;
            if (this.isTraceOn()) {
                this.trace("sendNotification", "send notification:\n\tNotification observed object = " + this.getObservedObject(index) + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + derGauge);
            }
            notif = new MonitorNotification(type, this, this.sequenceNumber, timeStamp, msg, this.getObservedObject(index), this.observedAttribute, derGauge, trigger);
        }
        this.sendNotification(notif);
    }
}

