/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    private Number highThreshold = new Integer(0);
    private Number lowThreshold = new Integer(0);
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanGauge = new Number[16];
    private transient int[] status = new int[16];
    private transient int[] type = new int[16];
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "GaugeMonitor";
    }

    public GaugeMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the gauge monitor");
        }
        if (!this.isActive()) {
            this.isActive = true;
            int i = 0;
            while (i < this.elementCount) {
                this.status[i] = 2;
                this.previousScanGauge[i] = null;
                ++i;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        } else if (this.isTraceOn()) {
            this.trace("start", "the gauge monitor is already activated");
        }
    }

    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the gauge monitor");
        }
        if (this.isActive()) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the counter monitor is already deactivated");
        }
    }

    public synchronized void setGranularityPeriod(long period) throws IllegalArgumentException {
        super.setGranularityPeriod(period);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new GaugeAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public Number getDerivedGauge(ObjectName object) {
        int index = this.indexOf(object);
        if (index != -1) {
            return this.derivedGauge[index];
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp(ObjectName object) {
        int index = this.indexOf(object);
        if (index != -1) {
            return this.derivedGaugeTimestamp[index];
        }
        return 0L;
    }

    public synchronized Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized Number getHighThreshold() {
        return this.highThreshold;
    }

    public synchronized Number getLowThreshold() {
        return this.lowThreshold;
    }

    public synchronized void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null) {
            throw new IllegalArgumentException("The threshold values cannot be null.");
        }
        if (highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException("The high and the low thresholds must be of the same type.");
        }
        if (this.isFirstStrictlyGreaterThanLast(lowValue, highValue, highValue.getClass().getName())) {
            throw new IllegalArgumentException("The threshold high value must be greater than or equal to threshold low value.");
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
        int i = 0;
        while (i < this.elementCount) {
            this.resetAlreadyNotified(i, 16);
            this.status[i] = 2;
            ++i;
        }
    }

    public synchronized boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public synchronized void setNotifyHigh(boolean value) {
        this.notifyHigh = value;
    }

    public synchronized boolean getNotifyLow() {
        return this.notifyLow;
    }

    public synchronized void setNotifyLow(boolean value) {
        this.notifyLow = value;
    }

    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public synchronized void setDifferenceMode(boolean value) {
        this.differenceMode = value;
        int i = 0;
        while (i < this.elementCount) {
            this.status[i] = 2;
            this.previousScanGauge[i] = null;
            ++i;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED};
        MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
        return notifsInfo;
    }

    private boolean updateDerivedGauge(Object scanGauge, int index) {
        boolean is_derived_gauge_valid;
        this.derivedGaugeTimestamp[index] = System.currentTimeMillis();
        if (this.differenceMode) {
            if (this.previousScanGauge[index] != null) {
                this.setDerivedGaugeWithDifference((Number)scanGauge, index);
                is_derived_gauge_valid = true;
            } else {
                is_derived_gauge_valid = false;
            }
            this.previousScanGauge[index] = (Number)scanGauge;
        } else {
            this.derivedGauge[index] = (Number)scanGauge;
            is_derived_gauge_valid = true;
        }
        return is_derived_gauge_valid;
    }

    private void updateNotifications(int index) {
        if (this.status[index] == 2) {
            if (this.isFirstGreaterThanLast(this.derivedGauge[index], this.highThreshold, this.type[index])) {
                if (this.notifyHigh) {
                    this.sendNotification(MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.highThreshold, index);
                }
                this.status[index] = 1;
            }
            if (this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[index], this.type[index])) {
                if (this.notifyLow) {
                    this.sendNotification(MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.lowThreshold, index);
                }
                this.status[index] = 0;
            }
        } else if (this.status[index] == 0) {
            if (this.isFirstGreaterThanLast(this.derivedGauge[index], this.highThreshold, this.type[index])) {
                if (this.notifyHigh) {
                    this.sendNotification(MonitorNotification.THRESHOLD_HIGH_VALUE_EXCEEDED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.highThreshold, index);
                }
                this.status[index] = 1;
            }
        } else if (this.status[index] == 1 && this.isFirstGreaterThanLast(this.lowThreshold, this.derivedGauge[index], this.type[index])) {
            if (this.notifyLow) {
                this.sendNotification(MonitorNotification.THRESHOLD_LOW_VALUE_EXCEEDED, this.derivedGaugeTimestamp[index], "", this.derivedGauge[index], this.lowThreshold, index);
            }
            this.status[index] = 0;
        }
    }

    private boolean isThresholdTypeValid(int index) {
        boolean is_same_type = false;
        switch (this.type[index]) {
            case 0: {
                if (!(this.highThreshold instanceof Integer) || !(this.lowThreshold instanceof Integer)) break;
                is_same_type = true;
                break;
            }
            case 1: {
                if (!(this.highThreshold instanceof Byte) || !(this.lowThreshold instanceof Byte)) break;
                is_same_type = true;
                break;
            }
            case 2: {
                if (!(this.highThreshold instanceof Short) || !(this.lowThreshold instanceof Short)) break;
                is_same_type = true;
                break;
            }
            case 3: {
                if (!(this.highThreshold instanceof Long) || !(this.lowThreshold instanceof Long)) break;
                is_same_type = true;
                break;
            }
            case 4: {
                if (!(this.highThreshold instanceof Float) || !(this.lowThreshold instanceof Float)) break;
                is_same_type = true;
                break;
            }
            case 5: {
                if (!(this.highThreshold instanceof Double) || !(this.lowThreshold instanceof Double)) break;
                is_same_type = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isThresholdTypeValid", "the threshold type is invalid");
            }
        }
        return is_same_type;
    }

    private void setDerivedGaugeWithDifference(Number scanGauge, int index) {
        switch (this.type[index]) {
            case 0: {
                this.derivedGauge[index] = new Integer((Integer)scanGauge - (Integer)this.previousScanGauge[index]);
                break;
            }
            case 1: {
                this.derivedGauge[index] = new Byte((byte)((Byte)scanGauge - (Byte)this.previousScanGauge[index]));
                break;
            }
            case 2: {
                this.derivedGauge[index] = new Short((short)((Short)scanGauge - (Short)this.previousScanGauge[index]));
                break;
            }
            case 3: {
                this.derivedGauge[index] = new Long((Long)scanGauge - (Long)this.previousScanGauge[index]);
                break;
            }
            case 4: {
                this.derivedGauge[index] = new Float(((Float)scanGauge).floatValue() - ((Float)this.previousScanGauge[index]).floatValue());
                break;
            }
            case 5: {
                this.derivedGauge[index] = new Double((Double)scanGauge - (Double)this.previousScanGauge[index]);
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    private boolean isFirstGreaterThanLast(Number greater, Number less, int type) {
        boolean is_greater = false;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (greater.longValue() < less.longValue()) break;
                is_greater = true;
                break;
            }
            case 4: 
            case 5: {
                if (!(greater.doubleValue() >= less.doubleValue())) break;
                is_greater = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isFirstGreaterThanLast", "the threshold type is invalid");
            }
        }
        return is_greater;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number greater, Number less, String className) {
        boolean is_greater = false;
        if (className.equals("java.lang.Integer") || className.equals("java.lang.Byte") || className.equals("java.lang.Short") || className.equals("java.lang.Long")) {
            if (greater.longValue() > less.longValue()) {
                is_greater = true;
            }
        } else if (className.equals("java.lang.Float") || className.equals("java.lang.Double")) {
            if (greater.doubleValue() > less.doubleValue()) {
                is_greater = true;
            }
        } else if (this.isDebugOn()) {
            this.debug("isFirstStrictlyGreaterThanLast", "the threshold type is invalid");
        }
        return is_greater;
    }

    void notifyAlarmClock(int index) {
        block31: {
            Object scan_gauge = null;
            String notif_type = null;
            try {
                if (!this.isActive()) break block31;
                if (this.getObservedObject(index) == null || this.getObservedAttribute() == null) {
                    return;
                }
                try {
                    scan_gauge = this.server.getAttribute(this.getObservedObject(index), this.getObservedAttribute());
                    if (scan_gauge == null) {
                        return;
                    }
                }
                catch (NullPointerException np_ex) {
                    if ((this.alreadyNotifieds[index] & 8) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(index, 8);
                    throw new MonitorSettingException("The gauge monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException inf_ex) {
                    if ((this.alreadyNotifieds[index] & 1) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.setAlreadyNotified(index, 1);
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException anf_ex) {
                    if ((this.alreadyNotifieds[index] & 2) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(index, 2);
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mb_ex) {
                    if ((this.alreadyNotifieds[index] & 8) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(index, 8);
                    throw new MonitorSettingException(mb_ex.getMessage());
                }
                catch (ReflectionException ref_ex) {
                    if ((this.alreadyNotifieds[index] & 2) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(index, 2);
                    throw new MonitorSettingException(ref_ex.getMessage());
                }
                if (scan_gauge instanceof Integer) {
                    this.type[index] = 0;
                } else if (scan_gauge instanceof Byte) {
                    this.type[index] = 1;
                } else if (scan_gauge instanceof Short) {
                    this.type[index] = 2;
                } else if (scan_gauge instanceof Long) {
                    this.type[index] = 3;
                } else if (scan_gauge instanceof Float) {
                    this.type[index] = 4;
                } else if (scan_gauge instanceof Double) {
                    this.type[index] = 5;
                } else {
                    if ((this.alreadyNotifieds[index] & 4) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.setAlreadyNotified(index, 4);
                    throw new MonitorSettingException("The observed attribute type must be an integer type or a floating-point type.");
                }
                if (!this.isThresholdTypeValid(index)) {
                    if ((this.alreadyNotifieds[index] & 0x10) != 0) {
                        return;
                    }
                    notif_type = MonitorNotification.THRESHOLD_ERROR;
                    this.setAlreadyNotified(index, 16);
                    throw new MonitorSettingException("The threshold high and threshold low must be of the same type as the gauge.");
                }
                this.resetAllAlreadyNotified(index);
                boolean is_derived_gauge_valid = this.updateDerivedGauge(scan_gauge, index);
                if (is_derived_gauge_valid) {
                    this.updateNotifications(index);
                }
            }
            catch (MonitorSettingException ms_ex) {
                this.sendNotification(notif_type, this.derivedGaugeTimestamp[index], ms_ex.getMessage(), this.derivedGauge[index], null, index);
                this.status[index] = 2;
                this.previousScanGauge[index] = null;
            }
        }
    }

    void insertSpecificElementAt(int index) {
        Integer nb = new Integer(0);
        this.insertNumberElementAt(this.derivedGauge, nb, index);
        this.insertNumberElementAt(this.previousScanGauge, null, index);
        this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), index);
        this.insertintElementAt(this.status, 2, index);
        this.insertintElementAt(this.type, 0, index);
    }

    void removeSpecificElementAt(int index) {
        this.removeNumberElementAt(this.derivedGauge, index);
        this.removeNumberElementAt(this.previousScanGauge, index);
        this.removelongElementAt(this.derivedGaugeTimestamp, index);
        this.removeintElementAt(this.status, index);
        this.removeintElementAt(this.type, index);
    }

    private static class GaugeAlarmClock
    extends TimerTask {
        GaugeMonitor listener = null;

        public GaugeAlarmClock(GaugeMonitor listener) {
            this.listener = listener;
        }

        public void run() {
            if (this.listener.isActive()) {
                int i = 0;
                while (i < this.listener.elementCount) {
                    this.listener.notifyAlarmClock(i);
                    ++i;
                }
            }
        }
    }
}

