/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sap.pj.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;

public class DescriptorSupport
implements Descriptor {
    private static final long oldSerialVersionUID = 8071560848919417985L;
    private static final long newSerialVersionUID = -6292969195866300415L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", class$java$util$HashMap == null ? (class$java$util$HashMap = DescriptorSupport.class$("java.util.HashMap")) : class$java$util$HashMap), new ObjectStreamField("currClass", class$java$lang$String == null ? (class$java$lang$String = DescriptorSupport.class$("java.lang.String")) : class$java$lang$String)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("descriptor", class$java$util$HashMap == null ? (class$java$util$HashMap = DescriptorSupport.class$("java.util.HashMap")) : class$java$util$HashMap)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    HashMap descriptor;
    private static final int DEFAULT_SIZE = 20;
    private static String currClass;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$String;

    public DescriptorSupport() {
        this.descriptor = new HashMap(20);
    }

    public DescriptorSupport(int initNumFields) throws MBeanException, RuntimeOperationsException {
        if (initNumFields <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor field limit is invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(initNumFields);
    }

    public DescriptorSupport(DescriptorSupport inDescr) {
        this.descriptor = inDescr == null || inDescr.descriptor == null ? new HashMap(20) : new HashMap(inDescr.descriptor);
    }

    public DescriptorSupport(String inStr) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (inStr == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("String in parameter is null"), "Exception occured trying to construct a descriptor");
        }
        if (inStr.toLowerCase().indexOf("<descriptor>") != 0 || inStr.toLowerCase().indexOf("</descriptor>") + 13 != inStr.length()) {
            throw new XMLParseException("No <descriptor> , </descriptor> pair");
        }
        this.descriptor = new HashMap(20);
        StringTokenizer st = new StringTokenizer(inStr, "<> \t\n\r\f");
        boolean inFld = false;
        boolean inDesc = false;
        String fieldName = null;
        String fieldValue = null;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equalsIgnoreCase("FIELD")) {
                inFld = true;
                continue;
            }
            if (tok.equalsIgnoreCase("/FIELD")) {
                if (fieldName != null && fieldValue != null) {
                    fieldName = fieldName.substring(fieldName.indexOf(34) + 1, fieldName.lastIndexOf(34));
                    fieldValue = fieldValue.substring(fieldValue.indexOf(34) + 1, fieldValue.lastIndexOf(34));
                    this.setField(fieldName.toLowerCase(), fieldValue);
                }
                fieldName = null;
                fieldValue = null;
                inFld = false;
                continue;
            }
            if (tok.equalsIgnoreCase("DESCRIPTOR")) {
                inDesc = true;
                continue;
            }
            if (tok.equalsIgnoreCase("/DESCRIPTOR")) {
                inDesc = false;
                fieldName = null;
                fieldValue = null;
                inFld = false;
                continue;
            }
            if (!inFld || !inDesc) continue;
            int eq_separator = tok.indexOf("=");
            if (eq_separator > 0) {
                String kwPart = tok.substring(0, eq_separator);
                String valPart = tok.substring(eq_separator + 1);
                if (kwPart.equalsIgnoreCase("NAME")) {
                    fieldName = valPart;
                    continue;
                }
                if (kwPart.equalsIgnoreCase("VALUE")) {
                    fieldValue = valPart;
                    continue;
                }
                throw new XMLParseException("expected a field value, received '" + tok + "'");
            }
            throw new XMLParseException("expected keyword=value, received '" + tok + "'");
        }
    }

    public DescriptorSupport(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        if (fieldNames == null || fieldValues == null || fieldNames.length != fieldValues.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames or FieldValues are null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(fieldNames.length);
        int i = 0;
        while (i < fieldNames.length) {
            this.setField(fieldNames[i], fieldValues[i]);
            ++i;
        }
    }

    public DescriptorSupport(String[] fields) {
        if (fields == null || fields.length == 0) {
            this.descriptor = new HashMap(20);
            return;
        }
        this.descriptor = new HashMap(fields.length);
        int i = 0;
        while (i < fields.length) {
            if (fields[i] != null && !fields[i].equals("")) {
                int eq_separator = fields[i].indexOf("=");
                if (eq_separator < 0) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
                }
                String fieldName = fields[i].substring(0, eq_separator);
                String fieldValue = null;
                if (eq_separator < fields[i].length()) {
                    fieldValue = fields[i].substring(eq_separator + 1);
                }
                if (fieldName == null || fieldName.equals("")) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no fieldName"), "Exception occured trying to construct a descriptor");
                }
                this.setField(fieldName, fieldValue);
            }
            ++i;
        }
    }

    public Object getFieldValue(String inFieldName) throws RuntimeOperationsException {
        if (inFieldName == null || inFieldName.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname requested is null"), "Exception occured trying to get a field from a descriptor");
        }
        Object retValue = this.descriptor.get(inFieldName.toLowerCase());
        return retValue;
    }

    public void setField(String inFieldName, Object fieldValue) throws RuntimeOperationsException {
        if (inFieldName == null || inFieldName.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname to be set is null or empty"), "Exception occured trying to set a field from a descriptor");
        }
        String fieldName = inFieldName.toLowerCase();
        if (!this.validateField(fieldName, fieldValue)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Field value invalid: " + fieldName + "=" + fieldValue), "Field " + fieldName + "=" + fieldValue + " is invalid. Exception occured trying to set a field from a descriptor");
        }
        this.descriptor.put(fieldName, fieldValue);
    }

    public String[] getFields() {
        if (this.descriptor == null) {
            return new String[0];
        }
        int numberOfEntries = this.descriptor.size();
        if (numberOfEntries == 0) {
            return new String[0];
        }
        String[] responseFields = new String[numberOfEntries];
        Set returnedSet = this.descriptor.entrySet();
        if (returnedSet == null) {
            return new String[0];
        }
        int i = 0;
        Object currValue = null;
        Map.Entry currElement = null;
        Iterator iter = returnedSet.iterator();
        while (iter.hasNext()) {
            currElement = iter.next();
            if (currElement != null) {
                currValue = currElement.getValue();
                responseFields[i] = currValue == null ? currElement.getKey() + "=" : (currValue instanceof String ? currElement.getKey() + "=" + currValue.toString() : currElement.getKey() + "=(" + currValue.toString() + ")");
            }
            ++i;
        }
        return responseFields;
    }

    public String[] getFieldNames() {
        if (this.descriptor == null) {
            return new String[0];
        }
        int numberOfEntries = this.descriptor.size();
        String[] responseFields = new String[numberOfEntries];
        Set returnedSet = this.descriptor.entrySet();
        if (returnedSet == null || numberOfEntries == 0) {
            return new String[0];
        }
        int i = 0;
        Iterator iter = returnedSet.iterator();
        while (iter.hasNext()) {
            Map.Entry currElement = iter.next();
            if (currElement != null && currElement.getKey() != null) {
                responseFields[i] = currElement.getKey().toString();
            }
            ++i;
        }
        return responseFields;
    }

    public Object[] getFieldValues(String[] fieldNames) {
        if (this.descriptor == null || fieldNames != null && fieldNames.length == 0) {
            return new Object[0];
        }
        int numberOfEntries = this.descriptor.size();
        Set returnedSet = this.descriptor.entrySet();
        if (returnedSet == null || numberOfEntries == 0) {
            return new Object[0];
        }
        Object[] responseFields = fieldNames != null ? new Object[fieldNames.length] : new Object[numberOfEntries];
        int i = 0;
        if (fieldNames == null) {
            Iterator iter = returnedSet.iterator();
            while (iter.hasNext()) {
                Map.Entry currElement = iter.next();
                responseFields[i] = currElement == null || currElement.getKey() == null ? null : currElement.getValue();
                ++i;
            }
        } else {
            i = 0;
            while (i < fieldNames.length) {
                responseFields[i] = fieldNames[i] == null || fieldNames[i].equals("") ? null : this.getFieldValue(fieldNames[i]);
                ++i;
            }
        }
        return responseFields;
    }

    public void setFields(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        if (fieldNames == null || fieldValues == null || fieldNames.length != fieldValues.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames and FieldValues are null or invalid"), "Exception occured trying to set object fields a descriptor");
        }
        int i = 0;
        while (i < fieldNames.length) {
            if (fieldNames[i] == null || fieldNames[i].equals("")) {
                throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames is null or invalid"), "Exception occured trying to set object fields a descriptor");
            }
            this.setField(fieldNames[i], fieldValues[i]);
            ++i;
        }
    }

    public Object clone() throws RuntimeOperationsException {
        return new DescriptorSupport(this);
    }

    public void removeField(String fieldName) {
        if (fieldName == null || fieldName.equals("")) {
            return;
        }
        Set returnedSet = this.descriptor.keySet();
        Iterator iter = returnedSet.iterator();
        while (iter.hasNext()) {
            String currKey = (String)iter.next();
            if (!currKey.equalsIgnoreCase(fieldName)) continue;
            this.descriptor.remove(currKey);
            break;
        }
    }

    public boolean isValid() throws RuntimeOperationsException {
        Set returnedSet = this.descriptor.entrySet();
        if (returnedSet == null) {
            return false;
        }
        String thisName = (String)this.getFieldValue("name");
        String thisDescType = (String)this.getFieldValue("descriptorType");
        if (thisName == null || thisDescType == null || thisName.equals("") || thisDescType.equals("")) {
            return false;
        }
        Iterator iter = returnedSet.iterator();
        while (iter.hasNext()) {
            Map.Entry currElement = iter.next();
            if (currElement != null && currElement.getValue() != null && !this.validateField(currElement.getKey().toString(), currElement.getValue().toString())) continue;
        }
        return true;
    }

    private boolean validateField(String fldName, Object fldValue) {
        boolean nameOrDescriptorType;
        if (fldName == null || fldName.equals("")) {
            return false;
        }
        String SfldValue = "";
        boolean isAString = false;
        if (fldValue != null && fldValue instanceof String) {
            SfldValue = (String)fldValue;
            isAString = true;
        }
        boolean bl = nameOrDescriptorType = fldName.equalsIgnoreCase("Name") || fldName.equalsIgnoreCase("DescriptorType");
        if (nameOrDescriptorType || fldName.equalsIgnoreCase("SetMethod") || fldName.equalsIgnoreCase("GetMethod") || fldName.equalsIgnoreCase("Role") || fldName.equalsIgnoreCase("Class")) {
            if (fldValue == null || !isAString) {
                return false;
            }
            return !nameOrDescriptorType || !SfldValue.equals("");
        }
        if (fldName.equalsIgnoreCase("visibility")) {
            long v;
            if (fldValue != null && isAString) {
                v = this.toNumeric(SfldValue);
            } else if (fldValue != null && fldValue instanceof Integer) {
                v = ((Integer)fldValue).intValue();
            } else {
                return false;
            }
            return v >= 1L && v <= 4L;
        }
        if (fldName.equalsIgnoreCase("severity")) {
            long v;
            if (fldValue != null && isAString) {
                v = this.toNumeric(SfldValue);
            } else if (fldValue != null && fldValue instanceof Integer) {
                v = ((Integer)fldValue).intValue();
            } else {
                return false;
            }
            return v >= 0L && v <= 6L;
        }
        if (fldName.equalsIgnoreCase("PersistPolicy")) {
            return fldValue != null && isAString && (SfldValue.equalsIgnoreCase("OnUpdate") || SfldValue.equalsIgnoreCase("OnTimer") || SfldValue.equalsIgnoreCase("NoMoreOftenThan") || SfldValue.equalsIgnoreCase("Always") || SfldValue.equalsIgnoreCase("Never"));
        }
        if (fldName.equalsIgnoreCase("PersistPeriod") || fldName.equalsIgnoreCase("CurrencyTimeLimit") || fldName.equalsIgnoreCase("LastUpdatedTimeStamp") || fldName.equalsIgnoreCase("LastReturnedTimeStamp")) {
            long v;
            if (fldValue != null && isAString) {
                v = this.toNumeric(SfldValue);
            } else if (fldValue != null && fldValue instanceof Integer) {
                v = ((Integer)fldValue).intValue();
            } else {
                return false;
            }
            return v >= -1L;
        }
        if (fldName.equalsIgnoreCase("log")) {
            return fldValue instanceof Boolean || isAString && (SfldValue.equalsIgnoreCase("T") || SfldValue.equalsIgnoreCase("true") || SfldValue.equalsIgnoreCase("F") || SfldValue.equalsIgnoreCase("false"));
        }
        return true;
    }

    public String toXMLString() {
        String respStr = "<Descriptor>";
        Set returnedSet = this.descriptor.entrySet();
        if (returnedSet == null) {
            respStr = respStr + "</Descriptor>";
            return respStr;
        }
        int i = 0;
        Iterator iter = returnedSet.iterator();
        while (iter.hasNext()) {
            Map.Entry currElement = iter.next();
            if (currElement != null) {
                Object curValue = currElement.getValue();
                respStr = curValue == null ? respStr + "<field name=\"" + currElement.getKey().toString() + "\" value=\"null\"></field>" : (curValue instanceof String ? respStr + "<field name=\"" + currElement.getKey().toString() + "\" value=\"" + curValue + "\"></field>" : respStr + "<field name=\"" + currElement.getKey().toString() + "\" value=\"" + "(" + curValue.toString() + ")" + "\"></field>");
            }
            ++i;
        }
        respStr = respStr + "</Descriptor>";
        return respStr;
    }

    public String toString() {
        String respStr = "";
        String[] fields = this.getFields();
        if (fields == null || fields.length == 0) {
            return respStr;
        }
        int i = 0;
        while (i < fields.length) {
            respStr = i == fields.length - 1 ? respStr.concat(fields[i]) : respStr.concat(fields[i] + ", ");
            ++i;
        }
        return respStr;
    }

    private long toNumeric(String inStr) {
        long result = -2L;
        try {
            result = Long.parseLong(inStr);
        }
        catch (Exception e) {
            return -2L;
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("descriptor", this.descriptor);
            fields.put("currClass", currClass);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = (String)AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 8071560848919417985L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -6292969195866300415L;
        }
        currClass = "DescriptorSupport";
    }
}

