/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import javax.management.loading.MLetObjectInputStream;
import javax.management.loading.MLetParser;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private static final long serialVersionUID = 3636148327800330130L;
    private MBeanServer server = null;
    private Vector mletList = new Vector();
    private String libraryDirectory;
    private ObjectName mletObjectName = null;
    private URL[] myUrls = null;
    private static final String dbgTag = "MLet";
    private transient ClassLoaderRepository currentClr;
    private transient boolean delegateToCLR;
    private Hashtable primitiveClasses = new Hashtable(8);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] urls) {
        this(urls, true);
    }

    public MLet(URL[] urls, ClassLoader parent) {
        this(urls, parent, true);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(urls, parent, factory, true);
    }

    public MLet(URL[] urls, boolean delegateToCLR) {
        super(urls);
        this.primitiveClasses.put(Boolean.TYPE.toString(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = MLet.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.primitiveClasses.put(Character.TYPE.toString(), class$java$lang$Character == null ? (class$java$lang$Character = MLet.class$("java.lang.Character")) : class$java$lang$Character);
        this.primitiveClasses.put(Byte.TYPE.toString(), class$java$lang$Byte == null ? (class$java$lang$Byte = MLet.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.primitiveClasses.put(Short.TYPE.toString(), class$java$lang$Short == null ? (class$java$lang$Short = MLet.class$("java.lang.Short")) : class$java$lang$Short);
        this.primitiveClasses.put(Integer.TYPE.toString(), class$java$lang$Integer == null ? (class$java$lang$Integer = MLet.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.primitiveClasses.put(Long.TYPE.toString(), class$java$lang$Long == null ? (class$java$lang$Long = MLet.class$("java.lang.Long")) : class$java$lang$Long);
        this.primitiveClasses.put(Float.TYPE.toString(), class$java$lang$Float == null ? (class$java$lang$Float = MLet.class$("java.lang.Float")) : class$java$lang$Float);
        this.primitiveClasses.put(Double.TYPE.toString(), class$java$lang$Double == null ? (class$java$lang$Double = MLet.class$("java.lang.Double")) : class$java$lang$Double);
        this.init(delegateToCLR);
    }

    public MLet(URL[] urls, ClassLoader parent, boolean delegateToCLR) {
        super(urls, parent);
        this.primitiveClasses.put(Boolean.TYPE.toString(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = MLet.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.primitiveClasses.put(Character.TYPE.toString(), class$java$lang$Character == null ? (class$java$lang$Character = MLet.class$("java.lang.Character")) : class$java$lang$Character);
        this.primitiveClasses.put(Byte.TYPE.toString(), class$java$lang$Byte == null ? (class$java$lang$Byte = MLet.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.primitiveClasses.put(Short.TYPE.toString(), class$java$lang$Short == null ? (class$java$lang$Short = MLet.class$("java.lang.Short")) : class$java$lang$Short);
        this.primitiveClasses.put(Integer.TYPE.toString(), class$java$lang$Integer == null ? (class$java$lang$Integer = MLet.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.primitiveClasses.put(Long.TYPE.toString(), class$java$lang$Long == null ? (class$java$lang$Long = MLet.class$("java.lang.Long")) : class$java$lang$Long);
        this.primitiveClasses.put(Float.TYPE.toString(), class$java$lang$Float == null ? (class$java$lang$Float = MLet.class$("java.lang.Float")) : class$java$lang$Float);
        this.primitiveClasses.put(Double.TYPE.toString(), class$java$lang$Double == null ? (class$java$lang$Double = MLet.class$("java.lang.Double")) : class$java$lang$Double);
        this.init(delegateToCLR);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory, boolean delegateToCLR) {
        super(urls, parent, factory);
        this.primitiveClasses.put(Boolean.TYPE.toString(), class$java$lang$Boolean == null ? (class$java$lang$Boolean = MLet.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.primitiveClasses.put(Character.TYPE.toString(), class$java$lang$Character == null ? (class$java$lang$Character = MLet.class$("java.lang.Character")) : class$java$lang$Character);
        this.primitiveClasses.put(Byte.TYPE.toString(), class$java$lang$Byte == null ? (class$java$lang$Byte = MLet.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.primitiveClasses.put(Short.TYPE.toString(), class$java$lang$Short == null ? (class$java$lang$Short = MLet.class$("java.lang.Short")) : class$java$lang$Short);
        this.primitiveClasses.put(Integer.TYPE.toString(), class$java$lang$Integer == null ? (class$java$lang$Integer = MLet.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.primitiveClasses.put(Long.TYPE.toString(), class$java$lang$Long == null ? (class$java$lang$Long = MLet.class$("java.lang.Long")) : class$java$lang$Long);
        this.primitiveClasses.put(Float.TYPE.toString(), class$java$lang$Float == null ? (class$java$lang$Float = MLet.class$("java.lang.Float")) : class$java$lang$Float);
        this.primitiveClasses.put(Double.TYPE.toString(), class$java$lang$Double == null ? (class$java$lang$Double = MLet.class$("java.lang.Double")) : class$java$lang$Double);
        this.init(delegateToCLR);
    }

    private void init(boolean delegateToCLR) {
        this.delegateToCLR = delegateToCLR;
        try {
            this.libraryDirectory = System.getProperty("jmx.mlet.library.dir");
            this.libraryDirectory = this.getTmpDir();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void addURL(URL url) {
        if (!Arrays.asList(this.getURLs()).contains(url)) {
            super.addURL(url);
        }
    }

    public void addURL(String url) throws ServiceNotFoundException {
        try {
            URL ur = new URL(url);
            if (!Arrays.asList(this.getURLs()).contains(ur)) {
                super.addURL(ur);
            }
        }
        catch (MalformedURLException e) {
            throw new ServiceNotFoundException("The specified URL is malformed");
        }
    }

    public URL[] getURLs() {
        return super.getURLs();
    }

    public Set getMBeansFromURL(URL url) throws ServiceNotFoundException {
        if (url == null) {
            throw new ServiceNotFoundException("The specified URL is null");
        }
        return this.getMBeansFromURL(url.toString());
    }

    public Set getMBeansFromURL(String url) throws ServiceNotFoundException {
        String mth = "getMBeansFromURL";
        if (this.server == null) {
            throw new IllegalStateException("This MLet MBean is not registered with an MBeanServer.");
        }
        if (url == null) {
            throw new ServiceNotFoundException("The specified URL is null");
        }
        url = url.replace(File.separatorChar, '/');
        MLetParser parser = new MLetParser();
        this.mletList = parser.parseURL(url);
        if (this.mletList == null) {
            throw new ServiceNotFoundException("Problems while parsing URL " + url);
        }
        if (this.mletList.size() == 0) {
            throw new ServiceNotFoundException("File " + url + " not found or MLET tag not defined in file");
        }
        HashSet<Serializable> mbeans = new HashSet<Serializable>();
        Enumeration e = this.mletList.elements();
        while (e.hasMoreElements()) {
            MLetContent elmt = (MLetContent)e.nextElement();
            String code = elmt.getCode();
            if (code != null && code.endsWith(".class")) {
                code = code.substring(0, code.length() - 6);
            }
            String name = elmt.getName();
            URL codebase = elmt.getCodeBase();
            String version = elmt.getVersion();
            String serName = elmt.getSerializedObject();
            String jarFiles = elmt.getJarFiles();
            URL documentBase = elmt.getDocumentBase();
            Map attributes = elmt.getAttributes();
            StringTokenizer st = new StringTokenizer(jarFiles, ",", false);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                try {
                    codebase = this.check(version, codebase, tok, elmt);
                }
                catch (Exception ex) {
                    mbeans.add(ex);
                    continue;
                }
                try {
                    if (Arrays.asList(this.getURLs()).contains(new URL(codebase.toString() + tok))) continue;
                    this.addURL(codebase + tok);
                }
                catch (MalformedURLException me) {
                    // empty catch block
                }
            }
            Object o = null;
            ObjectInstance objInst = null;
            if (code != null && serName != null) {
                mbeans.add(new Error("CODE and OBJECT parameters cannot be specified at the same time in tag MLET"));
                continue;
            }
            if (code == null && serName == null) {
                mbeans.add(new Error("Either CODE or OBJECT parameter must be specified in tag MLET"));
                continue;
            }
            try {
                if (code != null) {
                    Vector signat = new Vector();
                    Vector pars = new Vector();
                    Iterator p = attributes.keySet().iterator();
                    while (p.hasNext()) {
                        String param_name = (String)p.next();
                        if (param_name.equals("types")) {
                            signat = (Vector)elmt.getParameter(param_name);
                        }
                        if (!param_name.equals("values")) continue;
                        pars = (Vector)elmt.getParameter(param_name);
                    }
                    int i = 0;
                    while (i < signat.size()) {
                        pars.setElementAt(this.constructParameter((String)pars.elementAt(i), (String)signat.elementAt(i)), i);
                        ++i;
                    }
                    if (signat.isEmpty()) {
                        objInst = name == null ? this.server.createMBean(code, null, this.mletObjectName) : this.server.createMBean(code, new ObjectName(name), this.mletObjectName);
                    } else {
                        Object[] parms = pars.toArray();
                        String[] signature = new String[signat.size()];
                        int i2 = 0;
                        while (i2 < signature.length) {
                            signature[i2] = (String)signat.elementAt(i2);
                            ++i2;
                        }
                        objInst = name == null ? this.server.createMBean(code, null, this.mletObjectName, parms, signature) : this.server.createMBean(code, new ObjectName(name), this.mletObjectName, parms, signature);
                    }
                } else {
                    o = this.loadSerializedObject(codebase, serName);
                    if (name == null) {
                        this.server.registerMBean(o, null);
                    } else {
                        this.server.registerMBean(o, new ObjectName(name));
                    }
                    objInst = new ObjectInstance(name, o.getClass().getName());
                }
            }
            catch (ReflectionException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (InstanceAlreadyExistsException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (MBeanRegistrationException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (MBeanException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (NotCompliantMBeanException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (InstanceNotFoundException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (IOException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (SecurityException ex) {
                mbeans.add(ex);
                continue;
            }
            catch (Exception ex) {
                mbeans.add(ex);
                continue;
            }
            catch (Error ex) {
                mbeans.add(ex);
                continue;
            }
            mbeans.add(objInst);
        }
        return mbeans;
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    public void setLibraryDirectory(String libdir) {
        this.libraryDirectory = libdir;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.setMBeanServer(server);
        if (name == null) {
            name = new ObjectName(server.getDefaultDomain() + ":type=MLet");
        }
        this.mletObjectName = name;
        return this.mletObjectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void writeExternal(ObjectOutput out) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.writeExternal");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("MLet.readExternal");
    }

    public synchronized Class loadClass(String name, ClassLoaderRepository clr) throws ClassNotFoundException {
        ClassLoaderRepository before = this.currentClr;
        try {
            Class<?> c;
            this.currentClr = clr;
            Class<?> clazz = c = this.loadClass(name);
            Object var7_6 = null;
            this.currentClr = before;
            return clazz;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.currentClr = before;
            throw throwable;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, this.currentClr);
    }

    Class findClass(String name, ClassLoaderRepository clr) throws ClassNotFoundException {
        Class c = null;
        try {
            c = super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (c == null && this.delegateToCLR && clr != null) {
            try {
                c = clr.loadClassBefore(this, name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    protected String findLibrary(String libname) {
        String mth = "findLibrary";
        String nativelibname = System.mapLibraryName(libname);
        String abs_path = this.loadLibraryAsResource(nativelibname);
        if (abs_path != null) {
            return abs_path;
        }
        nativelibname = this.removeSpace(System.getProperty("os.name")) + File.separator + this.removeSpace(System.getProperty("os.arch")) + File.separator + this.removeSpace(System.getProperty("os.version")) + File.separator + "lib" + File.separator + nativelibname;
        abs_path = this.loadLibraryAsResource(nativelibname);
        if (abs_path != null) {
            return abs_path;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTmpDir() {
        block15: {
            block14: {
                block13: {
                    tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir != null) {
                        return tmpDir;
                    }
                    tmpFile = null;
                    try {
                        try {
                            tmpFile = File.createTempFile("tmp", "jmx");
                            if (tmpFile == null) {
                                var3_3 = null;
                                var8_5 = null;
                                if (tmpFile == null) return var3_3;
                                break block13;
                            }
                            tmpDirFile = tmpFile.getParentFile();
                            if (tmpDirFile == null) {
                                var5_17 = null;
                                break block14;
                            }
                            var6_18 = tmpDirFile.getAbsolutePath();
                            break block15;
                        }
                        catch (Exception x) {
                            var4_16 = null;
                            var8_8 = null;
                            if (tmpFile == null) return var4_16;
                            try {
                                tmpFile.delete();
                                return var4_16;
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                            return var4_16;
                        }
                    }
                    catch (Throwable var7_19) {
                        var8_9 = null;
                        if (tmpFile == null) throw var7_19;
                        try {}
                        catch (Exception x) {
                            throw var7_19;
                        }
                        tmpFile.delete();
                        throw var7_19;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 90->98)] { 
lbl46:
                // 1 sources

                tmpFile.delete();
                return var3_3;
lbl49:
                // 1 sources

                catch (Exception x) {
                    // empty catch block
                }
                return var3_3;
            }
            var8_6 = null;
            if (tmpFile == null) return var5_17;
            ** try [egrp 2[TRYBLOCK] [2 : 90->98)] { 
lbl56:
            // 1 sources

            tmpFile.delete();
            return var5_17;
lbl59:
            // 1 sources

            catch (Exception x) {
                // empty catch block
            }
            return var5_17;
        }
        var8_7 = null;
        if (tmpFile == null) return var6_18;
        ** try [egrp 2[TRYBLOCK] [2 : 90->98)] { 
lbl66:
        // 1 sources

        tmpFile.delete();
        return var6_18;
lbl69:
        // 1 sources

        catch (Exception x) {
            // empty catch block
        }
        return var6_18;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized String loadLibraryAsResource(String libname) {
        try {
            InputStream is;
            File file = new File(this.libraryDirectory, libname);
            if (file.exists()) {
                file.delete();
            }
            if ((is = ((ClassLoader)this).getResourceAsStream(libname.replace(File.separatorChar, '/'))) != null) {
                int c;
                file.getParentFile().mkdirs();
                FileOutputStream fileOutput = new FileOutputStream(file);
                while ((c = is.read()) != -1) {
                    void var5_6;
                    fileOutput.write((int)var5_6);
                }
                is.close();
                fileOutput.close();
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private String removeSpace(String s) {
        int j = (s = s.trim()).indexOf(32);
        if (j == -1) {
            return s;
        }
        String temp = "";
        int k = 0;
        while (j != -1) {
            j = (s = s.substring(k)).indexOf(32);
            temp = j != -1 ? temp + s.substring(0, j) : temp + s.substring(0);
            k = j + 1;
        }
        return temp;
    }

    protected URL check(String version, URL codebase, String jarfile, MLetContent mlet) throws Exception {
        return codebase;
    }

    private Object loadSerializedObject(URL codebase, String filename) throws IOException, ClassNotFoundException {
        InputStream is;
        if (filename != null) {
            filename = filename.replace(File.separatorChar, '/');
        }
        if ((is = ((ClassLoader)this).getResourceAsStream(filename)) != null) {
            try {
                MLetObjectInputStream ois = new MLetObjectInputStream(is, this);
                Object serObject = ois.readObject();
                ois.close();
                return serObject;
            }
            catch (IOException e) {
                throw e;
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
        }
        throw new Error("File " + filename + " containing serialized object not found");
    }

    private Object constructParameter(String param, String type) {
        Class c = (Class)this.primitiveClasses.get(type);
        if (c != null) {
            try {
                Constructor cons = c.getConstructor(class$java$lang$String == null ? (class$java$lang$String = MLet.class$("java.lang.String")) : class$java$lang$String);
                Object[] oo = new Object[]{param};
                return cons.newInstance(oo);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (type.compareTo("java.lang.Boolean") == 0) {
            return new Boolean(param);
        }
        if (type.compareTo("java.lang.Byte") == 0) {
            return new Byte(param);
        }
        if (type.compareTo("java.lang.Short") == 0) {
            return new Short(param);
        }
        if (type.compareTo("java.lang.Long") == 0) {
            return new Long(param);
        }
        if (type.compareTo("java.lang.Integer") == 0) {
            return new Integer(param);
        }
        if (type.compareTo("java.lang.Float") == 0) {
            return new Float(param);
        }
        if (type.compareTo("java.lang.Double") == 0) {
            return new Double(param);
        }
        if (type.compareTo("java.lang.String") == 0) {
            return param;
        }
        return param;
    }

    private synchronized void setMBeanServer(MBeanServer server) {
        this.server = server;
        this.currentClr = server.getClassLoaderRepository();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

