/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sap.pj.jmx.exception.IgnoreFirstLinePrintWriter;
import com.sap.pj.jmx.exception.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.JMRuntimeException;

public class RuntimeOperationsException
extends JMRuntimeException {
    private static final long serialVersionUID = -8408923047489133588L;
    private RuntimeException runtimeException;
    private transient String causeStackTrace;

    public RuntimeOperationsException(RuntimeException e) {
        this.runtimeException = e;
    }

    public RuntimeOperationsException(RuntimeException e, String message) {
        super(message);
        this.runtimeException = e;
    }

    public RuntimeException getTargetException() {
        return this.runtimeException;
    }

    public Throwable getCause() {
        return this.runtimeException;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(System.err, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(ps, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            this.writeCauseStackTrace(pw, true);
        }
    }

    private void writeCauseStackTrace(PrintWriter pw, boolean writeSeparator) {
        if (this.runtimeException == null) {
            return;
        }
        if (writeSeparator) {
            pw.println("-------- caused by --------");
        }
        if (this.causeStackTrace != null) {
            pw.print(this.causeStackTrace);
            pw.println("-------- predecessor system --------");
            this.runtimeException.printStackTrace(new IgnoreFirstLinePrintWriter(pw));
        } else {
            this.runtimeException.printStackTrace(pw);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        block2: {
            try {
                stream.defaultReadObject();
                this.causeStackTrace = (String)stream.readObject();
            }
            catch (Throwable e) {
                if (this.runtimeException == null || Util.serializesStackTrace(this.runtimeException)) break block2;
                StringWriter sw = new StringWriter();
                this.runtimeException.printStackTrace(new PrintWriter((Writer)sw, true));
                this.causeStackTrace = sw.toString();
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.runtimeException != null && !Util.serializesStackTrace(this.runtimeException)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            this.writeCauseStackTrace(pw, false);
            stream.writeObject(sw.toString());
        }
    }
}

