/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sap.pj.jmx.exception.IgnoreFirstLinePrintWriter;
import com.sap.pj.jmx.exception.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.JMRuntimeException;

public class RuntimeErrorException
extends JMRuntimeException {
    private static final long serialVersionUID = 704338937753949796L;
    private Error error;
    private transient String causeStackTrace;

    public RuntimeErrorException(Error e) {
        this.error = e;
    }

    public RuntimeErrorException(Error e, String message) {
        super(message);
        this.error = e;
    }

    public Error getTargetError() {
        return this.error;
    }

    public Throwable getCause() {
        return this.error;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(System.err, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(ps, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            this.writeCauseStackTrace(pw, true);
        }
    }

    private void writeCauseStackTrace(PrintWriter pw, boolean writeSeparator) {
        if (this.error == null) {
            return;
        }
        if (writeSeparator) {
            pw.println("-------- caused by --------");
        }
        if (this.causeStackTrace != null) {
            pw.print(this.causeStackTrace);
            pw.println("-------- predecessor system --------");
            this.error.printStackTrace(new IgnoreFirstLinePrintWriter(pw));
        } else {
            this.error.printStackTrace(pw);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        block2: {
            try {
                stream.defaultReadObject();
                this.causeStackTrace = (String)stream.readObject();
            }
            catch (Throwable e) {
                if (this.error == null || Util.serializesStackTrace(this.error)) break block2;
                StringWriter sw = new StringWriter();
                this.error.printStackTrace(new PrintWriter((Writer)sw, true));
                this.causeStackTrace = sw.toString();
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.error != null && !Util.serializesStackTrace(this.error)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            this.writeCauseStackTrace(pw, false);
            stream.writeObject(sw.toString());
        }
    }
}

