/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.ValueExp;

class QualifiedAttributeValueExp
extends AttributeValueExp {
    private static final long serialVersionUID = 8832517277410933254L;
    private String className;

    public QualifiedAttributeValueExp() {
    }

    public QualifiedAttributeValueExp(String className, String attr) {
        super(attr);
        this.className = className;
    }

    public String getAttrClassName() {
        return this.className;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        try {
            MBeanServer server = QueryEval.getMBeanServer();
            String v = server.getObjectInstance(name).getClassName();
            if (v.equals(this.className)) {
                return super.apply(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new InvalidApplicationException((Object)"qualified attribute");
    }

    public String toString() {
        if (this.className != null) {
            return this.className + "." + super.toString();
        }
        return super.toString();
    }
}

