/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sap.pj.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;

public class ObjectName
implements QueryExp,
Serializable {
    private static final long oldSerialVersionUID = -5467795090068647408L;
    private static final long newSerialVersionUID = 1081892073854801359L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("propertyList", class$java$util$Hashtable == null ? (class$java$util$Hashtable = ObjectName.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("propertyListString", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("canonicalName", class$java$lang$String == null ? (class$java$lang$String = ObjectName.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("pattern", Boolean.TYPE), new ObjectStreamField("propertyPattern", Boolean.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[0];
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private static final Property[] _Empty_property_array;
    private static final Hashtable _EmptyPropertyList;
    private transient String _canonicalName;
    private transient Property[] _kp_array;
    private transient Property[] _ca_array;
    private transient int _domain_length = 0;
    private transient Hashtable _propertyList;
    private transient boolean _domain_pattern = false;
    private transient boolean _property_pattern = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$javax$management$ObjectName;

    /*
     * WARNING - void declaration
     */
    private void construct(String name) throws MalformedObjectNameException {
        char c;
        if (name == null) {
            throw new MalformedObjectNameException("Invalid name: cannot be null");
        }
        if (name.length() == 0) {
            this._canonicalName = "*:*";
            this._kp_array = _Empty_property_array;
            this._ca_array = _Empty_property_array;
            this._domain_length = 1;
            this._propertyList = null;
            this._domain_pattern = true;
            this._property_pattern = true;
            return;
        }
        char[] name_chars = name.toCharArray();
        int len = name_chars.length;
        char[] canonical_chars = new char[len];
        int cname_index = 0;
        int index = 0;
        block18: while (index < len) {
            c = name_chars[index];
            switch (c) {
                case ':': {
                    this._domain_length = index++;
                    break block18;
                }
                case '=': {
                    int i = ++index;
                    while (i < len && name_chars[i++] != ':') {
                        if (i != len) continue;
                        throw new MalformedObjectNameException("Domain part must be specified");
                    }
                    continue block18;
                }
                case '\n': {
                    throw new MalformedObjectNameException("Invalid character '\\n' in domain name");
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
                default: {
                    ++index;
                }
            }
        }
        if (index == len) {
            throw new MalformedObjectNameException("Key properties cannot be empty");
        }
        System.arraycopy(name_chars, 0, canonical_chars, 0, this._domain_length);
        canonical_chars[this._domain_length] = 58;
        cname_index = this._domain_length + 1;
        PropertyLengthCouple prop_len_couple = new PropertyLengthCouple(-1, -1);
        HashMap keys_map = new HashMap();
        int property_index = 0;
        String[] keys = new String[10];
        this._kp_array = new Property[10];
        this._property_pattern = false;
        while (index < len) {
            int value_length;
            boolean quoted_value;
            char c1;
            int in_index;
            c = name_chars[index];
            if (c == '*') {
                if (this._property_pattern) {
                    throw new MalformedObjectNameException("Cannot have several '*' characters in pattern properties");
                }
                this._property_pattern = true;
                if (++index < len && name_chars[index] != ',') {
                    throw new MalformedObjectNameException("Invalid character found after '*': end of name or ',' expected");
                }
                if (index == len) {
                    if (property_index != 0) break;
                    this._kp_array = _Empty_property_array;
                    this._ca_array = _Empty_property_array;
                    this._propertyList = _EmptyPropertyList;
                    break;
                }
                ++index;
                continue;
            }
            int key_index = in_index = index;
            while (in_index < len && (c1 = name_chars[in_index++]) != '=') {
                void var8_15;
                switch (var8_15) {
                    case 10: 
                    case 42: 
                    case 44: 
                    case 58: 
                    case 63: {
                        String ichar = var8_15 == 10 ? "\\n" : "" + (char)var8_15;
                        throw new MalformedObjectNameException("Invalid character '" + ichar + "' in key part part of property");
                    }
                }
            }
            if (in_index == len) {
                throw new MalformedObjectNameException("Unterminated key property part");
            }
            if (in_index == index) {
                throw new MalformedObjectNameException("Invalid key (empty)");
            }
            int value_index = in_index;
            int key_length = value_index - key_index - 1;
            if (name_chars[in_index] == '\"') {
                quoted_value = true;
                block22: while (++in_index < len && (c1 = name_chars[in_index]) != '\"') {
                    if (c1 == '\\') {
                        if (++in_index == len) {
                            throw new MalformedObjectNameException("Unterminated quoted value");
                        }
                        c1 = name_chars[in_index];
                        switch (c1) {
                            case '\"': 
                            case '*': 
                            case '?': 
                            case '\\': 
                            case 'n': {
                                continue block22;
                            }
                            default: {
                                throw new MalformedObjectNameException("Invalid escape sequence '\\" + c1 + "' in quoted value");
                            }
                        }
                    }
                    if (c1 == '\n') {
                        throw new MalformedObjectNameException("Newline in quoted value");
                    }
                    switch (c1) {
                        case '*': 
                        case '?': {
                            throw new MalformedObjectNameException("Invalid unescaped reserved character '" + c1 + "' in quoted value");
                        }
                    }
                }
                if (in_index == len) {
                    throw new MalformedObjectNameException("Unterminated quoted value");
                }
                value_length = ++in_index - value_index;
            } else {
                quoted_value = false;
                while (in_index < len && (c1 = name_chars[in_index]) != ',') {
                    switch (c1) {
                        case '\n': 
                        case '\"': 
                        case '*': 
                        case ':': 
                        case '=': 
                        case '?': {
                            String ichar = c1 == '\n' ? "\\n" : "" + c1;
                            throw new MalformedObjectNameException("Invalid character '" + c1 + "' in value part of property");
                        }
                    }
                    ++in_index;
                }
                value_length = in_index - value_index;
            }
            if (in_index == len - 1) {
                if (quoted_value) {
                    throw new MalformedObjectNameException("Invalid ending character `" + name_chars[in_index] + "'");
                }
                throw new MalformedObjectNameException("Invalid ending comma");
            }
            ++in_index;
            prop_len_couple.setLengths(key_length, value_length);
            Property prop = new Property(key_index, prop_len_couple);
            String key_name = name.substring(key_index, key_index + key_length);
            if (property_index == keys.length) {
                String[] tmp_string_array = new String[property_index + 10];
                System.arraycopy(keys, 0, tmp_string_array, 0, property_index);
                keys = tmp_string_array;
            }
            keys[property_index] = key_name;
            this.addProperty(prop, property_index, keys_map, key_name);
            ++property_index;
            index = in_index;
        }
        this.setCanonicalName(name_chars, canonical_chars, keys, keys_map, cname_index, property_index);
    }

    private void construct(String domain, Hashtable props) throws MalformedObjectNameException {
        if (domain == null) {
            throw new MalformedObjectNameException("Domain part must be specified");
        }
        if (props == null) {
            throw new MalformedObjectNameException("Property list cannot be empty");
        }
        if (!this.isDomain(domain)) {
            throw new MalformedObjectNameException("Invalid domain: " + domain);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(domain).append(':');
        this._domain_length = domain.length();
        int nb_props = props.size();
        this._kp_array = new Property[nb_props];
        PropertyLengthCouple prop_len_couple = new PropertyLengthCouple(-1, -1);
        String[] keys = new String[nb_props];
        Enumeration e = props.keys();
        HashMap keys_map = new HashMap();
        int i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                sb.append(",");
            }
            String key = "";
            try {
                key = (String)e.nextElement();
            }
            catch (Exception x) {
                throw new MalformedObjectNameException("Invalid key `" + key + "'");
            }
            String value = "";
            try {
                value = (String)props.get(key);
            }
            catch (Exception x) {
                throw new MalformedObjectNameException("Invalid value `" + value + "'");
            }
            int key_index = sb.length();
            this.checkKey(key);
            sb.append(key);
            keys[i] = key;
            sb.append("=");
            this.checkValue(value);
            sb.append(value);
            prop_len_couple.setLengths(key.length(), value.length());
            Property prop = new Property(key_index, prop_len_couple);
            this.addProperty(prop, i, keys_map, key);
            ++i;
        }
        int len = sb.length();
        char[] initial_chars = new char[len];
        sb.getChars(0, len, initial_chars, 0);
        char[] canonical_chars = new char[len];
        System.arraycopy(initial_chars, 0, canonical_chars, 0, this._domain_length + 1);
        this.setCanonicalName(initial_chars, canonical_chars, keys, keys_map, this._domain_length + 1, this._kp_array.length);
    }

    private void addProperty(Property prop, int index, HashMap keys_map, String key_name) throws MalformedObjectNameException {
        if (keys_map.containsKey(key_name)) {
            throw new MalformedObjectNameException("key `" + key_name + "' already defined");
        }
        if (index == this._kp_array.length) {
            Property[] tmp_prop_array = new Property[index + 10];
            System.arraycopy(this._kp_array, 0, tmp_prop_array, 0, index);
            this._kp_array = tmp_prop_array;
        }
        this._kp_array[index] = prop;
        keys_map.put(key_name, prop);
    }

    private void setCanonicalName(char[] specified_chars, char[] canonical_chars, String[] keys, HashMap keys_map, int prop_index, int nb_props) {
        if (this._kp_array != _Empty_property_array) {
            Object[] tmp_keys = new String[nb_props];
            Property[] tmp_props = new Property[nb_props];
            System.arraycopy(keys, 0, tmp_keys, 0, nb_props);
            Arrays.sort(tmp_keys);
            keys = tmp_keys;
            System.arraycopy(this._kp_array, 0, tmp_props, 0, nb_props);
            this._kp_array = tmp_props;
            this._ca_array = new Property[nb_props];
            int i = 0;
            while (i < nb_props) {
                this._ca_array[i] = (Property)keys_map.get(keys[i]);
                ++i;
            }
            int last_index = nb_props - 1;
            int i2 = 0;
            while (i2 <= last_index) {
                Property prop = this._ca_array[i2];
                int prop_len = prop._lengths._key_length + prop._lengths._value_length + 1;
                System.arraycopy(specified_chars, prop._key_index, canonical_chars, prop_index, prop_len);
                prop.setKeyIndex(prop_index);
                prop_index += prop_len;
                if (i2 != last_index) {
                    canonical_chars[prop_index] = 44;
                    ++prop_index;
                }
                ++i2;
            }
        }
        if (this._property_pattern) {
            if (this._kp_array != _Empty_property_array) {
                canonical_chars[prop_index++] = 44;
            }
            canonical_chars[prop_index++] = 42;
        }
        this._canonicalName = new String(canonical_chars, 0, prop_index).intern();
    }

    private static final int parseKey(char[] s, int startKey) throws MalformedObjectNameException {
        int next = startKey;
        int endKey = startKey;
        int len = s.length;
        block4: while (next < len) {
            char k = s[next++];
            switch (k) {
                case '\n': 
                case '*': 
                case ',': 
                case ':': 
                case '?': {
                    String ichar = k == '\n' ? "\\n" : "" + k;
                    throw new MalformedObjectNameException("Invalid character in key: `" + ichar + "'");
                }
                case '=': {
                    endKey = next - 1;
                    break block4;
                }
                default: {
                    if (next < len) continue block4;
                    endKey = next;
                    break block4;
                }
            }
        }
        return endKey;
    }

    /*
     * Unable to fully structure code
     */
    private static final int parseValue(char[] s, int startValue) throws MalformedObjectNameException {
        block20: {
            next = startValue;
            endValue = startValue;
            len = s.length;
            q = s[startValue];
            if (q != '\"') ** GOTO lbl-1000
            if (++next != len) ** GOTO lbl34
            throw new MalformedObjectNameException("Invalid quote");
lbl-1000:
            // 1 sources

            {
                block19: {
                    block18: {
                        last = s[next];
                        if (last != '\\') break block18;
                        if (++next == len) {
                            throw new MalformedObjectNameException("Invalid unterminated quoted character sequence");
                        }
                        last = s[next];
                        switch (last) {
                            case '*': 
                            case '?': 
                            case '\\': 
                            case 'n': {
                                break block19;
                            }
                            case '\"': {
                                if (next + 1 == len) {
                                    throw new MalformedObjectNameException("Missing termination quote");
                                }
                                break block19;
                            }
                            default: {
                                throw new MalformedObjectNameException("Invalid quoted character sequence '\\" + last + "'");
                            }
                        }
                    }
                    if (last == '\n') {
                        throw new MalformedObjectNameException("Newline in quoted value");
                    }
                    if (last == '\"') {
                        ++next;
                        break;
                    }
                    switch (last) {
                        case '*': 
                        case '?': {
                            throw new MalformedObjectNameException("Invalid unescaped reserved character '" + last + "' in quoted value");
                        }
                    }
                }
                if (++next < len || last == '\"') continue;
                throw new MalformedObjectNameException("Missing termination quote");
lbl34:
                // 2 sources

                ** while (next < len)
            }
lbl35:
            // 2 sources

            endValue = next;
            if (next < len && s[next++] != ',') {
                throw new MalformedObjectNameException("Invalid quote");
lbl-1000:
                // 1 sources

                {
                    v = s[next++];
                    switch (v) {
                        case '\n': 
                        case '*': 
                        case ':': 
                        case '=': 
                        case '?': {
                            ichar = v == '\n' ? "\\n" : "" + v;
                            throw new MalformedObjectNameException("Invalid character `" + ichar + "' in value");
                        }
                        case ',': {
                            endValue = next - 1;
                            break block12;
                        }
                        default: {
                            if (next < len) continue block12;
                            endValue = next;
                            break block12;
                        }
                    }
                }
            }
            break block20;
lbl-1000:
            // 2 sources

            {
                ** while (next < len)
            }
        }
        return endValue;
    }

    private String checkValue(String val) throws MalformedObjectNameException {
        if (val == null) {
            throw new MalformedObjectNameException("Invalid value (null)");
        }
        int len = val.length();
        if (len == 0) {
            throw new MalformedObjectNameException("Invalid value (empty)");
        }
        char[] s = val.toCharArray();
        int endValue = ObjectName.parseValue(s, 0);
        if (endValue < len) {
            throw new MalformedObjectNameException("Invalid character in value: `" + s[endValue] + "'");
        }
        return val;
    }

    private String checkKey(String key) throws MalformedObjectNameException {
        if (key == null) {
            throw new MalformedObjectNameException("Invalid key (null)");
        }
        int len = key.length();
        if (len == 0) {
            throw new MalformedObjectNameException("Invalid key (empty)");
        }
        char[] k = key.toCharArray();
        int endKey = ObjectName.parseKey(k, 0);
        if (endKey < len) {
            throw new MalformedObjectNameException("Invalid character in value: `" + k[endKey] + "'");
        }
        return key;
    }

    private static boolean wildmatch(char[] s, char[] p, int si, int pi) {
        int slen = s.length;
        int plen = p.length;
        while (pi < plen) {
            char c;
            if ((c = p[pi++]) == '?') {
                if (++si <= slen) continue;
                return false;
            }
            if (c == '*') {
                if (pi >= plen) {
                    return true;
                }
                do {
                    if (!ObjectName.wildmatch(s, p, si, pi)) continue;
                    return true;
                } while (++si < slen);
                return false;
            }
            if (si < slen && c == s[si++]) continue;
            return false;
        }
        return si == slen;
    }

    private boolean isDomain(String domain) {
        if (domain == null) {
            return true;
        }
        char[] d = domain.toCharArray();
        int len = d.length;
        int next = 0;
        while (next < len) {
            char c = d[next++];
            switch (c) {
                case '\n': 
                case ':': {
                    return false;
                }
                case '*': 
                case '?': {
                    this._domain_pattern = true;
                }
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (compat) {
            in.defaultReadObject();
        } else {
            in.defaultReadObject();
            String s = (String)in.readObject();
            try {
                this.construct(s);
            }
            catch (MalformedObjectNameException e) {
                throw new InvalidObjectException(e.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField fields = out.putFields();
            fields.put("domain", this._canonicalName.substring(0, this._domain_length));
            fields.put("propertyList", this.getKeyPropertyList());
            fields.put("propertyListString", this.getKeyPropertyListString());
            fields.put("canonicalName", this._canonicalName);
            fields.put("pattern", this._domain_pattern || this._property_pattern);
            fields.put("propertyPattern", this._property_pattern);
            out.writeFields();
        } else {
            out.defaultWriteObject();
            out.writeObject(this.getSerializedNameString());
        }
    }

    public static ObjectName getInstance(String name) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(name);
    }

    public static ObjectName getInstance(String domain, String key, String value) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(domain, key, value);
    }

    public static ObjectName getInstance(String domain, Hashtable table) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(domain, table);
    }

    public static ObjectName getInstance(ObjectName name) throws NullPointerException {
        if (name.getClass().equals(class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = ObjectName.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
            return name;
        }
        try {
            return new ObjectName(name.getCanonicalName());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Unexpected: " + e);
        }
    }

    public ObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        this.construct(name);
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException, NullPointerException {
        Hashtable<String, String> table = new Hashtable<String, String>(1);
        if (key == null || value == null) {
            throw new MalformedObjectNameException("Neither the key nor the value can be null");
        }
        table.put(key, value);
        this.construct(domain, table);
    }

    public ObjectName(String domain, Hashtable table) throws MalformedObjectNameException, NullPointerException {
        if (table == null) {
            throw new MalformedObjectNameException("Hashtable is null");
        }
        if (table.isEmpty()) {
            throw new MalformedObjectNameException("Empty Hashtable");
        }
        this.construct(domain, table);
    }

    public boolean isPattern() {
        return this._domain_pattern || this._property_pattern;
    }

    public boolean isDomainPattern() {
        return this._domain_pattern;
    }

    public boolean isPropertyPattern() {
        return this._property_pattern;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public String getDomain() {
        return this._canonicalName.substring(0, this._domain_length);
    }

    public String getKeyProperty(String property) throws NullPointerException {
        return (String)this._getKeyPropertyList().get(property);
    }

    private final Hashtable _getKeyPropertyList() {
        ObjectName objectName = this;
        synchronized (objectName) {
            if (this._propertyList == null) {
                this._propertyList = new Hashtable();
                int len = this._ca_array.length;
                int i = len - 1;
                while (i >= 0) {
                    Property prop = this._ca_array[i];
                    this._propertyList.put(prop.getKeyString(this._canonicalName), prop.getValueString(this._canonicalName));
                    --i;
                }
            }
        }
        return this._propertyList;
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this._getKeyPropertyList().clone();
    }

    public String getKeyPropertyListString() {
        if (this._kp_array.length == 0) {
            return "";
        }
        int total_size = this._canonicalName.length() - this._domain_length - 1 - (this._property_pattern ? 2 : 0);
        char[] dest_chars = new char[total_size];
        char[] value = this._canonicalName.toCharArray();
        this.writeKeyPropertyListString(value, dest_chars, 0);
        return new String(dest_chars);
    }

    private String getSerializedNameString() {
        int total_size = this._canonicalName.length();
        char[] dest_chars = new char[total_size];
        char[] value = this._canonicalName.toCharArray();
        int offset = this._domain_length + 1;
        System.arraycopy(value, 0, dest_chars, 0, offset);
        int end = this.writeKeyPropertyListString(value, dest_chars, offset);
        if (this._property_pattern) {
            if (end == offset) {
                dest_chars[end] = 42;
            } else {
                dest_chars[end] = 44;
                dest_chars[end + 1] = 42;
            }
        }
        return new String(dest_chars);
    }

    private int writeKeyPropertyListString(char[] canonicalChars, char[] data, int offset) {
        if (this._kp_array.length == 0) {
            return offset;
        }
        char[] dest_chars = data;
        char[] value = this._canonicalName.toCharArray();
        int index = offset;
        int len = this._kp_array.length;
        int last = len - 1;
        int i = 0;
        while (i < len) {
            Property prop = this._kp_array[i];
            int prop_len = prop._lengths._key_length + prop._lengths._value_length + 1;
            System.arraycopy(value, prop._key_index, dest_chars, index, prop_len);
            index += prop_len;
            if (i < last) {
                dest_chars[index++] = 44;
            }
            ++i;
        }
        return index;
    }

    public String getCanonicalKeyPropertyListString() {
        if (this._ca_array.length == 0) {
            return "";
        }
        int len = this._canonicalName.length();
        if (this._property_pattern) {
            len -= 2;
        }
        return this._canonicalName.substring(this._domain_length + 1, len);
    }

    public String toString() {
        return this.getSerializedNameString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectName)) {
            return false;
        }
        ObjectName on = (ObjectName)object;
        String on_string = on._canonicalName;
        return this._canonicalName == on_string;
    }

    public int hashCode() {
        return this._canonicalName.hashCode();
    }

    public static String quote(String s) throws NullPointerException {
        StringBuffer buf = new StringBuffer("\"");
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    c = 'n';
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    buf.append('\\');
                }
            }
            buf.append(c);
            ++i;
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String unquote(String q) throws IllegalArgumentException, NullPointerException {
        StringBuffer buf = new StringBuffer();
        int len = q.length();
        if (len < 2 || q.charAt(0) != '\"' || q.charAt(len - 1) != '\"') {
            throw new IllegalArgumentException("Argument not quoted");
        }
        int i = 1;
        while (i < len - 1) {
            char c;
            block11: {
                block10: {
                    c = q.charAt(i);
                    if (c != '\\') break block10;
                    if (i == len - 2) {
                        throw new IllegalArgumentException("Trailing backslash");
                    }
                    c = q.charAt(++i);
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break block11;
                        }
                        case '\"': 
                        case '*': 
                        case '?': 
                        case '\\': {
                            break block11;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad character '" + c + "' after backslash");
                        }
                    }
                }
                switch (c) {
                    case '\n': 
                    case '\"': 
                    case '*': 
                    case '?': {
                        throw new IllegalArgumentException("Invalid unescaped character '" + c + "' in the string to unquote");
                    }
                }
            }
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }

    public boolean apply(ObjectName name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name._domain_pattern || name._property_pattern) {
            return false;
        }
        if (!this._domain_pattern && !this._property_pattern) {
            return this._canonicalName.equals(name._canonicalName);
        }
        return this.matchDomains(name) && this.matchKeys(name);
    }

    private final boolean matchDomains(ObjectName name) {
        if (this._domain_pattern) {
            char[] dom_pattern = this.getDomain().toCharArray();
            char[] dom_string = name.getDomain().toCharArray();
            return ObjectName.wildmatch(dom_string, dom_pattern, 0, 0);
        }
        return this.getDomain().equals(name.getDomain());
    }

    private final boolean matchKeys(ObjectName name) {
        if (this._property_pattern) {
            Hashtable nameProps = name._getKeyPropertyList();
            Property[] props = this._ca_array;
            String cn = this._canonicalName;
            int i = props.length - 1;
            while (i >= 0) {
                Property p = props[i];
                String k = p.getKeyString(cn);
                String v = (String)nameProps.get(k);
                if (v == null) {
                    return false;
                }
                if (!v.equals(p.getValueString(cn))) {
                    return false;
                }
                --i;
            }
            return true;
        }
        String p1 = name.getCanonicalKeyPropertyListString();
        String p2 = this.getCanonicalKeyPropertyListString();
        return p1.equals(p2);
    }

    public void setMBeanServer(MBeanServer mbs) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction act = new GetPropertyAction("jmx.serial.form");
            String form = (String)AccessController.doPrivileged(act);
            compat = form != null && form.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -5467795090068647408L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 1081892073854801359L;
        }
        _Empty_property_array = new Property[0];
        _EmptyPropertyList = new Hashtable(1);
    }

    private static final class Property {
        private static WeakHashMap _PropertyLengthCouples = new WeakHashMap(89);
        int _key_index;
        PropertyLengthCouple _lengths;

        Property(int key_index, PropertyLengthCouple couple) {
            PropertyLengthCouple pl_couple;
            this._key_index = key_index;
            WeakReference tmp_ref = (WeakReference)_PropertyLengthCouples.get(couple);
            if (tmp_ref != null && (pl_couple = (PropertyLengthCouple)tmp_ref.get()) != null) {
                this._lengths = pl_couple;
            } else {
                this._lengths = new PropertyLengthCouple(couple._key_length, couple._value_length);
                _PropertyLengthCouples.put(this._lengths, new WeakReference<PropertyLengthCouple>(this._lengths));
            }
        }

        void setKeyIndex(int key_index) {
            this._key_index = key_index;
        }

        String getKeyString(String name) {
            return name.substring(this._key_index, this._key_index + this._lengths._key_length);
        }

        String getValueString(String name) {
            int in_begin = this._key_index + this._lengths._key_length + 1;
            int out_end = in_begin + this._lengths._value_length;
            return name.substring(in_begin, out_end);
        }
    }

    private static final class PropertyLengthCouple {
        int _key_length = 0;
        int _value_length = 0;

        private PropertyLengthCouple(int key_length, int value_length) {
            this._key_length = key_length;
            this._value_length = value_length;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PropertyLengthCouple)) {
                return false;
            }
            PropertyLengthCouple couple = (PropertyLengthCouple)obj;
            return this._key_length == couple._key_length && this._value_length == couple._value_length;
        }

        public int hashCode() {
            return this._key_length << 5 ^ this._value_length;
        }

        void setLengths(int key_length, int value_length) {
            this._key_length = key_length;
            this._value_length = value_length;
        }
    }
}

