/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class ObjectInstance
implements Serializable {
    private static final long serialVersionUID = -4099952623687795850L;
    private String className;
    private ObjectName name;
    private transient int hashcode;

    public ObjectInstance(String objectName, String className) throws MalformedObjectNameException {
        this(new ObjectName(objectName), className);
    }

    public ObjectInstance(ObjectName objectName, String className) {
        if (objectName == null || objectName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name is not valid."));
        }
        if (className == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name is not valid."));
        }
        this.name = objectName;
        this.className = className;
    }

    private void setHashcode() {
        this.hashcode = 17;
        this.hashcode = 37 * this.hashcode + this.name.hashCode();
        this.hashcode = 37 * this.hashcode + this.className.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectInstance)) {
            return false;
        }
        ObjectInstance val = (ObjectInstance)object;
        return this.name.equals(val.getObjectName()) && this.className.equals(val.getClassName());
    }

    public String toString() {
        return this.className + "@" + this.name;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.className.hashCode();
    }
}

