/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import javax.management.MBeanServerPermissionCollection;

public class MBeanServerPermission
extends BasicPermission {
    private static final long serialVersionUID = -5661980843569388590L;
    private static final int CREATE = 0;
    private static final int FIND = 1;
    private static final int NEW = 2;
    private static final int RELEASE = 3;
    private static final int N_NAMES = 4;
    private static final String[] names = new String[]{"createMBeanServer", "findMBeanServer", "newMBeanServer", "releaseMBeanServer"};
    private static final int CREATE_MASK = 1;
    private static final int FIND_MASK = 2;
    private static final int NEW_MASK = 4;
    private static final int RELEASE_MASK = 8;
    private static final int ALL_MASK = 15;
    private static final String[] canonicalNames = new String[16];
    transient int mask;

    public MBeanServerPermission(String name) {
        this(name, null);
    }

    public MBeanServerPermission(String name, String actions) {
        super(MBeanServerPermission.getCanonicalName(MBeanServerPermission.parseMask(name)), actions);
        this.mask = MBeanServerPermission.parseMask(name);
        if (actions != null && actions.length() > 0) {
            throw new IllegalArgumentException("MBeanServerPermission actions must be null: " + actions);
        }
    }

    MBeanServerPermission(int mask) {
        super(MBeanServerPermission.getCanonicalName(mask));
        this.mask = MBeanServerPermission.impliedMask(mask);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mask = MBeanServerPermission.parseMask(this.getName());
    }

    static int simplifyMask(int mask) {
        if ((mask & 1) != 0) {
            mask &= 0xFFFFFFFB;
        }
        return mask;
    }

    static int impliedMask(int mask) {
        if ((mask & 1) != 0) {
            mask |= 4;
        }
        return mask;
    }

    static String getCanonicalName(int mask) {
        if (mask == 15) {
            return "*";
        }
        mask = MBeanServerPermission.simplifyMask(mask);
        String[] stringArray = canonicalNames;
        synchronized (stringArray) {
            if (canonicalNames[mask] == null) {
                MBeanServerPermission.canonicalNames[mask] = MBeanServerPermission.makeCanonicalName(mask);
            }
        }
        return canonicalNames[mask];
    }

    private static String makeCanonicalName(int mask) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < 4) {
            if ((mask & 1 << i) != 0) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(names[i]);
            }
            ++i;
        }
        return buf.toString().intern();
    }

    private static int parseMask(String name) {
        if (name == null) {
            throw new NullPointerException("MBeanServerPermission: target name can't be null");
        }
        if ((name = name.trim()).equals("*")) {
            return 15;
        }
        if (name.indexOf(44) < 0) {
            return MBeanServerPermission.impliedMask(1 << MBeanServerPermission.nameIndex(name.trim()));
        }
        int mask = 0;
        StringTokenizer tok = new StringTokenizer(name, ",");
        while (tok.hasMoreTokens()) {
            String action = tok.nextToken();
            int i = MBeanServerPermission.nameIndex(action.trim());
            mask |= 1 << i;
        }
        return MBeanServerPermission.impliedMask(mask);
    }

    private static int nameIndex(String name) throws IllegalArgumentException {
        int i = 0;
        while (i < 4) {
            if (names[i].equals(name)) {
                return i;
            }
            ++i;
        }
        String msg = "Invalid MBeanServerPermission name: \"" + name + "\"";
        throw new IllegalArgumentException(msg);
    }

    public int hashCode() {
        return this.mask;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof MBeanServerPermission)) {
            return false;
        }
        MBeanServerPermission that = (MBeanServerPermission)p;
        return (this.mask & that.mask) == that.mask;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MBeanServerPermission)) {
            return false;
        }
        MBeanServerPermission that = (MBeanServerPermission)obj;
        return this.mask == that.mask;
    }

    public PermissionCollection newPermissionCollection() {
        return new MBeanServerPermissionCollection();
    }
}

