/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sap.pj.jmx.PropertyManager;
import com.sap.pj.jmx.mbeanserver.GetPropertyAction;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerFactory {
    private static List servers = Collections.synchronizedList(new ArrayList());
    private static MBeanServerBuilder builder = null;
    static /* synthetic */ Class class$javax$management$MBeanServerBuilder;

    private MBeanServerFactory() {
    }

    public static MBeanServer createMBeanServer() {
        MBeanServerFactory.checkPermission("createMBeanServer");
        MBeanServer server = MBeanServerFactory.newMBeanServer();
        if (server != null) {
            servers.add(server);
        }
        return server;
    }

    public static MBeanServer createMBeanServer(String domain) {
        MBeanServerFactory.checkPermission("createMBeanServer");
        MBeanServer server = MBeanServerFactory.newMBeanServer(domain);
        if (server != null) {
            servers.add(server);
        }
        return server;
    }

    public static ArrayList findMBeanServer(String agentId) {
        MBeanServerFactory.checkPermission("findMBeanServer");
        if (agentId == null) {
            return new ArrayList(servers);
        }
        ArrayList<MBeanServer> returnList = new ArrayList<MBeanServer>();
        ObjectName serverDelegateName = null;
        String ai = null;
        try {
            serverDelegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            MBeanServer server = (MBeanServer)iter.next();
            try {
                ai = (String)server.getAttribute(serverDelegateName, "MBeanServerId");
                if (!agentId.equals(ai)) continue;
                returnList.add(server);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return returnList;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(PropertyManager.getDefaultDomain());
    }

    private static synchronized MBeanServerBuilder getNewMBeanServerBuilder() {
        MBeanServerFactory.checkMBeanServerBuilder();
        return builder;
    }

    private static Class loadBuilderClass(String builderClassName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader.loadClass(builderClassName);
        }
        return Class.forName(builderClassName);
    }

    private static MBeanServerBuilder newBuilder(Class builderClass) {
        try {
            Object builder = builderClass.newInstance();
            return (MBeanServerBuilder)builder;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            String msg = "Failed to instantiate a MBeanServerBuilder from " + builderClass + ": " + x;
            throw new JMRuntimeException(msg, x);
        }
    }

    private static synchronized void checkMBeanServerBuilder() {
        GetPropertyAction act = new GetPropertyAction("javax.management.builder.initial");
        String builderClassName = (String)AccessController.doPrivileged(act);
        try {
            Class<?> builderClass;
            Class newBuilderClass = builderClassName == null || builderClassName.length() == 0 ? (class$javax$management$MBeanServerBuilder == null ? (class$javax$management$MBeanServerBuilder = MBeanServerFactory.class$("javax.management.MBeanServerBuilder")) : class$javax$management$MBeanServerBuilder) : MBeanServerFactory.loadBuilderClass(builderClassName);
            if (builder != null && newBuilderClass == (builderClass = builder.getClass())) {
                return;
            }
            builder = MBeanServerFactory.newBuilder(newBuilderClass);
        }
        catch (ClassNotFoundException x) {
            String msg = "Failed to load MBeanServerBuilder class " + builderClassName + ": " + x;
            throw new JMRuntimeException(msg, x);
        }
    }

    public static MBeanServer newMBeanServer(String domain) {
        MBeanServerBuilder mbsBuilder;
        MBeanServerFactory.checkPermission("newMBeanServer");
        MBeanServerBuilder mBeanServerBuilder = mbsBuilder = MBeanServerFactory.getNewMBeanServerBuilder();
        synchronized (mBeanServerBuilder) {
            MBeanServerDelegate delegate = mbsBuilder.newMBeanServerDelegate();
            if (delegate == null) {
                String msg = "MBeanServerBuilder.newMBeanServerDelegate() returned null";
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServerDelegate() returned null");
            }
            MBeanServer mbeanServer = mbsBuilder.newMBeanServer(domain, null, delegate);
            if (mbeanServer == null) {
                String msg = "MBeanServerBuilder.newMBeanServer() returned null";
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServer() returned null");
            }
            MBeanServer mBeanServer = mbeanServer;
            return mBeanServer;
        }
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        MBeanServerFactory.checkPermission("releaseMBeanServer");
        servers.remove(mbeanServer);
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static void checkPermission(String action) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            MBeanServerPermission perm = new MBeanServerPermission(action);
            sm.checkPermission(perm);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

