/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sap.pj.jmx.PropertyManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationEmitter {
    private static long idSequence = 0L;
    private String agentId = null;
    private long sequenceNumber = 1L;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();

    public MBeanServerDelegate() {
        String ipAddress = null;
        try {
            ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            ipAddress = "127.0.0.1";
        }
        try {
            this.agentId = InetAddress.getLocalHost().getHostName() + "/" + System.currentTimeMillis() + "/" + idSequence++;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String getMBeanServerId() {
        return this.agentId;
    }

    public String getSpecificationVersion() {
        return PropertyManager.getSpecificationVersion();
    }

    public String getSpecificationVendor() {
        return PropertyManager.getSpecificationVendor();
    }

    public String getImplementationName() {
        return PropertyManager.getImplementationName();
    }

    public String getImplementationVersion() {
        return PropertyManager.getImplementationVersion();
    }

    public String getImplementationVendor() {
        return PropertyManager.getImplementationVendor();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"JMX.mbean.unregistered", "JMX.mbean.registered"};
        MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "MBeanServerNotification", "Notifications sent by the MBeanServerDelegate MBean")};
        return notifsInfo;
    }

    public String getSpecificationName() {
        return PropertyManager.getSpecificationName();
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public void sendNotification(Notification notification) {
        if (notification.getSequenceNumber() < 1L) {
            MBeanServerDelegate mBeanServerDelegate = this;
            synchronized (mBeanServerDelegate) {
                notification.setSequenceNumber(this.sequenceNumber++);
            }
        }
        this.broadcaster.sendNotification(notification);
    }
}

