/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.InvalidParameterException;
import javax.management.RuntimeOperationsException;

public class MBeanFeatureInfo
implements Serializable {
    private static final long serialVersionUID = 3952882688968447265L;
    protected String name;
    protected String description;
    private transient int hashcode;

    public MBeanFeatureInfo(String name, String description) throws IllegalArgumentException {
        if (name == null) {
            throw new RuntimeOperationsException(new InvalidParameterException("Name of feature must not be null"));
        }
        this.name = name;
        this.description = description;
    }

    private void setHashcode() {
        this.hashcode = 17;
        this.hashcode = 37 * this.hashcode + this.name.hashCode();
        if (this.description != null) {
            this.hashcode = 37 * this.hashcode + this.description.hashCode();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MBeanFeatureInfo oi = (MBeanFeatureInfo)other;
        return this.description.equals(oi.description) && this.name.equals(oi.name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getDescription().hashCode();
    }
}

