/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sap.pj.jmx.exception.IgnoreFirstLinePrintWriter;
import com.sap.pj.jmx.exception.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.JMException;

public class MBeanException
extends JMException {
    private static final long serialVersionUID = 4066342430588744142L;
    private Exception exception;
    private transient String causeStackTrace;

    public MBeanException(Exception ex) {
        this.exception = ex;
    }

    public MBeanException(Exception ex, String msg) {
        super(msg);
        this.exception = ex;
    }

    public Exception getTargetException() {
        return this.exception;
    }

    public Throwable getCause() {
        return this.exception;
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(System.err, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(ps, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            this.writeCauseStackTrace(pw, true);
        }
    }

    private void writeCauseStackTrace(PrintWriter pw, boolean writeSeparator) {
        if (this.exception == null) {
            return;
        }
        if (writeSeparator) {
            pw.println("-------- caused by --------");
        }
        if (this.causeStackTrace != null) {
            pw.print(this.causeStackTrace);
            pw.println("-------- predecessor system --------");
            this.exception.printStackTrace(new IgnoreFirstLinePrintWriter(pw));
        } else {
            this.exception.printStackTrace(pw);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        block2: {
            try {
                stream.defaultReadObject();
                this.causeStackTrace = (String)stream.readObject();
            }
            catch (Throwable e) {
                if (this.exception == null || Util.serializesStackTrace(this.exception)) break block2;
                StringWriter sw = new StringWriter();
                this.exception.printStackTrace(new PrintWriter((Writer)sw, true));
                this.causeStackTrace = sw.toString();
            }
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        if (this.exception != null && !Util.serializesStackTrace(this.exception)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            this.writeCauseStackTrace(pw, false);
            stream.writeObject(sw.toString());
        }
    }
}

