/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sap.pj.jmx.exception.IgnoreFirstLinePrintWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class JMRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 6573344628407841861L;
    private transient String actionStackTrace;

    JMRuntimeException(String message, Throwable cause) {
        super(message);
    }

    public JMRuntimeException() {
    }

    public JMRuntimeException(String message) {
        super(message);
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(System.err, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(ps, true);
            this.printStackTrace(pw);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            this.writeActionStackTrace(pw);
        }
    }

    private void writeActionStackTrace(PrintWriter pw) {
        if (this.actionStackTrace != null) {
            pw.print(this.actionStackTrace);
            pw.println("-------- predecessor system --------");
            super.printStackTrace(new IgnoreFirstLinePrintWriter(pw));
        } else {
            super.printStackTrace(pw);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            stream.defaultReadObject();
            this.actionStackTrace = (String)stream.readObject();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (this.actionStackTrace == null) {
            StringWriter sw = new StringWriter();
            super.printStackTrace(new PrintWriter(sw));
            this.actionStackTrace = sw.toString();
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        this.writeActionStackTrace(pw);
        stream.writeObject(sw.toString());
    }
}

