/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class InQueryExp
extends QueryEval
implements QueryExp {
    private static final long serialVersionUID = -5801329450358952434L;
    private ValueExp val;
    private ValueExp[] valueList;

    public InQueryExp() {
    }

    public InQueryExp(ValueExp v1, ValueExp[] items) {
        this.val = v1;
        this.valueList = items;
    }

    public ValueExp getCheckedValue() {
        return this.val;
    }

    public ValueExp[] getExplicitValues() {
        return this.valueList;
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        if (this.valueList != null) {
            ValueExp v = this.val.apply(name);
            boolean numeric = v instanceof NumericValueExp;
            int i = 0;
            while (i < this.valueList.length) {
                if (numeric ? ((NumericValueExp)this.valueList[i]).doubleValue() == ((NumericValueExp)v).doubleValue() : ((StringValueExp)this.valueList[i]).getValue().equals(((StringValueExp)v).getValue())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        return this.val + " in (" + this.generateValueList() + ")";
    }

    private String generateValueList() {
        if (this.valueList == null || this.valueList.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(this.valueList[0].toString());
        int i = 1;
        while (i < this.valueList.length) {
            result.append(", ");
            result.append(this.valueList[i]);
            ++i;
        }
        return result.toString();
    }
}

