/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.util.rwlock;

import com.sap.pj.jmx.util.rwlock.InvalidWaitTime;
import com.sap.pj.jmx.util.rwlock.LockNotHeld;
import com.sap.pj.jmx.util.rwlock.RWLock;
import com.sap.pj.jmx.util.rwlock.UpgradeNotAllowed;
import java.util.LinkedList;
import java.util.ListIterator;

public class RWLockImpl
implements RWLock {
    private static final int READ = 1;
    private static final int WRITE = 2;
    private boolean allowUpgrades;
    private WaitingList waitingList = new WaitingList();

    public RWLockImpl() {
        this(false);
    }

    public RWLockImpl(boolean allowUpgrades) {
        this.allowUpgrades = allowUpgrades;
    }

    public synchronized boolean forReading() {
        try {
            return this.forReading(-1);
        }
        catch (InvalidWaitTime e) {
            return false;
        }
    }

    public synchronized boolean forReading(int waitTime) throws InvalidWaitTime {
        if (waitTime < -1) {
            throw new InvalidWaitTime();
        }
        WaitingListElement element = null;
        int index = this.waitingList.findMe();
        if (index != -1) {
            element = (WaitingListElement)this.waitingList.get(index);
        } else {
            element = new WaitingListElement(1);
            this.waitingList.add(element);
        }
        if (element.lockCount > 0) {
            ++element.lockCount;
            return true;
        }
        long startTime = System.currentTimeMillis();
        while (waitTime == -1 || startTime + (long)waitTime > System.currentTimeMillis()) {
            int nextWriter = -1;
            nextWriter = this.waitingList.firstWriterIndex();
            index = this.waitingList.findMe();
            if (nextWriter == -1 || nextWriter > index) {
                ++element.lockCount;
                element.granted = true;
                return true;
            }
            if (waitTime == 0) {
                this.waitingList.remove(element);
                return false;
            }
            try {
                if (waitTime == -1) {
                    this.wait();
                    continue;
                }
                long delta = Math.abs(System.currentTimeMillis() - startTime);
                this.wait((long)waitTime - delta);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.waitingList.remove(element);
        this.notifyAll();
        return false;
    }

    public synchronized boolean forWriting() throws UpgradeNotAllowed {
        try {
            return this.forWriting(-1);
        }
        catch (InvalidWaitTime e) {
            return false;
        }
    }

    public synchronized boolean forWriting(int waitTime) throws InvalidWaitTime, UpgradeNotAllowed {
        if (waitTime < -1) {
            throw new InvalidWaitTime();
        }
        WaitingListElement element = null;
        int index = this.waitingList.findMe();
        if (index != -1) {
            element = (WaitingListElement)this.waitingList.get(index);
        } else {
            element = new WaitingListElement(2);
            this.waitingList.add(element);
        }
        if (element.granted && element.lockType == 1) {
            try {
                if (!this.upgrade(waitTime)) {
                    return false;
                }
            }
            catch (LockNotHeld e) {
                return false;
            }
        }
        if (element.lockCount > 0) {
            ++element.lockCount;
            return true;
        }
        long startTime = System.currentTimeMillis();
        while (waitTime == -1 || startTime + (long)waitTime > System.currentTimeMillis()) {
            index = this.waitingList.findMe();
            if (index == 0) {
                ++element.lockCount;
                element.granted = true;
                return true;
            }
            if (waitTime == 0) {
                this.waitingList.remove(element);
                return false;
            }
            try {
                if (waitTime == -1) {
                    this.wait();
                    continue;
                }
                long delta = Math.abs(System.currentTimeMillis() - startTime);
                this.wait((long)waitTime - delta);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.waitingList.remove(element);
        this.notifyAll();
        return false;
    }

    public synchronized boolean upgrade() throws UpgradeNotAllowed, LockNotHeld {
        try {
            return this.upgrade(-1);
        }
        catch (InvalidWaitTime e) {
            return false;
        }
    }

    public synchronized boolean upgrade(int waitTime) throws InvalidWaitTime, UpgradeNotAllowed, LockNotHeld {
        if (!this.allowUpgrades) {
            throw new UpgradeNotAllowed();
        }
        if (waitTime < -1) {
            throw new InvalidWaitTime();
        }
        int index = this.waitingList.findMe();
        if (index == -1) {
            throw new LockNotHeld();
        }
        WaitingListElement element = (WaitingListElement)this.waitingList.get(index);
        if (element.lockType == 2) {
            return true;
        }
        int lastGranted = this.waitingList.lastGrantedIndex();
        if (lastGranted == -1) {
            throw new LockNotHeld();
        }
        if (index != lastGranted) {
            this.waitingList.remove(index);
            ListIterator<WaitingListElement> iter = this.waitingList.listIterator(lastGranted);
            iter.add(element);
        }
        element.lockType = 2;
        long startTime = System.currentTimeMillis();
        while (waitTime == -1 || startTime + (long)waitTime > System.currentTimeMillis()) {
            index = this.waitingList.findMe();
            if (index == 0) {
                return true;
            }
            if (waitTime == 0) {
                element.lockType = 1;
                return false;
            }
            try {
                if (waitTime == -1) {
                    this.wait();
                    continue;
                }
                long delta = Math.abs(System.currentTimeMillis() - startTime);
                this.wait((long)waitTime - delta);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        element.lockType = 1;
        this.notifyAll();
        return false;
    }

    public synchronized boolean downgrade() throws LockNotHeld {
        int index = this.waitingList.findMe();
        if (index == -1) {
            throw new LockNotHeld();
        }
        WaitingListElement element = (WaitingListElement)this.waitingList.get(index);
        if (element.lockType == 2) {
            element.lockType = 1;
            this.notifyAll();
        }
        return true;
    }

    public synchronized void release() throws LockNotHeld {
        if (this.waitingList.isEmpty()) {
            throw new LockNotHeld();
        }
        int index = this.waitingList.findMe();
        if (index == -1) {
            throw new LockNotHeld();
        }
        WaitingListElement e = (WaitingListElement)this.waitingList.get(index);
        if (--e.lockCount == 0) {
            this.waitingList.remove(index);
            this.notifyAll();
        }
    }

    private class WaitingListElement {
        Thread key = Thread.currentThread();
        int lockType;
        int lockCount;
        boolean granted;

        WaitingListElement() {
            this(0);
        }

        WaitingListElement(int type) {
            this.lockType = type;
            this.lockCount = 0;
            this.granted = false;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WaitingListElement)) {
                return false;
            }
            WaitingListElement element = (WaitingListElement)o;
            return element.key == this.key;
        }
    }

    private class WaitingList
    extends LinkedList {
        private WaitingList() {
        }

        int firstWriterIndex() {
            ListIterator iter = this.listIterator(0);
            int index = 0;
            while (iter.hasNext()) {
                if (((WaitingListElement)iter.next()).lockType == 2) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        int lastGrantedIndex() {
            ListIterator iter = this.listIterator(this.size());
            int index = this.size() - 1;
            while (iter.hasPrevious()) {
                if (((WaitingListElement)iter.previous()).granted) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        int findMe() {
            return this.indexOf(new WaitingListElement());
        }
    }
}

