/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.timer;

import com.sap.pj.jmx.timer.NumberGenerator;
import java.util.Date;
import javax.management.timer.Timer;
import javax.management.timer.TimerNotification;

public abstract class AbstractTimerNotificationInfo {
    private final Timer timer;
    private long delay;
    private Date date;
    private final long period;
    private long occurences;
    protected final String type;
    protected final Object source;
    private final NumberGenerator sequenceNumberGenerator;
    protected final String msg;
    protected final Integer id;
    private final Object userData;

    public AbstractTimerNotificationInfo(Timer timer, long delay, Date date, long period, long occurences, String type, NumberGenerator sequenceNumberGenerator, String msg, Integer id, Object userData) {
        this.timer = timer;
        this.delay = delay;
        this.date = date;
        this.period = period;
        this.occurences = occurences;
        this.type = type;
        this.source = timer;
        this.sequenceNumberGenerator = sequenceNumberGenerator;
        this.msg = msg;
        this.id = id;
        this.userData = userData;
    }

    protected final void sendNotification() {
        TimerNotification notification = this.createNotification();
        notification.setSequenceNumber(this.sequenceNumberGenerator.getNextNumber());
        notification.setTimeStamp(this.date.getTime());
        notification.setUserData(this.userData);
        this.timer.sendNotification(notification);
    }

    protected TimerNotification createNotification() {
        return new TimerNotification(this.type, this.source, 0L, 0L, this.msg, this.id);
    }

    public final boolean update(Date now, boolean sendPast) {
        AbstractTimerNotificationInfo abstractTimerNotificationInfo = this;
        synchronized (abstractTimerNotificationInfo) {
            while (now.after(this.date)) {
                if (sendPast) {
                    this.sendNotification();
                }
                if (this.period > 0L && (this.occurences == 0L || this.occurences > 1L)) {
                    this.date.setTime(this.date.getTime() + this.period);
                    this.occurences = Math.max(0L, this.occurences - 1L);
                    continue;
                }
                this.delay = -1L;
                boolean bl = false;
                return bl;
            }
            this.delay = this.date.getTime() - now.getTime();
            boolean bl = true;
            return bl;
        }
    }

    public final Date getDate() {
        return this.date;
    }

    public final long getDelay() {
        return this.delay;
    }

    public final long getPeriod() {
        return this.period;
    }

    public final long getOccurences() {
        return this.occurences;
    }

    public final String getType() {
        return this.type;
    }

    public final String getMessage() {
        return this.msg;
    }

    public final Integer getID() {
        return this.id;
    }

    public final Object getUserData() {
        return this.userData;
    }

    protected String getDisplayName() {
        return "abstract-timer";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ JMX ");
        sb.append(this.getDisplayName());
        sb.append(" |");
        sb.append(" id: ");
        sb.append(this.id);
        sb.append(" date: ");
        sb.append(this.date);
        sb.append(" period: ");
        sb.append(this.period);
        sb.append(" occurences: ");
        sb.append(this.occurences);
        sb.append(" source: ");
        sb.append(this.source == null ? null : this.source.toString());
        sb.append(" type: ");
        sb.append(this.type);
        sb.append(" msg: ");
        sb.append(this.msg);
        sb.append(" ]");
        return sb.toString();
    }
}

