/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.server.interceptor;

import com.sap.pj.jmx.ImplementationException;
import com.sap.pj.jmx.server.interceptor.InnerServerAlreadyExistsException;
import com.sap.pj.jmx.server.interceptor.InvalidInterceptorException;
import com.sap.pj.jmx.server.interceptor.InvocationContext;
import com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor;
import com.sap.pj.jmx.server.interceptor.MBeanServerInterceptorChainMBean;
import com.sap.pj.jmx.server.interceptor.MBeanServerWrapperInterceptor;
import com.sap.pj.jmx.util.rwlock.RWLock;
import com.sap.pj.jmx.util.rwlock.RWLockImpl;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerInterceptorChain
implements MBeanServer,
MBeanServerInterceptorChainMBean {
    private MBeanServer inner = null;
    private LinkedList interceptors = new LinkedList();
    private HashMap interceptorNames = new HashMap();
    private MBeanServerWrapperInterceptor wrapper = null;
    private RWLock lock = new RWLockImpl(true);
    private boolean started = false;
    private final boolean exposeMBeans;
    static /* synthetic */ Class class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor;

    MBeanServerInterceptorChain(boolean exposeMBeans) {
        this.exposeMBeans = exposeMBeans;
    }

    MBeanServer getInner() {
        return this.inner;
    }

    void setInner(MBeanServer inner) throws InnerServerAlreadyExistsException {
        ObjectName wrapperName;
        if (this.inner != null) {
            throw new InnerServerAlreadyExistsException("Inner MBeanServer must be set only once");
        }
        if (this.exposeMBeans) {
            ObjectName chainName;
            try {
                chainName = new ObjectName("JMImplementation:type=MBeanServerInterceptorChain");
            }
            catch (Exception e) {
                throw new ImplementationException("Invalid ObjectName for InterceptorChain");
            }
            try {
                inner.registerMBean(this, chainName);
            }
            catch (Exception e) {
                throw new ImplementationException("InterceptorChain can not be registered as MBean");
            }
        }
        this.inner = inner;
        try {
            wrapperName = new ObjectName("JMImplementation:type=MBeanServerWrapperInterceptor");
        }
        catch (Exception e) {
            throw new ImplementationException("Invalid ObjectName for MBeanServerWrapper");
        }
        this.wrapper = new MBeanServerWrapperInterceptor(inner);
        try {
            this.addInterceptor(this.wrapper, wrapperName);
        }
        catch (Exception e) {
            throw new ImplementationException("MBeanServerWrapper can not be registered as Interceptor");
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        InvocationContext context = null;
        this.getFirstInterceptor().removeNotificationListener(context, name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        InvocationContext context = null;
        this.getFirstInterceptor().removeNotificationListener(context, name, listener, filter, handback);
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        InvocationContext context = null;
        return this.getFirstInterceptor().getAttribute(context, name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        InvocationContext context = null;
        AttributeList al = this.getFirstInterceptor().getAttributes(context, name, attributes);
        return al;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        InvocationContext context = null;
        return this.getFirstInterceptor().instantiate(context, className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().instantiate(context, className, loaderName);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        InvocationContext context = null;
        return this.getFirstInterceptor().instantiate(context, className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().instantiate(context, className, loaderName, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        InvocationContext context = null;
        return this.getFirstInterceptor().createMBean(context, className, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().createMBean(context, className, name, loaderName);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        InvocationContext context = null;
        return this.getFirstInterceptor().createMBean(context, className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().createMBean(context, className, name, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        InvocationContext context = null;
        return this.getFirstInterceptor().registerMBean(context, object, name);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        InvocationContext context = null;
        this.getFirstInterceptor().unregisterMBean(context, name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().getObjectInstance(context, name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        InvocationContext context = null;
        return this.getFirstInterceptor().queryMBeans(context, name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        InvocationContext context = null;
        return this.getFirstInterceptor().queryNames(context, name, query);
    }

    public boolean isRegistered(ObjectName name) {
        InvocationContext context = null;
        return this.getFirstInterceptor().isRegistered(context, name);
    }

    public Integer getMBeanCount() {
        InvocationContext context = null;
        return this.getFirstInterceptor().getMBeanCount(context);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        InvocationContext context = null;
        this.getFirstInterceptor().setAttribute(context, name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        InvocationContext context = null;
        return this.getFirstInterceptor().setAttributes(context, name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        InvocationContext context = null;
        return this.getFirstInterceptor().invoke(context, name, operationName, params, signature);
    }

    public String getDefaultDomain() {
        InvocationContext context = null;
        return this.getFirstInterceptor().getDefaultDomain(context);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        InvocationContext context = null;
        this.getFirstInterceptor().addNotificationListener(context, name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        InvocationContext context = null;
        this.getFirstInterceptor().addNotificationListener(context, name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        InvocationContext context = null;
        this.getFirstInterceptor().removeNotificationListener(context, name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        InvocationContext context = null;
        this.getFirstInterceptor().removeNotificationListener(context, name, listener);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        InvocationContext context = null;
        return this.getFirstInterceptor().getMBeanInfo(context, name);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().isInstanceOf(context, name, className);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        InvocationContext context = null;
        return this.getFirstInterceptor().deserialize(context, name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        InvocationContext context = null;
        return this.getFirstInterceptor().deserialize(context, className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        InvocationContext context = null;
        return this.getFirstInterceptor().deserialize(context, className, loaderName, data);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().getClassLoader(context, loaderName);
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        InvocationContext context = null;
        return this.getFirstInterceptor().getClassLoaderFor(context, name);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        InvocationContext context = null;
        return this.getFirstInterceptor().getClassLoaderRepository(context);
    }

    public String[] getDomains() {
        return this.inner.getDomains();
    }

    public void start() {
        if (this.wrapper == null) {
            throw new IllegalArgumentException("Interceptor chain has not been initialized.");
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public void addInterceptor(MBeanServerInterceptor interceptorObject, ObjectName interceptorName) throws InstanceAlreadyExistsException, NotCompliantMBeanException, InvalidInterceptorException, MBeanRegistrationException {
        if (interceptorName == null) {
            throw new InvalidInterceptorException("Interceptor must not be null");
        }
        if (this.exposeMBeans) {
            this.inner.registerMBean(interceptorObject, interceptorName);
        }
        this.addInterceptor(interceptorObject);
        this.interceptorNames.put(interceptorName, interceptorObject);
    }

    public void addInterceptor(MBeanServerInterceptor interceptorObject) throws InstanceAlreadyExistsException {
        MBeanServerInterceptor nextInterceptor = null;
        LinkedList linkedList = this.interceptors;
        synchronized (linkedList) {
            if (this.interceptors.contains(interceptorObject)) {
                throw new InstanceAlreadyExistsException("Already registered as interceptor");
            }
            if (this.interceptors.size() > 0) {
                nextInterceptor = (MBeanServerInterceptor)this.interceptors.getFirst();
            }
        }
        interceptorObject.setNext(nextInterceptor);
        this.interceptors.addFirst(interceptorObject);
    }

    public void removeInterceptor(ObjectName interceptorName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.exposeMBeans && !this.inner.isRegistered(interceptorName)) {
            throw new InstanceNotFoundException("Not a registered MBean: " + interceptorName);
        }
        MBeanServerInterceptor interceptorObject = (MBeanServerInterceptor)this.interceptorNames.get(interceptorName);
        if (interceptorObject == null) {
            throw new InstanceNotFoundException("Not a registered interceptor: " + interceptorName);
        }
        this.removeInterceptor(interceptorObject);
        if (this.exposeMBeans) {
            this.inner.unregisterMBean(interceptorName);
        }
        this.interceptorNames.remove(interceptorName);
    }

    public void removeInterceptor(MBeanServerInterceptor interceptorObject) throws InstanceNotFoundException {
        LinkedList linkedList = this.interceptors;
        synchronized (linkedList) {
            if (!this.interceptors.contains(interceptorObject)) {
                throw new InstanceNotFoundException("Not a registered interceptor");
            }
            int idx = this.interceptors.indexOf(interceptorObject);
            ListIterator iter = this.interceptors.listIterator(idx);
            if (iter.hasPrevious()) {
                MBeanServerInterceptor previous = null;
                MBeanServerInterceptor next = null;
                previous = (MBeanServerInterceptor)iter.previous();
                if (iter.hasNext()) {
                    next = (MBeanServerInterceptor)iter.next();
                }
                previous.setNext(next);
            }
            this.interceptors.remove(idx);
        }
    }

    private MBeanServerInterceptor getFirstInterceptor() {
        if (this.started) {
            LinkedList linkedList = this.interceptors;
            synchronized (linkedList) {
                MBeanServerInterceptor mBeanServerInterceptor = (MBeanServerInterceptor)this.interceptors.getFirst();
                return mBeanServerInterceptor;
            }
        }
        return this.wrapper;
    }

    public void createInterceptor(String className, ObjectName interceptorName) throws InvalidInterceptorException, MBeanException, InstanceAlreadyExistsException, ReflectionException, NotCompliantMBeanException {
        if (this.exposeMBeans && this.inner.isRegistered(interceptorName)) {
            throw new InstanceAlreadyExistsException("Already registered as a MBean: " + interceptorName);
        }
        Object object = this.inner.instantiate(className);
        if (object == null || !(class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor == null ? (class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor = MBeanServerInterceptorChain.class$("com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor")) : class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor).isAssignableFrom(object.getClass())) {
            throw new InvalidInterceptorException("Not a valid interceptor: " + className);
        }
        MBeanServerInterceptor interceptorObject = (MBeanServerInterceptor)object;
        this.addInterceptor(interceptorObject, interceptorName);
    }

    public void createInterceptor(String className, ObjectName interceptorName, ObjectName loaderName) throws InvalidInterceptorException, MBeanException, InstanceAlreadyExistsException, ReflectionException, NotCompliantMBeanException, InstanceNotFoundException {
        if (this.exposeMBeans && this.inner.isRegistered(interceptorName)) {
            throw new InstanceAlreadyExistsException("Already registered as a MBean: " + interceptorName);
        }
        Object object = this.inner.instantiate(className, loaderName);
        if (object == null || !(class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor == null ? (class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor = MBeanServerInterceptorChain.class$("com.sap.pj.jmx.server.interceptor.MBeanServerInterceptor")) : class$com$sap$pj$jmx$server$interceptor$MBeanServerInterceptor).isAssignableFrom(object.getClass())) {
            throw new InvalidInterceptorException("Not a valid interceptor: " + className);
        }
        MBeanServerInterceptor interceptorObject = (MBeanServerInterceptor)object;
        this.addInterceptor(interceptorObject, interceptorName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

