/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.server.interceptor;

import com.sap.pj.jmx.mbeanserver.GetPropertyAction;
import com.sap.pj.jmx.server.MBeanServerImpl;
import com.sap.pj.jmx.server.interceptor.MBeanServerInterceptorChain;
import java.security.AccessController;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;

public class InterceptorChainBuilder
extends MBeanServerBuilder {
    private final boolean securityCheck;
    private final boolean exposeMBeans;

    public InterceptorChainBuilder(boolean securityCheck, boolean exposeMBeans) {
        this.securityCheck = securityCheck;
        this.exposeMBeans = exposeMBeans;
    }

    public InterceptorChainBuilder(boolean securityCheck) {
        this.securityCheck = securityCheck;
        this.exposeMBeans = true;
    }

    public InterceptorChainBuilder() {
        this.securityCheck = true;
        GetPropertyAction act = new GetPropertyAction("com.sap.pj.jmx.ExposeInterceptors");
        String exposeInterceptors = (String)AccessController.doPrivileged(act);
        this.exposeMBeans = "true".equalsIgnoreCase(exposeInterceptors);
    }

    public MBeanServerDelegate newMBeanServerDelegate() {
        return new MBeanServerDelegate();
    }

    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        if (outer == null) {
            outer = new MBeanServerInterceptorChain(this.exposeMBeans);
        }
        if (outer instanceof MBeanServerInterceptorChain) {
            MBeanServerImpl inner = new MBeanServerImpl(defaultDomain, outer, delegate, this.securityCheck);
            ((MBeanServerInterceptorChain)outer).setInner(inner);
        }
        return outer;
    }
}

