/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.server;

import com.sap.pj.jmx.ImplementationException;
import com.sap.pj.jmx.PropertyManager;
import com.sap.pj.jmx.introspect.LoaderWrapper;
import com.sap.pj.jmx.introspect.MBeanData;
import com.sap.pj.jmx.introspect.StandardMBeanWrapper;
import com.sap.pj.jmx.introspect.Utilities;
import com.sap.pj.jmx.loading.LoaderObjectInputStream;
import com.sap.pj.jmx.mbeanserver.ClassLoaderRepositorySupport;
import com.sap.pj.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sap.pj.jmx.mbeanserver.Repository;
import com.sap.pj.jmx.mbeanserver.RepositorySupport;
import com.sap.pj.jmx.mbeanserver.SecureClassLoaderRepository;
import com.sap.pj.jmx.server.MBeanServerDelegateWrapper;
import com.sap.pj.jmx.server.MBeanServerManagement;
import com.sap.pj.jmx.server.ProxyListener;
import com.sap.pj.jmx.server.ProxyListenerFactory;
import com.sap.pj.jmx.server.SynchronousProxyListenerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.PrivateClassLoader;

public class MBeanServerImpl
implements MBeanServer {
    private static final String[] ALLOWED_JM_IMPLEMENTATION_NAMES = new String[]{"JMImplementation:type=MBeanServerDelegate", "JMImplementation:type=MBeanServerInterceptorChain".intern(), "JMImplementation:type=MBeanServerWrapperInterceptor".intern()};
    private MBeanServerDelegate serverDelegate;
    private MBeanServerManagement serverManagement;
    private ObjectName serverDelegateName;
    private final Repository repository;
    private final boolean queryByRepo = false;
    private final Map listenerRepository;
    private long notificationSeqNum;
    private final ProxyListenerFactory proxyListenerFactory;
    private final ModifiableClassLoaderRepository classLoaderRep;
    private final ClassLoaderRepository secureClassLoaderRep;
    private final MBeanServer outerServer;
    private final boolean securityCheck;
    static /* synthetic */ Class class$com$sap$pj$jmx$server$ProxyListenerFactory;
    static /* synthetic */ Class class$com$sap$pj$jmx$server$MBeanServerImpl;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;
    static /* synthetic */ Class class$javax$management$NotificationListener;
    static /* synthetic */ Class class$javax$management$NotificationEmitter;

    public MBeanServerImpl() {
        this(PropertyManager.getDefaultDomain(), null, null, true);
    }

    public MBeanServerImpl(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate, boolean doSecurityChecks) {
        ProxyListenerFactory listFac;
        this.securityCheck = doSecurityChecks;
        String defDomain = defaultDomain == null || defaultDomain.equals("") ? PropertyManager.getDefaultDomain() : defaultDomain;
        this.outerServer = outer == null ? this : outer;
        this.repository = new RepositorySupport(defDomain);
        this.listenerRepository = new WeakHashMap();
        this.classLoaderRep = new ClassLoaderRepositorySupport();
        this.secureClassLoaderRep = new SecureClassLoaderRepository(this.classLoaderRep);
        ClassLoader thisLoader = this.getClass().getClassLoader();
        if (thisLoader != null) {
            this.classLoaderRep.addClassLoader(thisLoader);
        }
        this.classLoaderRep.addClassLoader(ClassLoader.getSystemClassLoader());
        try {
            listFac = (ProxyListenerFactory)MBeanServerImpl.createInstanceForClassName(PropertyManager.getProxyListenerFactoryClass(), class$com$sap$pj$jmx$server$ProxyListenerFactory == null ? (class$com$sap$pj$jmx$server$ProxyListenerFactory = MBeanServerImpl.class$("com.sap.pj.jmx.server.ProxyListenerFactory")) : class$com$sap$pj$jmx$server$ProxyListenerFactory);
        }
        catch (Exception e) {
            listFac = new SynchronousProxyListenerFactory();
        }
        this.proxyListenerFactory = listFac;
        this.notificationSeqNum = 0L;
        this.serverDelegate = delegate == null ? new MBeanServerManagement() : delegate;
        this.serverManagement = this.serverDelegate instanceof MBeanServerManagement ? (MBeanServerManagement)this.serverDelegate : new MBeanServerManagement();
        this.serverManagement.setServerImpl(this);
        try {
            this.serverDelegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.registerMBeanInternal(new MBeanServerDelegateWrapper(this.serverDelegate), this.serverDelegateName, false);
        }
        catch (Exception e) {
            throw new ImplementationException("MBeanServerDelegate could not be registered.");
        }
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        try {
            return this.instantiateInternal(className, null, null);
        }
        catch (NotCompliantMBeanException e) {
            throw new MBeanException(e);
        }
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            return this.instantiateInternal(className, loaderName, null, null);
        }
        catch (NotCompliantMBeanException e) {
            throw new MBeanException(e);
        }
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        try {
            return this.instantiateInternal(className, params, signature);
        }
        catch (NotCompliantMBeanException e) {
            throw new MBeanException(e);
        }
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        try {
            return this.instantiateInternal(className, loaderName, params, signature);
        }
        catch (NotCompliantMBeanException e) {
            throw new MBeanException(e);
        }
    }

    private Object instantiateInternal(String className, Object[] params, String[] signature) throws NotCompliantMBeanException, ReflectionException, MBeanException {
        this.checkMBeanPermission(className, null, null, "instantiate");
        LoaderWrapper loaderWrapper = new LoaderWrapper(){

            public Class loadClass(String clName) throws ClassNotFoundException {
                return MBeanServerImpl.this.classLoaderRep.loadClass(clName);
            }
        };
        return this.instantiate(className, loaderWrapper, params, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object instantiateInternal(String className, ObjectName loaderName, Object[] params, String[] signature) throws InstanceNotFoundException, NotCompliantMBeanException, ReflectionException, MBeanException {
        ClassLoader loader;
        this.checkMBeanPermission(className, null, null, "instantiate");
        if (loaderName != null) {
            MBeanData data;
            Repository repository = this.repository;
            synchronized (repository) {
                data = this.repository.retrieve(loaderName);
            }
            if (data == null) {
                throw new InstanceNotFoundException(loaderName + " not in repository");
            }
            if (!(data.registeredObject instanceof ClassLoader)) throw new InstanceNotFoundException(loaderName + " not a class loader");
            loader = (ClassLoader)data.registeredObject;
        } else {
            loader = (class$com$sap$pj$jmx$server$MBeanServerImpl == null ? (class$com$sap$pj$jmx$server$MBeanServerImpl = MBeanServerImpl.class$("com.sap.pj.jmx.server.MBeanServerImpl")) : class$com$sap$pj$jmx$server$MBeanServerImpl).getClassLoader();
        }
        LoaderWrapper loaderWrapper = new LoaderWrapper(){

            public Class loadClass(String clName) throws ClassNotFoundException {
                return loader.loadClass(clName);
            }
        };
        return this.instantiate(className, loaderWrapper, params, signature);
    }

    private Object instantiate(String className, LoaderWrapper loaderWrapper, Object[] params, String[] signature) throws ReflectionException, MBeanException, NotCompliantMBeanException {
        Object object = null;
        if (params == null) {
            params = new Object[]{};
        }
        if (signature == null) {
            signature = new String[]{};
        }
        try {
            Class clazz = loaderWrapper.loadClass(className);
            if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
                throw new NotCompliantMBeanException("The MBean must have a concrete class in order to be created remotely.");
            }
            Constructor<?>[] consList = clazz.getConstructors();
            if (consList.length == 0) {
                throw new ReflectionException(new JMException("The MBean must have a public constructor in order to be created remotely"));
            }
            Constructor constr = clazz.getConstructor(Utilities.convertSignature(signature, loaderWrapper));
            object = constr.newInstance(params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)targetException, "RuntimeException in the constructor of object " + className);
            }
            if (targetException instanceof Error) {
                throw new RuntimeErrorException((Error)targetException, "Error in the constructor of object " + className);
            }
            if (targetException instanceof Exception) {
                throw new MBeanException((Exception)targetException, "Exception in the constructor of object " + className);
            }
            throw new ReflectionException(e, "InvocationTargetException in the constructor of object " + className + ", nested exception " + targetException.getClass().getName());
        }
        return object;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(className, name, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(className, name, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        Object object = this.instantiateInternal(className, params, signature);
        return this.registerMBean(object, name);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Object object = this.instantiateInternal(className, loaderName, params, signature);
        return this.registerMBean(object, name);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.registerMBeanInternal(object, name, true);
    }

    public ObjectInstance registerMBeanInternal(Object object, ObjectName name, boolean checkPermission) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        boolean isMBeanRegistration;
        DynamicMBean dynamicMBean;
        String dom;
        if (object == null) {
            throw new NotCompliantMBeanException("MBean must not be null");
        }
        if (name != null && name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName must be no pattern"));
        }
        String string = dom = (name = this.normalizedObjectName(name)) == null ? "" : name.getDomain();
        if (dom.length() > 0 && dom.equals("JMImplementation")) {
            String internalName = name.getCanonicalName().intern();
            boolean allowed = false;
            int i = 0;
            while (i < ALLOWED_JM_IMPLEMENTATION_NAMES.length) {
                if (internalName == ALLOWED_JM_IMPLEMENTATION_NAMES[i]) {
                    allowed = true;
                    break;
                }
                ++i;
            }
            if (!allowed) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Domain name cannot be JMImplementation"));
            }
        }
        try {
            dynamicMBean = object instanceof DynamicMBean ? (DynamicMBean)object : new StandardMBeanWrapper(object);
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "Runtime exception during compliance check");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error during compliance check");
        }
        if (checkPermission) {
            this.checkMBeanPermission(MBeanData.getClassNameFromMBeanInfo(dynamicMBean), null, name, "registerMBean");
            this.checkMBeanTrustPermission(object.getClass());
        }
        if (isMBeanRegistration = object instanceof MBeanRegistration) {
            ObjectName on = this.invokePreRegister(object, name);
            if (name == null) {
                if (checkPermission) {
                    this.checkMBeanPermission(MBeanData.getClassNameFromMBeanInfo(dynamicMBean), null, on, "registerMBean");
                }
                name = this.normalizedObjectName(on);
            }
        }
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName neither provided at registration nor at preRegister()"));
        }
        MBeanData data = new MBeanData(name, object, dynamicMBean, isMBeanRegistration);
        Repository repository = this.repository;
        synchronized (repository) {
            try {
                this.repository.addMBean(data);
                if (object instanceof ClassLoader && !(object instanceof PrivateClassLoader)) {
                    this.classLoaderRep.addClassLoader((ClassLoader)object);
                }
            }
            catch (InstanceAlreadyExistsException e) {
                if (isMBeanRegistration) {
                    this.invokePostRegister(object, false);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (isMBeanRegistration) {
                    this.invokePostRegister(object, false);
                }
                throw new RuntimeOperationsException(e, "RuntimeException while trying to put the MBean to the repository");
            }
            catch (Error e) {
                if (isMBeanRegistration) {
                    this.invokePostRegister(object, false);
                }
                throw new RuntimeErrorException(e, "Error while trying to put the MBean to the repository");
            }
        }
        if (isMBeanRegistration) {
            this.invokePostRegister(object, true);
        }
        this.notify(name, "JMX.mbean.registered");
        return data.getObjectInstance();
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanData data;
        if (name == null || name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName must not be null or pattern"));
        }
        if (name.getDomain().equals(this.serverDelegateName.getDomain())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Can not unregister MBeanServerDelegate"));
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
            if (data == null) {
                throw new InstanceNotFoundException("MBean with name " + name + " not found in repository");
            }
            this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "unregisterMBean");
            if (data.registration) {
                this.invokePreDeregister(data.registeredObject);
            }
            try {
                this.repository.remove(name);
                if (data.registeredObject instanceof ClassLoader) {
                    this.classLoaderRep.removeClassLoader((ClassLoader)data.registeredObject);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeOperationsException(e, "RuntimeException while trying to remove the MBean from the repository");
            }
            catch (Error e) {
                throw new RuntimeErrorException(e, "Error while trying to remove the MBean from the repository");
            }
        }
        if (data.registration) {
            this.invokePostDeregister(data.registeredObject);
        }
        this.notify(name, "JMX.mbean.unregistered");
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        MBeanData data;
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "getObjectInstance");
        return data.getObjectInstance();
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        SecurityManager sm = this.getSecurityManager();
        if (sm != null) {
            this.checkMBeanPermission(null, null, null, "queryMBeans");
            Set list = this.queryMBeansImpl(name, null);
            HashSet<ObjectInstance> allowedList = new HashSet<ObjectInstance>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                try {
                    ObjectInstance oi = (ObjectInstance)i.next();
                    this.checkMBeanPermission(oi.getClassName(), null, oi.getObjectName(), "queryMBeans");
                    allowedList.add(oi);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            return this.filterListOfObjectInstances(allowedList, query);
        }
        return this.queryMBeansImpl(name, query);
    }

    private Set queryMBeansImpl(ObjectName name, QueryExp query) {
        Set list = null;
        Repository repository = this.repository;
        synchronized (repository) {
            list = this.repository.query(name, query);
        }
        return this.filterListOfObjects(list, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMBeanPermission(null, null, null, "queryNames");
            Set list = this.queryMBeansImpl(name, null);
            HashSet<ObjectInstance> allowedList = new HashSet<ObjectInstance>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                try {
                    ObjectInstance oi = (ObjectInstance)i.next();
                    this.checkMBeanPermission(oi.getClassName(), null, oi.getObjectName(), "queryNames");
                    allowedList.add(oi);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
            Set queryList = this.filterListOfObjectInstances(allowedList, query);
            HashSet<ObjectName> result = new HashSet<ObjectName>(queryList.size());
            Iterator i2 = queryList.iterator();
            while (i2.hasNext()) {
                ObjectInstance oi = (ObjectInstance)i2.next();
                result.add(oi.getObjectName());
            }
            return result;
        }
        Set queryList = this.queryMBeansImpl(name, query);
        HashSet<ObjectName> result = new HashSet<ObjectName>(queryList.size());
        Iterator i = queryList.iterator();
        while (i.hasNext()) {
            ObjectInstance oi = (ObjectInstance)i.next();
            result.add(oi.getObjectName());
        }
        return result;
    }

    public boolean isRegistered(ObjectName name) {
        Repository repository = this.repository;
        synchronized (repository) {
            boolean bl = this.repository.contains(name);
            return bl;
        }
    }

    public Integer getMBeanCount() {
        return new Integer(this.repository.getCount());
    }

    int getMBeanRepositorySize() {
        return this.repository.getCount();
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MBeanData data;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name must not be null"));
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name must not be null"));
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), attribute.getName(), name, "setAttribute");
        try {
            data.dynamicMBean.setAttribute(attribute);
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the setAttribute method for the attribute " + attribute);
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error thrown by the setAttribute method for the attribute " + attribute);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanData data;
        AttributeList returnList = null;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name must not be null"));
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute list must not be null"));
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "setAttribute");
        Iterator iter = ((AbstractList)attributes).iterator();
        while (iter.hasNext()) {
            try {
                this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), ((Attribute)iter.next()).getName(), name, "setAttribute");
            }
            catch (SecurityException e) {
                iter.remove();
            }
        }
        try {
            returnList = data.dynamicMBean.setAttributes(attributes);
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the setAttributes method");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error thrown by the setAttributes method");
        }
        return returnList;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        MBeanData data;
        Object object = null;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name must not be null"));
        }
        if (operationName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Operation name must not be null"));
        }
        if (params == null) {
            params = new Object[]{};
        }
        if (signature == null) {
            signature = new String[]{};
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), operationName, name, "invoke");
        try {
            object = data.dynamicMBean.invoke(operationName, params, signature);
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the invoke method");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error thrown by the invoke method");
        }
        return object;
    }

    public String getDefaultDomain() {
        return this.repository.getDefaultDomain();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanData data;
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Listener must not be null"));
        }
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName must not be null"));
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "addNotificationListener");
        if (!(data.registeredObject instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(name + " does not implement " + (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = MBeanServerImpl.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName()));
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)data.registeredObject;
        NotificationListener proxyListener = this.getProxyListener(listener, broadcaster, name, true);
        broadcaster.addNotificationListener(proxyListener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        MBeanData data;
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(listener);
        }
        if (data == null) {
            throw new InstanceNotFoundException(listener + " not in repository");
        }
        if (!(data.registeredObject instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(listener + " does not implement " + (class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = MBeanServerImpl.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener).getName()));
        }
        this.addNotificationListener(name, (NotificationListener)data.registeredObject, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanData data;
        if (listener == null) {
            throw new ListenerNotFoundException("listener must not be null listener must not be null");
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "removeNotificationListener");
        if (!(data.registeredObject instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(name + " does not implement " + (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = MBeanServerImpl.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName()));
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)data.registeredObject;
        NotificationListener proxyListener = this.getProxyListener(listener, broadcaster, name, false);
        if (proxyListener == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        broadcaster.removeNotificationListener(proxyListener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanData data;
        if (listener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("listener must not be null"), "listener must not be null");
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "removeNotificationListener");
        if (!(data.registeredObject instanceof NotificationEmitter)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(name + " does not implement " + (class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = MBeanServerImpl.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter).getName()));
        }
        NotificationEmitter emitter = (NotificationEmitter)data.registeredObject;
        NotificationListener proxyListener = this.getProxyListener(listener, emitter, name, false);
        if (proxyListener == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        emitter.removeNotificationListener(proxyListener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanData data;
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(listener);
        }
        if (data == null) {
            throw new InstanceNotFoundException(listener + " not in repository");
        }
        if (!(data.registeredObject instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(listener + " does not implement " + (class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = MBeanServerImpl.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener).getName()));
        }
        this.removeNotificationListener(name, (NotificationListener)data.registeredObject);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        MBeanData data;
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(listener);
        }
        if (data == null) {
            throw new InstanceNotFoundException(listener + " not in repository");
        }
        if (!(data.registeredObject instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(listener + " does not implement " + (class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = MBeanServerImpl.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener).getName()));
        }
        this.removeNotificationListener(name, (NotificationListener)data.registeredObject, filter, handback);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo mbeanInfo;
        MBeanData data;
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "getMBeanInfo");
        try {
            mbeanInfo = data.dynamicMBean.getMBeanInfo();
        }
        catch (RuntimeException e) {
            throw new ReflectionException(e, "Exception during invocation of getMBeanInfo of a dynamic MBean");
        }
        if (mbeanInfo == null) {
            throw new JMRuntimeException("Invocation of getMBeanInfo of a dynamic MBean returned null");
        }
        return mbeanInfo;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        MBeanData data;
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "isInstanceOf");
        String mbeanClassName = data.getClassNameFromMBeanInfo();
        if (mbeanClassName.equals(className)) {
            return true;
        }
        try {
            ClassLoader loader = data.getClassLoader();
            Class<?> testClass = loader.loadClass(className);
            Class<?> mbeanClass = loader.loadClass(mbeanClassName);
            return testClass.isAssignableFrom(mbeanClass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private ObjectInputStream deserialize(byte[] byteArr, LoaderWrapper classLoader) throws OperationsException {
        ByteArrayInputStream baiStream = new ByteArrayInputStream(byteArr);
        LoaderObjectInputStream oiStream = null;
        try {
            oiStream = new LoaderObjectInputStream(baiStream, classLoader);
        }
        catch (IOException e) {
            throw new OperationsException("IOException while creating an ObjectInputStream");
        }
        return oiStream;
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] byteArr) throws InstanceNotFoundException, OperationsException {
        if (byteArr == null || byteArr.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Byte array must not be empty");
        }
        ClassLoader cl = this.getClassLoaderFor(name);
        return this.deserialize(byteArr, new LoaderWrapper(cl){
            final ClassLoader loader;
            private final /* synthetic */ ClassLoader val$cl;
            {
                this.loader = this.val$cl = val$cl;
            }

            public Class loadClass(String clName) throws ClassNotFoundException {
                return this.loader.loadClass(clName);
            }
        });
    }

    public ObjectInputStream deserialize(String className, byte[] byteArr) throws OperationsException, ReflectionException {
        if (byteArr == null || byteArr.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Byte array must not be empty");
        }
        if (className == null || className.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name must not be empty"));
        }
        return this.deserialize(byteArr, new LoaderWrapper(){
            final ClassLoaderRepository clr;
            {
                this.clr = MBeanServerImpl.this.getClassLoaderRepository();
            }

            public Class loadClass(String name) throws ClassNotFoundException {
                return this.clr.loadClass(name);
            }
        });
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] byteArr) throws InstanceNotFoundException, OperationsException, ReflectionException {
        if (loaderName == null) {
            return this.deserialize(className, byteArr);
        }
        if (byteArr == null || byteArr.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Byte array must not be empty");
        }
        if (className == null || className.equals("")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Class name must not be empty"));
        }
        ClassLoader cl = this.getClassLoader(loaderName);
        return this.deserialize(byteArr, new LoaderWrapper(cl){
            final ClassLoader loader;
            private final /* synthetic */ ClassLoader val$cl;
            {
                this.loader = this.val$cl = val$cl;
            }

            public Class loadClass(String name) throws ClassNotFoundException {
                return this.loader.loadClass(name);
            }
        });
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        MBeanData data;
        Object object = null;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name must not be null"));
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name must not be null"));
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), attribute, name, "getAttribute");
        try {
            object = data.dynamicMBean.getAttribute(attribute);
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the getAttribute method for the attribute " + attribute);
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error thrown by the getAttribute method for the attribute " + attribute);
        }
        return object;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        MBeanData data;
        AttributeList returnList = null;
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name must not be null"));
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute array must not be null"));
        }
        Repository repository = this.repository;
        synchronized (repository) {
            data = this.repository.retrieve(name);
        }
        if (data == null) {
            throw new InstanceNotFoundException(name + " not in repository");
        }
        this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "getAttribute");
        try {
            returnList = data.dynamicMBean.getAttributes(attributes);
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the getAttributes method");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error thrown by the getAttribute method");
        }
        Iterator iter = ((AbstractList)returnList).iterator();
        while (iter.hasNext()) {
            try {
                this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), ((Attribute)iter.next()).getName(), name, "getAttribute");
            }
            catch (SecurityException e) {
                iter.remove();
            }
        }
        return returnList;
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        if (loaderName == null) {
            this.checkMBeanPermission(null, null, null, "getClassLoader");
            return this.outerServer.getClass().getClassLoader();
        }
        if (loaderName.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName must not be a pattern"));
        }
        MBeanData data = null;
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                data = this.repository.retrieve(loaderName);
            }
            if (data == null) {
                throw new InstanceNotFoundException("ClassLoader with name " + loaderName + " not found in repository");
            }
            this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, loaderName, "getClassLoader");
            if (data.registeredObject instanceof ClassLoader) {
                return (ClassLoader)data.registeredObject;
            }
            throw new InstanceNotFoundException(loaderName + " not a class loader");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error while trying to get data from the repository");
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws InstanceNotFoundException {
        if (name == null || name.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName must not be null or pattern"));
        }
        MBeanData data = null;
        try {
            Repository repository = this.repository;
            synchronized (repository) {
                data = this.repository.retrieve(name);
            }
            if (data == null) {
                throw new InstanceNotFoundException("MBean with name " + name + " not found in repository");
            }
            this.checkMBeanPermission(data.getClassNameFromMBeanInfo(), null, name, "getClassLoaderFor");
            return data.getClassLoader();
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error while trying to get data from the repository");
        }
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkMBeanPermission(null, null, null, "getClassLoaderRepository");
        return this.secureClassLoaderRep;
    }

    public String[] getDomains() {
        String[] allowedDomains;
        this.checkMBeanPermission(null, null, null, "getDomains");
        String[] domains = this.repository.getDomains();
        int len = domains.length;
        int i = 0;
        while (i < domains.length) {
            try {
                this.checkMBeanPermission(null, null, new ObjectName(domains[i] + ":x=x"), "getDomains");
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeOperationsException(new ImplementationException("MalformedObjectNameException occured: " + e.getMessage()));
            }
            catch (SecurityException e) {
                domains[i] = null;
                --len;
            }
            ++i;
        }
        if (len == domains.length) {
            allowedDomains = domains;
        } else {
            int j = 0;
            allowedDomains = new String[len];
            int i2 = 0;
            while (i2 < domains.length) {
                if (domains[i2] != null) {
                    allowedDomains[j++] = domains[i2];
                }
                ++i2;
            }
        }
        return allowedDomains;
    }

    private void notify(ObjectName objectName, String notificationType) {
        long sequenceNumber = 0L;
        Class clazz = class$com$sap$pj$jmx$server$MBeanServerImpl == null ? (class$com$sap$pj$jmx$server$MBeanServerImpl = MBeanServerImpl.class$("com.sap.pj.jmx.server.MBeanServerImpl")) : class$com$sap$pj$jmx$server$MBeanServerImpl;
        synchronized (clazz) {
            sequenceNumber = this.notificationSeqNum++;
        }
        try {
            this.serverDelegate.sendNotification(new MBeanServerNotification(notificationType, (Object)this.serverDelegateName, sequenceNumber, objectName));
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException while trying to send notification");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error while trying to send notification");
        }
    }

    private ObjectName invokePreRegister(Object object, ObjectName name) throws MBeanRegistrationException {
        ObjectName newName = null;
        try {
            newName = ((MBeanRegistration)object).preRegister(this.outerServer, name);
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException from MBeanRegistration");
        }
        catch (Exception e) {
            throw new MBeanRegistrationException(e, "Exception from MBeanRegistration");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error from MBeanRegistration");
        }
        return name == null ? newName : name;
    }

    private void invokePreDeregister(Object object) throws MBeanRegistrationException {
        try {
            ((MBeanRegistration)object).preDeregister();
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException from preDeregister");
        }
        catch (Exception e) {
            throw new MBeanRegistrationException(e, "Exception from preDeregister");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error from MBeanRegistration");
        }
    }

    private void invokePostRegister(Object object, boolean isReg) {
        try {
            ((MBeanRegistration)object).postRegister(new Boolean(isReg));
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException from MBeanRegistration");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error from MBeanRegistration");
        }
    }

    private void invokePostDeregister(Object object) {
        try {
            ((MBeanRegistration)object).postDeregister();
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException from MBeanRegistration");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error from MBeanRegistration");
        }
    }

    private ObjectName normalizedObjectName(ObjectName name) {
        if (name == null) {
            return name;
        }
        if (name.getDomain().length() > 0) {
            return name;
        }
        ObjectName on = null;
        try {
            on = new ObjectName(this.repository.getDefaultDomain(), name.getKeyPropertyList());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return on;
    }

    private NotificationListener getProxyListener(NotificationListener listener, NotificationBroadcaster mbean, ObjectName name, boolean create) {
        ProxyListener key = this.proxyListenerFactory.createListener(listener, mbean, name);
        Map map = this.listenerRepository;
        synchronized (map) {
            WeakReference ref = (WeakReference)this.listenerRepository.get(key);
            NotificationListener proxy = ref != null ? (NotificationListener)ref.get() : null;
            if (proxy == null && create) {
                proxy = key;
                this.listenerRepository.put(key, new WeakReference<NotificationListener>(proxy));
            }
            NotificationListener notificationListener = proxy;
            return notificationListener;
        }
    }

    private static Object createInstanceForClassName(String className, Class intf) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = (class$com$sap$pj$jmx$server$MBeanServerImpl == null ? (class$com$sap$pj$jmx$server$MBeanServerImpl = MBeanServerImpl.class$("com.sap.pj.jmx.server.MBeanServerImpl")) : class$com$sap$pj$jmx$server$MBeanServerImpl).getClassLoader().loadClass(className);
        }
        if (clazz != null && intf.isAssignableFrom(clazz)) {
            return clazz.newInstance();
        }
        throw new IllegalStateException("Unable to load class: " + className);
    }

    private Set filterListOfObjects(Set list, QueryExp query) {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        if (query == null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                MBeanData data = (MBeanData)i.next();
                result.add(new ObjectInstance(data.objectName, data.getClassNameFromMBeanInfo()));
            }
        } else {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object var10_11;
                MBeanData data = (MBeanData)i.next();
                boolean res = false;
                MBeanServer oldServer = QueryEval.getMBeanServer();
                query.setMBeanServer(this.outerServer);
                try {
                    try {
                        res = query.apply(data.objectName);
                    }
                    catch (Exception e) {
                        res = false;
                        var10_11 = null;
                        query.setMBeanServer(oldServer);
                    }
                    var10_11 = null;
                    query.setMBeanServer(oldServer);
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    query.setMBeanServer(oldServer);
                    throw throwable;
                }
                if (!res) continue;
                result.add(new ObjectInstance(data.objectName, data.getClassNameFromMBeanInfo()));
            }
        }
        return result;
    }

    private Set filterListOfObjectInstances(Set list, QueryExp query) {
        if (query == null) {
            return list;
        }
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object var10_9;
            ObjectInstance oi = (ObjectInstance)i.next();
            boolean res = false;
            MBeanServer oldServer = QueryEval.getMBeanServer();
            query.setMBeanServer(this.outerServer);
            try {
                try {
                    res = query.apply(oi.getObjectName());
                }
                catch (Exception e) {
                    res = false;
                    var10_9 = null;
                    query.setMBeanServer(oldServer);
                }
                var10_9 = null;
                query.setMBeanServer(oldServer);
            }
            catch (Throwable throwable) {
                var10_9 = null;
                query.setMBeanServer(oldServer);
                throw throwable;
            }
            if (!res) continue;
            result.add(oi);
        }
        return result;
    }

    private SecurityManager getSecurityManager() {
        return this.securityCheck ? System.getSecurityManager() : null;
    }

    private void checkMBeanPermission(String classname, String member, ObjectName objectName, String actions) throws SecurityException {
        SecurityManager sm = this.getSecurityManager();
        if (sm != null) {
            MBeanPermission perm = new MBeanPermission(classname, member, objectName, actions);
            sm.checkPermission(perm);
        }
    }

    private void checkMBeanTrustPermission(final Class theClass) throws SecurityException {
        SecurityManager sm = this.getSecurityManager();
        if (sm != null) {
            MBeanTrustPermission perm = new MBeanTrustPermission("register");
            ProtectionDomain pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return theClass.getProtectionDomain();
                }
            });
            if (!pd.implies(perm)) {
                throw new SecurityException("access denied (" + perm.getClass().getName() + " " + perm.getName() + ")");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

