/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.introspect;

import com.sap.pj.jmx.introspect.LoaderWrapper;
import java.lang.reflect.Array;
import javax.management.loading.ClassLoaderRepository;

public class Utilities {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public static Class convertClassName(String name, LoaderWrapper loader) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("null");
        }
        if ((name = name.trim()).equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("java.lang.String")) {
            return class$java$lang$String == null ? (class$java$lang$String = Utilities.class$("java.lang.String")) : class$java$lang$String;
        }
        if (name.equals("java.lang.Object")) {
            return class$java$lang$Object == null ? (class$java$lang$Object = Utilities.class$("java.lang.Object")) : class$java$lang$Object;
        }
        if (name.startsWith("[")) {
            int dimension = 0;
            while (name.charAt(dimension) == '[') {
                ++dimension;
            }
            char type = name.charAt(dimension);
            Class cls = null;
            switch (type) {
                case 'Z': {
                    cls = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    cls = Byte.TYPE;
                    break;
                }
                case 'C': {
                    cls = Character.TYPE;
                    break;
                }
                case 'S': {
                    cls = Short.TYPE;
                    break;
                }
                case 'I': {
                    cls = Integer.TYPE;
                    break;
                }
                case 'J': {
                    cls = Long.TYPE;
                    break;
                }
                case 'F': {
                    cls = Float.TYPE;
                    break;
                }
                case 'D': {
                    cls = Double.TYPE;
                    break;
                }
                case 'L': {
                    String n = name.substring(dimension + 1, name.length() - 1);
                    cls = Utilities.convertClassName(n, loader);
                }
            }
            if (cls == null) {
                throw new ClassNotFoundException(name);
            }
            int[] dim = new int[dimension];
            return Array.newInstance(cls, dim).getClass();
        }
        return loader.loadClass(name);
    }

    private Utilities() {
    }

    public static Class[] convertSignature(String[] signature, final ClassLoader loader) throws ClassNotFoundException {
        Class[] clsArr = new Class[signature.length];
        LoaderWrapper loaderWrapper = new LoaderWrapper(){

            public Class loadClass(String name) throws ClassNotFoundException {
                return loader.loadClass(name);
            }
        };
        int i = 0;
        while (i < signature.length) {
            clsArr[i] = Utilities.convertClassName(signature[i], loaderWrapper);
            ++i;
        }
        return clsArr;
    }

    public static Class[] convertSignature(String[] signature, final ClassLoaderRepository classLoaderRep) throws ClassNotFoundException {
        Class[] clsArr = new Class[signature.length];
        LoaderWrapper loaderWrapper = new LoaderWrapper(){

            public Class loadClass(String name) throws ClassNotFoundException {
                return classLoaderRep.loadClass(name);
            }
        };
        int i = 0;
        while (i < signature.length) {
            clsArr[i] = Utilities.convertClassName(signature[i], loaderWrapper);
            ++i;
        }
        return clsArr;
    }

    public static Class[] convertSignature(String[] signature, LoaderWrapper loaderWrapper) throws ClassNotFoundException {
        Class[] clsArr = new Class[signature.length];
        int i = 0;
        while (i < signature.length) {
            clsArr[i] = Utilities.convertClassName(signature[i], loaderWrapper);
            ++i;
        }
        return clsArr;
    }

    public static Class convertClassName(String name, final ClassLoader loader) throws ClassNotFoundException {
        LoaderWrapper loaderWrapper = new LoaderWrapper(){

            public Class loadClass(String name) throws ClassNotFoundException {
                return loader.loadClass(name);
            }
        };
        return Utilities.convertClassName(name, loaderWrapper);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

