/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.introspect;

import com.sap.pj.jmx.mbeaninfo.AdditionalInfoProviderMBean;
import javax.management.DynamicMBean;
import javax.management.JMRuntimeException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.StandardMBean;

public class MBeanData {
    public final Object registeredObject;
    public final DynamicMBean dynamicMBean;
    public final ObjectName objectName;
    public final boolean registration;

    public MBeanData(ObjectName objectName, Object object, DynamicMBean dynamicMBean, boolean registration) {
        this.objectName = objectName;
        this.registeredObject = object;
        this.dynamicMBean = dynamicMBean;
        this.registration = registration;
    }

    public ClassLoader getClassLoader() {
        if (this.registeredObject instanceof StandardMBean) {
            return ((StandardMBean)this.registeredObject).getImplementation().getClass().getClassLoader();
        }
        if (this.registeredObject instanceof AdditionalInfoProviderMBean) {
            return ((AdditionalInfoProviderMBean)this.registeredObject).getImplementation().getClass().getClassLoader();
        }
        return this.registeredObject.getClass().getClassLoader();
    }

    public static String getClassNameFromMBeanInfo(DynamicMBean mbean) throws NotCompliantMBeanException {
        String message;
        try {
            MBeanInfo info = mbean.getMBeanInfo();
            if (info != null) {
                String className = info.getClassName();
                if (className != null) {
                    return className;
                }
                message = "Invocation of getMBeanInfo().getClassName() returned null, MBean: " + mbean.getClass().getName();
            } else {
                message = "Invocation of getMBeanInfo() returned null, MBean: " + mbean.getClass().getName();
            }
        }
        catch (RuntimeException e) {
            throw new NotCompliantMBeanException("Runtime exception during invocation of getMBeanInfo().getClassName(), MBean " + mbean.getClass().getName() + ", Exception " + e.getClass().getName() + " " + e.getMessage());
        }
        throw new NotCompliantMBeanException(message);
    }

    public String getClassNameFromMBeanInfo() {
        try {
            return MBeanData.getClassNameFromMBeanInfo(this.dynamicMBean);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeMBeanException(new JMRuntimeException(e.getMessage()));
        }
    }

    public ObjectInstance getObjectInstance() {
        return new ObjectInstance(this.objectName, this.getClassNameFromMBeanInfo());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MBeanData)) {
            return false;
        }
        MBeanData md = (MBeanData)object;
        return this.objectName.equals(md.objectName);
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }
}

