/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.introspect;

import com.sap.pj.jmx.introspect.MBeanInvoker;
import com.sap.pj.jmx.introspect.Utilities;
import com.sap.pj.jmx.mbeaninfo.MBeanInfoUtilities;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class DefaultMBeanInvoker
implements MBeanInvoker {
    private final MBeanAttributeInfo[] attributesInfo;
    private final Class mbeanInterface;

    DefaultMBeanInvoker(MBeanAttributeInfo[] attributesInfo, Class mbeanInterface) {
        this.attributesInfo = attributesInfo;
        this.mbeanInterface = mbeanInterface;
    }

    public Object invoke(Object implementation, String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object object = null;
        if (operationName.equals("_getMBeanInterface")) {
            object = this.mbeanInterface.getName();
        } else {
            try {
                Class[] parameterTypes = Utilities.convertSignature(signature, implementation.getClass().getClassLoader());
                Method method = this.mbeanInterface.getMethod(operationName, parameterTypes);
                object = method.invoke(implementation, params);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "ClassNotFoundException invoking method " + operationName);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(e, "NoSuchMethodException invoking method " + operationName);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e, "IllegalAccessException invoking method " + operationName);
            }
            catch (RuntimeException e) {
                throw new RuntimeOperationsException(e, "RuntimeException invoking method " + operationName);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw new RuntimeMBeanException((RuntimeException)targetException, "RuntimeException invoking method " + operationName);
                }
                if (targetException instanceof Error) {
                    throw new RuntimeErrorException((Error)targetException, "Error invoking method " + operationName);
                }
                if (targetException instanceof Exception) {
                    throw new MBeanException((Exception)targetException, "Exception invoking method " + operationName);
                }
                throw new ReflectionException(e, "InvocationTargetException invoking method " + operationName + ", nested exception " + targetException.getClass().getName());
            }
        }
        return object;
    }

    public Object getAttribute(Object implementation, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        Method method = null;
        Object object = null;
        try {
            method = this.mbeanInterface.getMethod("get" + attribute, null);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            if (method == null) {
                method = this.mbeanInterface.getMethod("is" + attribute, null);
            }
            object = method.invoke(implementation, null);
        }
        catch (NoSuchMethodException e) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not readable.");
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "IllegalAccessException reading attribute " + attribute);
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException reading attribute " + attribute);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)targetException, "RuntimeException reading attribute " + attribute);
            }
            if (targetException instanceof Error) {
                throw new RuntimeErrorException((Error)targetException, "Error reading attribute " + attribute);
            }
            if (targetException instanceof Exception) {
                throw new MBeanException((Exception)targetException, "Exception reading attribute " + attribute);
            }
            throw new ReflectionException(e, "InvocationTargetException reading attribute " + attribute + ", nested exception " + targetException.getClass().getName());
        }
        return object;
    }

    public void setAttribute(Object implementation, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        Method method;
        MBeanAttributeInfo attributeInfo = MBeanInfoUtilities.getAttributeInfo(attribute.getName(), this.attributesInfo);
        if (attributeInfo == null) {
            throw new AttributeNotFoundException("Attribute " + attribute.getName() + " not found.");
        }
        if (!attributeInfo.isWritable()) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not writable.");
        }
        try {
            Class type = Utilities.convertClassName(attributeInfo.getType(), implementation.getClass().getClassLoader());
            method = this.mbeanInterface.getMethod("set" + attribute.getName(), type);
        }
        catch (ClassNotFoundException e) {
            throw new AttributeNotFoundException("Type mismatch when setting attribute " + attribute);
        }
        catch (NoSuchMethodException e) {
            throw new AttributeNotFoundException("Attribute " + attribute + " not writable.");
        }
        Object value = attribute.getValue();
        if (method.getParameterTypes()[0].isPrimitive()) {
            if (value == null) {
                throw new InvalidAttributeValueException("Attribute is not assignable from " + attribute);
            }
            if (!method.getParameterTypes()[0].isAssignableFrom(DefaultMBeanInvoker.getPrimitiveClass(value))) {
                throw new InvalidAttributeValueException("Attribute is not assignable from " + attribute);
            }
        } else if (value != null && !method.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
            throw new InvalidAttributeValueException("Attribute is not assignable from " + attribute);
        }
        try {
            method.invoke(implementation, attribute.getValue());
        }
        catch (IllegalAccessException e) {
            throw new AttributeNotFoundException("Illegal access to setter method of attribute " + attribute);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)targetException, "Exception setting attribute " + attribute);
            }
            if (targetException instanceof Exception) {
                throw new MBeanException((Exception)targetException, "Exception setting attribute " + attribute);
            }
            throw new ReflectionException(e, "InvocationTargetException setting attribute " + attribute + ", nested exception " + targetException.getClass().getName());
        }
    }

    private static Class getPrimitiveClass(Object value) {
        if (value instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (value instanceof Character) {
            return Character.TYPE;
        }
        if (value instanceof Byte) {
            return Byte.TYPE;
        }
        if (value instanceof Short) {
            return Short.TYPE;
        }
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Long) {
            return Long.TYPE;
        }
        if (value instanceof Float) {
            return Float.TYPE;
        }
        if (value instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }
}

