/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx.introspect;

import com.sap.pj.jmx.introspect.AttributeAccessor;
import com.sap.pj.jmx.introspect.DefaultMBeanInvoker;
import com.sap.pj.jmx.introspect.MBeanIntrospector;
import com.sap.pj.jmx.introspect.MBeanInvoker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;

public class DefaultMBeanIntrospector
implements MBeanIntrospector {
    private Object implementation;
    private final Class mbeanInterface;
    private String className;
    private final MBeanAttributeInfo[] attributes;
    private MBeanConstructorInfo[] constructors;
    private final MBeanOperationInfo[] operations;
    private MBeanInvoker invoker;

    protected DefaultMBeanIntrospector(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("The given implementation must not be null.");
        }
        this.mbeanInterface = DefaultMBeanIntrospector.findMBeanInterface(implementation, mbeanInterface);
        this.implementation = implementation;
        this.className = implementation.getClass().getName();
        int i = 0;
        ArrayList<MBeanOperationInfo> operationsList = new ArrayList<MBeanOperationInfo>();
        HashMap<String, MBeanAttributeInfo> attributesMap = new HashMap<String, MBeanAttributeInfo>();
        Method[] meths = this.mbeanInterface.getMethods();
        i = 0;
        while (i < meths.length) {
            AttributeAccessor aa = AttributeAccessor.getAttributeAccessor(meths[i]);
            if (aa != null) {
                MBeanAttributeInfo attrInfo = null;
                attrInfo = (MBeanAttributeInfo)attributesMap.get(aa.getName());
                if (attrInfo != null) {
                    if (!attrInfo.getType().equals(aa.getType().getName())) {
                        throw new NotCompliantMBeanException("Attribute-type of setter and getter must be identical, attribute: " + aa.getName());
                    }
                    if (attrInfo.isReadable() == aa.isGetter() && attrInfo.isIs() != aa.isIsGetter()) {
                        throw new NotCompliantMBeanException("Two incompatible getters used for attribute: " + aa.getName());
                    }
                    attrInfo = new MBeanAttributeInfo(attrInfo.getName(), attrInfo.getType(), attrInfo.getDescription(), attrInfo.isReadable() | aa.isGetter() | aa.isIsGetter(), attrInfo.isWritable() | aa.isSetter(), attrInfo.isIs() | aa.isIsGetter());
                } else {
                    attrInfo = new MBeanAttributeInfo(aa.getName(), aa.getType().getName(), null, aa.isGetter() | aa.isIsGetter(), aa.isSetter(), aa.isIsGetter());
                }
                attributesMap.put(aa.getName(), attrInfo);
            } else {
                Class<?>[] params = meths[i].getParameterTypes();
                MBeanParameterInfo[] paramsInfo = new MBeanParameterInfo[params.length];
                int j = 0;
                while (j < params.length) {
                    String pn = "p" + (i + 1);
                    paramsInfo[j] = new MBeanParameterInfo(pn, params[j].getName(), null);
                    ++j;
                }
                operationsList.add(new MBeanOperationInfo(meths[i].getName(), null, paramsInfo, meths[i].getReturnType().getName(), 3));
            }
            ++i;
        }
        this.attributes = new MBeanAttributeInfo[attributesMap.size()];
        i = 0;
        Iterator iter = attributesMap.values().iterator();
        while (iter.hasNext()) {
            this.attributes[i++] = (MBeanAttributeInfo)iter.next();
        }
        this.operations = new MBeanOperationInfo[operationsList.size()];
        i = 0;
        Iterator iter2 = ((AbstractList)operationsList).iterator();
        while (iter2.hasNext()) {
            this.operations[i++] = (MBeanOperationInfo)iter2.next();
        }
        this.constructors = DefaultMBeanIntrospector.buildMBeanConstructorInfo(implementation);
    }

    protected static Class findMBeanInterface(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        if (mbeanInterface != null) {
            if (!mbeanInterface.isInterface()) {
                throw new NotCompliantMBeanException("The given mbeanInterface Class is not a Java interface.");
            }
            if (!mbeanInterface.isAssignableFrom(implementation.getClass())) {
                throw new NotCompliantMBeanException("The given implementation does not implement the specified interface.");
            }
            return mbeanInterface;
        }
        Class<?> clazz = implementation.getClass();
        while (clazz != null) {
            Class<?>[] intfs = clazz.getInterfaces();
            int i = 0;
            while (i < intfs.length) {
                if (DefaultMBeanIntrospector.implementsStandardMBeanInterface(clazz.getName(), intfs[i].getName())) {
                    return intfs[i];
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        throw new NotCompliantMBeanException("Not a compliant standard MBean");
    }

    private static boolean implementsStandardMBeanInterface(String className, String intfName) {
        return intfName.equals(className + "MBean");
    }

    protected static MBeanConstructorInfo[] buildMBeanConstructorInfo(Object implementation) {
        Constructor<?>[] consts = implementation.getClass().getConstructors();
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[consts.length];
        int i = 0;
        while (i < consts.length) {
            Class<?>[] params = consts[i].getParameterTypes();
            MBeanParameterInfo[] paramsInfo = new MBeanParameterInfo[params.length];
            int j = 0;
            while (j < params.length) {
                String pn = "p" + (i + 1);
                paramsInfo[j] = new MBeanParameterInfo(pn, params[j].getName(), null);
                ++j;
            }
            constructors[i] = new MBeanConstructorInfo(consts[i].getName(), null, paramsInfo);
            ++i;
        }
        return constructors;
    }

    public MBeanInvoker getInvoker() {
        if (this.invoker == null) {
            this.invoker = new DefaultMBeanInvoker(this.attributes, this.mbeanInterface);
        }
        return this.invoker;
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("The given implementation must not be null.");
        }
        if (!this.mbeanInterface.isAssignableFrom(implementation.getClass())) {
            throw new NotCompliantMBeanException("The given implementation does not implement the specified interface.");
        }
        this.implementation = implementation;
        this.className = implementation.getClass().getName();
        this.constructors = DefaultMBeanIntrospector.buildMBeanConstructorInfo(implementation);
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public String getClassName() {
        return this.className;
    }

    public MBeanAttributeInfo[] getAttributeInfo() {
        return this.attributes;
    }

    public MBeanConstructorInfo[] getConstructorInfo() {
        if (this.constructors == null) {
            this.constructors = DefaultMBeanIntrospector.buildMBeanConstructorInfo(this.implementation);
        }
        return this.constructors;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.implementation instanceof NotificationBroadcaster) {
            return ((NotificationBroadcaster)this.implementation).getNotificationInfo();
        }
        return null;
    }

    public MBeanOperationInfo[] getOperationInfo() {
        return this.operations;
    }
}

