/*
 * Decompiled with CFR 0.152.
 */
package com.sap.pj.jmx;

import com.sap.pj.jmx.server.ListenerInfo;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationEmitter {
    private final Object lock;
    private static int INITIAL_SIZE = 10;
    private ListenerInfo[] listeners = new ListenerInfo[INITIAL_SIZE];
    private int nextFreePos = 0;

    public Object getLock() {
        return this.lock;
    }

    public NotificationBroadcasterSupport(Object lock) {
        this.lock = lock == null ? this : lock;
    }

    public NotificationBroadcasterSupport() {
        this.lock = this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 'listener' cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.nextFreePos >= this.listeners.length) {
                ListenerInfo[] newListeners = new ListenerInfo[this.listeners.length + INITIAL_SIZE];
                System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
                newListeners[this.nextFreePos++] = new ListenerInfo(listener, filter, handback);
                this.listeners = newListeners;
            } else {
                this.listeners[this.nextFreePos++] = new ListenerInfo(listener, filter, handback);
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            int j;
            ListenerInfo[] newListeners;
            int nbFound = 0;
            int firstIndex = -1;
            int i = 0;
            while (i < this.nextFreePos) {
                if (this.listeners[i].listener == listener) {
                    firstIndex = i++;
                    ++nbFound;
                    break;
                }
                ++i;
            }
            while (i < this.nextFreePos) {
                if (this.listeners[i].listener == listener) {
                    ++nbFound;
                }
                ++i;
            }
            if (nbFound > 0) {
                newListeners = new ListenerInfo[Math.min(this.nextFreePos - nbFound + INITIAL_SIZE, this.nextFreePos)];
                System.arraycopy(this.listeners, 0, newListeners, 0, firstIndex);
                j = firstIndex;
                int k = firstIndex + 1;
                while (k < this.nextFreePos) {
                    if (this.listeners[k].listener != listener) {
                        newListeners[j++] = this.listeners[k];
                    }
                    ++k;
                }
            } else {
                throw new ListenerNotFoundException("Listener not found");
            }
            this.nextFreePos = j;
            this.listeners = newListeners;
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            boolean listenerFound = false;
            boolean tripleFound = false;
            ListenerInfo[] newListeners = new ListenerInfo[this.nextFreePos];
            int i = 0;
            int j = 0;
            while (i < this.nextFreePos) {
                if (this.listeners[i].listener == listener) {
                    listenerFound = true;
                    break;
                }
                newListeners[j++] = this.listeners[i];
                ++i;
            }
            while (i < this.nextFreePos) {
                if (this.listeners[i].listener == listener && this.listeners[i].filter == filter && this.listeners[i].handback == handback) {
                    tripleFound = true;
                    ++i;
                    break;
                }
                newListeners[j++] = this.listeners[i];
                ++i;
            }
            while (i < this.nextFreePos) {
                newListeners[j++] = this.listeners[i];
                ++i;
            }
            this.listeners = newListeners;
            this.nextFreePos = j;
            if (!tripleFound) {
                if (listenerFound) {
                    throw new ListenerNotFoundException("Listener with given filter and handback not found");
                }
                throw new ListenerNotFoundException("Listener not found");
            }
        }
    }

    public int getListenersCount() {
        return this.nextFreePos;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public ListenersArray getCurrentListeners() {
        ListenersArray listenersCopy = new ListenersArray();
        Object object = this.lock;
        synchronized (object) {
            listenersCopy.listsners = this.listeners;
            listenersCopy.nextFreePos = this.nextFreePos;
        }
        return listenersCopy;
    }

    public void sendNotification(Notification notification) {
        if (notification == null) {
            return;
        }
        ListenersArray currListeners = this.getCurrentListeners();
        int i = 0;
        while (i < currListeners.nextFreePos) {
            if (currListeners.listsners[i].filter == null || currListeners.listsners[i].filter.isNotificationEnabled(notification)) {
                currListeners.listsners[i].listener.handleNotification(notification, currListeners.listsners[i].handback);
            }
            ++i;
        }
    }

    public final class ListenersArray {
        public ListenerInfo[] listsners;
        public int nextFreePos;
    }
}

