/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.remote;

import com.sap.jmx.remote.JmxConnector;
import com.sap.jmx.remote.JmxConnectorFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;

public class JmxConnectionFactory {
    private static final String JMX_PREFIX = "service:jmx:";
    private static final String PACKAGE_ENGINE_P4 = "com.sap.engine.services.jmx.connector.p4";
    private static final String PACKAGE_ENGINE_LOCAL = "com.sap.engine.services.jmx.connector.local";
    private static final String PACKAGE_ENGINE_N2N = "com.sap.engine.services.jmx.connector.n2n";
    private static final String FACTORY_CLASS = "ConnectorFactory";
    private static final String CLASS_ENGINE_P4 = "com.sap.engine.services.jmx.connector.p4.ConnectorFactory";
    private static final String CLASS_ENGINE_LOCAL = "com.sap.engine.services.jmx.connector.local.ConnectorFactory";
    private static final String CLASS_ENGINE_N2N = "com.sap.engine.services.jmx.connector.n2n.ConnectorFactory";
    public static final String STREAM_CLASS_LOADER = "StreamClassLoader";
    public static final String CONNECTOR_FACTORY_CLASS_LOADER = "ConnectorFactoryClassLoader";
    public static final String PROTOCOL_ENGINE_P4 = "service:jmx:com.sap.engine.services.jmx.connector.p4:";
    public static final String PROTOCOL_ENGINE_LOCAL = "service:jmx:com.sap.engine.services.jmx.connector.local:";
    public static final String PROTOCOL_ENGINE_N2N = "service:jmx:com.sap.engine.services.jmx.connector.n2n:";
    private static final Hashtable EMPTY_TABLE = new Hashtable();
    private static JmxConnectorFactory localConnectorFactory;
    private static JmxConnectorFactory p4ConnectorFactory;
    private static JmxConnectorFactory n2nConnectorFactory;
    static /* synthetic */ Class class$com$sap$jmx$remote$JmxConnectionFactory;

    public static MBeanServerConnection getMBeanServerConnection(String address) throws IOException {
        return JmxConnectionFactory.getConnector(address, null).getMBeanServerConnection();
    }

    public static MBeanServerConnection getMBeanServerConnection(String address, Hashtable props) throws IOException {
        return JmxConnectionFactory.getConnector(address, props).getMBeanServerConnection();
    }

    public static JmxConnector getConnector(String address, Hashtable props) throws IOException {
        JmxConnectorFactory factory;
        String protocol;
        String sap;
        int delimPos;
        if (address == null) {
            throw new IllegalArgumentException("Connector address must not be null.");
        }
        if (props == null) {
            props = EMPTY_TABLE;
        }
        if ((delimPos = address.lastIndexOf(58)) < 0) {
            sap = null;
            protocol = address;
        } else {
            sap = address.substring(delimPos + 1);
            protocol = address.substring(0, delimPos + 1);
        }
        if (protocol.equals(PROTOCOL_ENGINE_N2N)) {
            if (sap == null) {
                throw new IllegalArgumentException("Illegal address, cluster node id missing from " + address);
            }
            factory = n2nConnectorFactory;
        } else if (protocol.equals(PROTOCOL_ENGINE_LOCAL)) {
            factory = localConnectorFactory;
        } else if (protocol.equals(PROTOCOL_ENGINE_P4)) {
            factory = p4ConnectorFactory;
        } else {
            throw new IllegalArgumentException("Invalid connector address " + address);
        }
        if (factory == null) {
            ClassLoader loader = null;
            Object obj = props.get(CONNECTOR_FACTORY_CLASS_LOADER);
            if (obj instanceof ClassLoader) {
                loader = (ClassLoader)obj;
            }
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (loader == null) {
                loader = (class$com$sap$jmx$remote$JmxConnectionFactory == null ? (class$com$sap$jmx$remote$JmxConnectionFactory = JmxConnectionFactory.class$("com.sap.jmx.remote.JmxConnectionFactory")) : class$com$sap$jmx$remote$JmxConnectionFactory).getClassLoader();
            }
            if (protocol.equals(PROTOCOL_ENGINE_N2N)) {
                if (sap == null) {
                    throw new IllegalArgumentException("Illegal address, cluster node id missing from " + address);
                }
                try {
                    Class<?> clazz = loader.loadClass(CLASS_ENGINE_N2N);
                    n2nConnectorFactory = factory = (JmxConnectorFactory)clazz.newInstance();
                }
                catch (Throwable e) {
                    throw new RemoteException("unable to create connector", e);
                }
            } else if (protocol.equals(PROTOCOL_ENGINE_LOCAL)) {
                try {
                    Class<?> clazz = loader.loadClass(CLASS_ENGINE_LOCAL);
                    localConnectorFactory = factory = (JmxConnectorFactory)clazz.newInstance();
                }
                catch (Throwable e) {
                    throw new RemoteException("unable to create connector", e);
                }
            } else if (protocol.equals(PROTOCOL_ENGINE_P4)) {
                try {
                    Class<?> clazz = loader.loadClass(CLASS_ENGINE_P4);
                    p4ConnectorFactory = factory = (JmxConnectorFactory)clazz.newInstance();
                }
                catch (Throwable e) {
                    throw new RemoteException("unable to create connector", e);
                }
            } else {
                throw new IllegalArgumentException("Invalid connector address " + address);
            }
        }
        return factory.getJmxConnector(sap, props);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

