/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.provider;

import com.sap.jmx.provider.LazyMBeanInfo;
import com.sap.jmx.provider.LazyMBeanLoader;
import com.sap.jmx.provider.LazyObjectNameCache;
import com.sap.jmx.provider.Provider;
import com.sap.jmx.provider.ProviderConnection;
import com.sap.jmx.provider.ProviderConnectionInfo;
import com.sap.jmx.provider.ProviderConnectionTimer;
import com.sap.jmx.provider.ProviderException;
import com.sap.jmx.provider.ProviderInfo;
import com.sap.jmx.provider.ProviderInterceptorMBean;
import com.sap.pj.jmx.server.interceptor.BasicMBeanServerInterceptor;
import com.sap.pj.jmx.server.interceptor.InvocationContext;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ProviderInterceptor
extends BasicMBeanServerInterceptor
implements ProviderInterceptorMBean {
    private static LazyObjectNameCache cache;
    private static LazyMBeanLoader loader;
    private Hashtable providerConnections;
    private Hashtable providers;
    private String defaultDomain;
    private int allCalls;
    private int cacheHits;
    private int connectionCounter;
    private long connectionTimeout;
    private ProviderConnectionTimer connectionTimer;

    public static synchronized LazyMBeanLoader getLazyMBeanLoader() {
        return loader;
    }

    public ProviderInterceptor(String defaultDomain) {
        cache = new LazyObjectNameCache();
        loader = new LazyMBeanLoader(cache, this);
        this.providerConnections = new Hashtable();
        this.providers = new Hashtable();
        this.defaultDomain = defaultDomain;
        this.allCalls = 0;
        this.cacheHits = 0;
        this.connectionCounter = 0;
        this.connectionTimeout = 3600000L;
        this.connectionTimer = new ProviderConnectionTimer(this, 60000L);
        new Thread(this.connectionTimer).start();
    }

    public synchronized void registerProvider(String name, Provider provider) {
        if (this.providers.get(name) == null) {
            this.providers.put(name, new ProviderInfo(provider));
        }
    }

    public synchronized void unregisterProvider(String name) {
        this.unregisterProvider(name, false);
    }

    public synchronized void unregisterProvider(String name, boolean closeConnections) {
        ProviderInfo provider = (ProviderInfo)this.providers.remove(name);
        if (provider != null && closeConnections) {
            Collection connections = provider.getConnectionInfos();
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                this.closeConnection(((ProviderConnectionInfo)iterator.next()).getConnectionId(), true, false, false);
            }
        }
    }

    public synchronized String createConnection(String providerName, Properties properties) throws ProviderException, JMException {
        ProviderInfo providerInfo = (ProviderInfo)this.providers.get(providerName);
        if (providerInfo == null) {
            return null;
        }
        ProviderConnection[] availableConnections = providerInfo.getConnections();
        ProviderConnection connection = providerInfo.getProvider().connect(properties, availableConnections);
        int i = 0;
        while (i < availableConnections.length) {
            if (availableConnections.equals(connection)) {
                providerInfo.getConnectionInfo(availableConnections[i]).incUsedCount();
                return providerInfo.getConnectionInfo(connection).getConnectionId();
            }
            ++i;
        }
        ProviderConnectionInfo connectionInfo = new ProviderConnectionInfo(this, Integer.toString(this.connectionCounter++), connection, this.connectionTimeout, providerInfo);
        connectionInfo.incUsedCount();
        providerInfo.addConnection(connection, connectionInfo);
        this.providerConnections.put(connectionInfo.getConnectionId(), connectionInfo);
        connection.init(connectionInfo);
        return connectionInfo.getConnectionId();
    }

    public synchronized void closeConnection(String connectionName) throws ProviderException, JMException {
        this.closeConnection(connectionName, false);
    }

    public void closeConnection(String connectionName, boolean wait) throws ProviderException, JMException {
        this.closeConnection(connectionName, false, wait, true);
    }

    private synchronized void closeConnection(String connectionName, boolean force, boolean wait, boolean unregisterFromProvider) {
        ProviderConnectionInfo connectionInfo = (ProviderConnectionInfo)this.providerConnections.get(connectionName);
        if (connectionInfo != null) {
            connectionInfo.decUsedCount();
            if (!force) {
                if (connectionInfo.getUsedCount() == 0) {
                    ProviderConnection connection = connectionInfo.getConnection();
                    this.providerConnections.remove(connectionName);
                    connectionInfo.invalidateMBeans(wait);
                    connection.disconnect();
                    if (unregisterFromProvider) {
                        connectionInfo.getProvider().removeConnection(connection);
                    }
                }
            } else {
                ProviderConnection connection = connectionInfo.getConnection();
                this.providerConnections.remove(connectionName);
                connectionInfo.invalidateMBeans(wait);
                connection.disconnect();
                if (unregisterFromProvider) {
                    connectionInfo.getProvider().removeConnection(connection);
                }
            }
        }
    }

    public String getType() {
        return "ProviderInterceptor";
    }

    public int allCalls() {
        return this.allCalls;
    }

    public int cacheHits() {
        return this.cacheHits;
    }

    public int cacheSize() {
        return cache.getData().size();
    }

    public Object getAttribute(InvocationContext context, ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                Object object = super.getAttribute(context, name, attribute);
                Object var8_7 = null;
                this.unlockMBean(name, isLocked);
                return object;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        }
        return super.getAttribute(context, name, attribute);
    }

    public AttributeList getAttributes(InvocationContext context, ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                AttributeList attributeList = super.getAttributes(context, name, attributes);
                Object var8_7 = null;
                this.unlockMBean(name, isLocked);
                return attributeList;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        }
        return super.getAttributes(context, name, attributes);
    }

    public MBeanInfo getMBeanInfo(InvocationContext context, ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                MBeanInfo mBeanInfo = super.getMBeanInfo(context, name);
                Object var7_6 = null;
                this.unlockMBean(name, isLocked);
                return mBeanInfo;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        }
        return super.getMBeanInfo(context, name);
    }

    public ObjectInstance getObjectInstance(InvocationContext context, ObjectName name) throws InstanceNotFoundException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                ObjectInstance objectInstance = super.getObjectInstance(context, name);
                Object var7_6 = null;
                this.unlockMBean(name, isLocked);
                return objectInstance;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        }
        return super.getObjectInstance(context, name);
    }

    public Object invoke(InvocationContext context, ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                Object object = super.invoke(context, name, operationName, params, signature);
                Object var10_9 = null;
                this.unlockMBean(name, isLocked);
                return object;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        }
        return super.invoke(context, name, operationName, params, signature);
    }

    public boolean isInstanceOf(InvocationContext context, ObjectName name, String className) throws InstanceNotFoundException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                boolean bl = super.isInstanceOf(context, name, className);
                Object var8_7 = null;
                this.unlockMBean(name, isLocked);
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        }
        return super.isInstanceOf(context, name, className);
    }

    public void setAttribute(InvocationContext context, ObjectName name, Attribute attribute) throws AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                super.setAttribute(context, name, attribute);
                Object var7_6 = null;
                this.unlockMBean(name, isLocked);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        } else {
            super.setAttribute(context, name, attribute);
        }
    }

    public AttributeList setAttributes(InvocationContext context, ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            boolean isLocked = this.lockMBean(context, name, providerConnectionInfo);
            try {
                AttributeList attributeList = super.setAttributes(context, name, attributes);
                Object var8_7 = null;
                this.unlockMBean(name, isLocked);
                return attributeList;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.unlockMBean(name, isLocked);
                throw throwable;
            }
        }
        return super.setAttributes(context, name, attributes);
    }

    public void unregisterMBean(InvocationContext context, ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            cache.addExclusiveLock(name);
            cache.unregister(name);
            try {
                super.unregisterMBean(context, name);
                Object var5_4 = null;
                cache.removeExclusiveLock(name);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                cache.removeExclusiveLock(name);
                throw throwable;
            }
        } else {
            super.unregisterMBean(context, name);
        }
    }

    public ClassLoader getClassLoaderFor(InvocationContext context, ObjectName name) throws InstanceNotFoundException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            return this.getClass().getClassLoader();
        }
        return super.getClassLoaderFor(context, name);
    }

    public ClassLoader getClassLoader(InvocationContext context, ObjectName name) throws InstanceNotFoundException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            return this.getClass().getClassLoader();
        }
        return super.getClassLoader(context, name);
    }

    private boolean lockMBean(InvocationContext context, ObjectName name, ProviderConnectionInfo connectionInfo) {
        ++this.allCalls;
        if (!cache.addSharedLock(name)) {
            Object mBean = connectionInfo.getConnection().instantiateMBean(name);
            if (mBean == null) {
                return false;
            }
            cache.addExclusiveLock(name);
            if (cache.register(name, mBean, connectionInfo, -1)) {
                try {
                    super.registerMBean(null, mBean, name);
                    if (!connectionInfo.registerNewMBean(cache.getMBeanInfo(name))) {
                        cache.unregister(name);
                        cache.removeExclusiveLock(name);
                        return false;
                    }
                    loader.lazyLoad(name);
                }
                catch (NotCompliantMBeanException ncmbException) {
                    cache.unregister(name);
                    cache.removeExclusiveLock(name);
                    return false;
                }
                catch (InstanceAlreadyExistsException iaeException) {
                    cache.unregister(name);
                    cache.removeExclusiveLock(name);
                    return false;
                }
                catch (MBeanRegistrationException mbrException) {
                    cache.unregister(name);
                    cache.removeExclusiveLock(name);
                    return false;
                }
            } else {
                ++this.cacheHits;
            }
            cache.reduceExclusiveLock(name);
            return true;
        }
        ++this.cacheHits;
        return true;
    }

    private void unlockMBean(ObjectName name, boolean isLocked) {
        if (isLocked) {
            cache.removeSharedLock(name);
        }
    }

    public void registerMBean(ObjectName name, ProviderConnectionInfo provider, int timeStamp) {
        if (cache.isFull() && LazyMBeanInfo.getLowestTimeStamp() > timeStamp) {
            return;
        }
        if (cache.addExclusiveLockIfNotRegistered(name)) {
            Object mBean = provider.getConnection().instantiateMBean(name);
            if (mBean != null) {
                cache.register(name, mBean, provider, timeStamp);
                try {
                    super.registerMBean(null, mBean, name);
                }
                catch (NotCompliantMBeanException ncmbException) {
                    cache.unregister(name);
                }
                catch (InstanceAlreadyExistsException iaeException) {
                    cache.unregister(name);
                }
                catch (MBeanRegistrationException mbrException) {
                    cache.unregister(name);
                }
            }
            cache.removeExclusiveLock(name);
            this.checkCacheSize();
        }
    }

    private void checkCacheSize() {
        while (cache.isFull()) {
            Object var5_4;
            ObjectName name = cache.lockLastForRemove();
            if (name == null) break;
            try {
                block6: {
                    try {
                        if (!cache.unregister(name)) break block6;
                        super.unregisterMBean(null, name);
                    }
                    catch (InstanceNotFoundException infExcption) {
                        var5_4 = null;
                        cache.removeExclusiveLock(name);
                        continue;
                    }
                    catch (MBeanRegistrationException mbrException) {
                        var5_4 = null;
                        cache.removeExclusiveLock(name);
                        continue;
                    }
                }
                var5_4 = null;
                cache.removeExclusiveLock(name);
            }
            catch (Throwable throwable) {
                var5_4 = null;
                cache.removeExclusiveLock(name);
                throw throwable;
            }
        }
    }

    public void invalidate(ObjectName name, boolean wait) throws JMException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            this.invalidateMBean(name, wait);
        }
    }

    public void invalidate(ObjectName[] mBeans, boolean wait) throws JMException {
        int i = 0;
        while (i < mBeans.length) {
            this.invalidate(mBeans[i], wait);
            ++i;
        }
    }

    public void invalidateMBean(ObjectName name, boolean wait) throws JMException {
        cache.addExclusiveLock(name);
        try {
            if (cache.unregister(name)) {
                super.unregisterMBean(null, name);
            }
            Object var4_3 = null;
            cache.removeExclusiveLock(name);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            cache.removeExclusiveLock(name);
            throw throwable;
        }
    }

    public void registerMBeanOnStartup(ObjectName name, Object mBean, ProviderConnectionInfo provider) throws JMException {
        ProviderConnectionInfo providerConnectionInfo = this.getConnection(name);
        if (providerConnectionInfo != null) {
            this.registerMBean(name, mBean, provider, true);
        } else {
            super.registerMBean(null, mBean, name);
        }
    }

    public void registerMBean(ObjectName name, Object mBean, ProviderConnectionInfo provider) throws JMException {
        this.registerMBean(name, mBean, provider, false);
    }

    private void registerMBean(ObjectName name, Object mBean, ProviderConnectionInfo provider, boolean onStartup) throws JMException {
        cache.addExclusiveLock(name);
        if (cache.register(name, mBean, provider, -1)) {
            try {
                super.registerMBean(null, mBean, name);
                if (onStartup) {
                    cache.setMainFlag(name, true);
                } else {
                    loader.lazyLoad(name);
                }
            }
            catch (NotCompliantMBeanException ncmbException) {
                cache.unregister(name);
                cache.removeExclusiveLock(name);
                throw ncmbException;
            }
            catch (InstanceAlreadyExistsException iaeException) {
                cache.unregister(name);
                cache.removeExclusiveLock(name);
                throw iaeException;
            }
            catch (MBeanRegistrationException mbrException) {
                cache.unregister(name);
                cache.removeExclusiveLock(name);
                throw mbrException;
            }
        }
        cache.removeExclusiveLock(name);
    }

    public void refreshConnected(ObjectName name) {
        loader.lazyLoad(name);
    }

    public void dumpCache() throws Exception {
        PrintWriter out = new PrintWriter(new FileOutputStream("chache_dump.txt"));
        Hashtable data = cache.getData();
        out.println(" Data size: " + data.size());
        Iterator i = data.keySet().iterator();
        while (i.hasNext()) {
            ObjectName name = (ObjectName)i.next();
            out.println();
            out.println(name);
            out.println(data.get(name));
        }
        out.println();
        out.println(" Queue: " + LazyMBeanInfo.printInfo());
        out.flush();
        out.close();
    }

    public Object getMBean(ObjectName name, boolean instantiate, ProviderConnectionInfo provider) throws JMException {
        if (!cache.addSharedLock(name)) {
            if (instantiate) {
                Object mBean = provider.getConnection().instantiateMBean(name);
                if (mBean == null) {
                    return null;
                }
                cache.addExclusiveLock(name);
                if (cache.register(name, mBean, provider, -1)) {
                    try {
                        super.registerMBean(null, mBean, name);
                        loader.lazyLoad(name);
                    }
                    catch (NotCompliantMBeanException ncmbException) {
                        cache.unregister(name);
                        cache.removeExclusiveLock(name);
                        throw ncmbException;
                    }
                    catch (InstanceAlreadyExistsException iaeException) {
                        cache.unregister(name);
                        cache.removeExclusiveLock(name);
                        throw iaeException;
                    }
                    catch (MBeanRegistrationException mbrException) {
                        cache.unregister(name);
                        cache.removeExclusiveLock(name);
                        throw mbrException;
                    }
                }
                Object result = cache.getMBeanInfo(name).getMBean();
                cache.removeExclusiveLock(name);
                return result;
            }
            return null;
        }
        Object result = cache.getMBeanInfo(name).getMBean();
        cache.removeSharedLock(name);
        return result;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    private ProviderConnectionInfo getConnection(ObjectName name) {
        String connectionId = name.getKeyProperty("ext_conn");
        if (connectionId != null) {
            return (ProviderConnectionInfo)this.providerConnections.get(connectionId);
        }
        return null;
    }

    public void checkTimeout() {
        try {
            Iterator iterator = this.providerConnections.values().iterator();
            while (iterator.hasNext()) {
                ProviderConnectionInfo connection = (ProviderConnectionInfo)iterator.next();
                if (!connection.isInactive()) continue;
                this.connectionTimeout(connection.getConnectionId());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private synchronized void connectionTimeout(String connectionName) {
        this.closeConnection(connectionName, true, true, true);
    }
}

