/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.provider;

import com.sap.jmx.provider.LazyMBeanInfo;
import com.sap.jmx.provider.ProviderConnection;
import com.sap.jmx.provider.ProviderContext;
import com.sap.jmx.provider.ProviderInfo;
import com.sap.jmx.provider.ProviderInterceptor;
import java.util.Hashtable;
import javax.management.JMException;
import javax.management.ObjectName;

public class ProviderConnectionInfo
implements ProviderContext {
    private ProviderConnection connection;
    private ProviderInterceptor interceptor;
    private ProviderInfo provider;
    private String connectionId;
    private int usedCount;
    private long timeStamp;
    private long timeout;
    private LazyMBeanInfo first;

    public ProviderConnectionInfo(ProviderInterceptor interceptor, String connectionId, ProviderConnection connection, long timeout, ProviderInfo provider) {
        this.interceptor = interceptor;
        this.provider = provider;
        this.connectionId = connectionId;
        this.connection = connection;
        this.timeout = timeout;
        this.usedCount = 0;
        this.timeStamp = 0L;
        this.first = null;
    }

    public ProviderConnection getConnection() {
        return this.connection;
    }

    public ProviderInfo getProvider() {
        return this.provider;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public synchronized void incUsedCount() {
        ++this.usedCount;
    }

    public synchronized void decUsedCount() {
        --this.usedCount;
    }

    public int getUsedCount() {
        return this.usedCount;
    }

    public void invalidate(ObjectName mBean) throws JMException {
        this.interceptor.invalidate(mBean, true);
    }

    public void invalidate(ObjectName mBean, boolean wait) throws JMException {
        this.interceptor.invalidate(mBean, wait);
    }

    public void invalidate(ObjectName[] mBeans) throws JMException {
        this.interceptor.invalidate(mBeans, true);
    }

    public void invalidate(ObjectName[] mBeans, boolean wait) throws JMException {
        this.interceptor.invalidate(mBeans, wait);
    }

    public void refreshConnected(ObjectName mBean) throws JMException {
        this.interceptor.refreshConnected(mBean);
    }

    public void registerMBeanOnStartup(ObjectName name, Object mBean) throws JMException {
        this.interceptor.registerMBeanOnStartup(name, mBean, this);
    }

    public void registerMBean(ObjectName name, Object mBean) throws JMException {
        this.interceptor.registerMBean(name, mBean, this);
    }

    public Object getMBean(ObjectName name, boolean instantiate) throws JMException {
        return this.interceptor.getMBean(name, instantiate, this);
    }

    public ObjectName createObjectName(Hashtable nameValuePairs) throws JMException {
        nameValuePairs.put("ext_conn", this.connectionId);
        return new ObjectName(this.interceptor.getDefaultDomain(), nameValuePairs);
    }

    public ObjectName createObjectName(String key, String value) throws JMException {
        Hashtable<String, String> nameValuePairs = new Hashtable<String, String>();
        nameValuePairs.put(key, value);
        nameValuePairs.put("ext_conn", this.connectionId);
        return new ObjectName(this.interceptor.getDefaultDomain(), nameValuePairs);
    }

    public synchronized boolean registerNewMBean(LazyMBeanInfo info) {
        if (this.usedCount > 0) {
            info.setNextMBeanInConnection(this.first);
            info.setPrevMBeanInConnection(null);
            if (this.first != null) {
                this.first.setPrevMBeanInConnection(info);
            }
            this.first = info;
            return true;
        }
        return false;
    }

    public synchronized void unregisterMBean(LazyMBeanInfo info) {
        if (info.getNextMBeanInConnection() != null) {
            info.getNextMBeanInConnection().setPrevMBeanInConnection(info.getPrevMBeanInConnection());
        }
        if (info.getPrevMBeanInConnection() != null) {
            info.getPrevMBeanInConnection().setNextMBeanInConnection(info.getNextMBeanInConnection());
        }
        if (this.first == info) {
            this.first = info.getNextMBeanInConnection();
        }
    }

    public synchronized LazyMBeanInfo getNext() {
        LazyMBeanInfo result = this.first;
        if (this.first != null) {
            this.first = this.first.getNextMBeanInConnection();
            if (this.first != null) {
                this.first.setPrevMBeanInConnection(null);
            }
            result.setNextMBeanInConnection(null);
        }
        return result;
    }

    public void invalidateMBeans(boolean wait) {
        LazyMBeanInfo mBean = this.getNext();
        while (mBean != null) {
            try {
                this.interceptor.invalidateMBean(mBean.getObjectName(), wait);
            }
            catch (JMException jMException) {
                // empty catch block
            }
            mBean = this.getNext();
        }
    }

    public void unregisterMBean(ObjectName name) throws JMException {
        this.interceptor.unregisterMBean(null, name);
    }

    public void invalidateTimeStamp() {
        this.timeStamp = System.currentTimeMillis();
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public boolean isInactive() {
        if (this.connection.isAlive()) {
            if (this.timeout > 0L) {
                return System.currentTimeMillis() > this.timeStamp + this.timeout;
            }
            return false;
        }
        return true;
    }

    public void setConnectionTimeout(long timeout) {
        this.timeout = timeout;
    }
}

