/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.provider;

import com.sap.jmx.provider.LazyMBeanInfo;
import com.sap.jmx.provider.ProviderConnectionInfo;
import java.util.Hashtable;
import javax.management.ObjectName;

public class LazyObjectNameCache {
    private static final int MAX_CACHE_SIZE = 10000;
    private Hashtable data = new Hashtable();

    public boolean addSharedLock(ObjectName name) {
        LazyMBeanInfo info = null;
        boolean succeeded = false;
        while (!succeeded) {
            LazyObjectNameCache lazyObjectNameCache = this;
            synchronized (lazyObjectNameCache) {
                info = (LazyMBeanInfo)this.data.get(name);
                if (info == null) {
                    boolean bl = false;
                    return bl;
                }
                succeeded = info.addLock();
            }
            if (succeeded) continue;
            info.waitForLock();
        }
        return true;
    }

    public void removeSharedLock(ObjectName name) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        info.removeLock();
    }

    public boolean register(ObjectName name, Object mBean, ProviderConnectionInfo provider, int timeStamp) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        return info.register(mBean, provider, timeStamp);
    }

    public boolean unregister(ObjectName name) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        return info.unregister();
    }

    public void setMainFlag(ObjectName name, boolean flag) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        info.setMainFlag(flag);
    }

    public boolean getMainFlag(ObjectName name) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        return info.getMainFlag();
    }

    public void addExclusiveLock(ObjectName name) {
        LazyMBeanInfo info = null;
        boolean succeeded = false;
        while (!succeeded) {
            LazyObjectNameCache lazyObjectNameCache = this;
            synchronized (lazyObjectNameCache) {
                info = (LazyMBeanInfo)this.data.get(name);
                if (info == null) {
                    info = new LazyMBeanInfo(name);
                    this.data.put(name, info);
                }
                succeeded = info.addExclusiveLock();
            }
            if (succeeded) continue;
            info.waitForExclusiveLock();
        }
    }

    public synchronized boolean addExclusiveLockIfNotRegistered(ObjectName name) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        if (info != null) {
            return false;
        }
        info = new LazyMBeanInfo(name);
        info.addExclusiveLock();
        this.data.put(name, info);
        return true;
    }

    public void removeExclusiveLock(ObjectName name) {
        LazyMBeanInfo info = null;
        LazyObjectNameCache lazyObjectNameCache = this;
        synchronized (lazyObjectNameCache) {
            info = (LazyMBeanInfo)this.data.get(name);
            if (!info.isRegistered()) {
                this.data.remove(name);
                info.getProvider().unregisterMBean(info);
            }
        }
        info.removeExclusiveLock();
    }

    public void reduceExclusiveLock(ObjectName name) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        info.reduceExclusiveLock();
    }

    public LazyMBeanInfo getLazyMBeanInfo(ObjectName name) {
        return (LazyMBeanInfo)this.data.get(name);
    }

    public boolean isFull() {
        return this.data.size() > 10000;
    }

    public ObjectName lockLastForRemove() {
        LazyMBeanInfo info = null;
        while (true) {
            boolean succeeded = false;
            info = LazyMBeanInfo.getLast();
            if (info == null) {
                return null;
            }
            succeeded = info.addExclusiveLock();
            if (!succeeded) {
                info.waitForExclusiveLock();
                continue;
            }
            if (LazyMBeanInfo.getLast() == info) {
                return info.getObjectName();
            }
            info.removeExclusiveLock();
        }
    }

    public Hashtable getData() {
        return this.data;
    }

    public LazyMBeanInfo getMBeanInfo(ObjectName name) {
        LazyMBeanInfo info = (LazyMBeanInfo)this.data.get(name);
        if (info != null) {
            return info;
        }
        return null;
    }
}

