/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jmx.provider;

import com.sap.jmx.provider.LazyMBeanInfo;
import com.sap.jmx.provider.LazyObjectNameCache;
import com.sap.jmx.provider.ProviderConnectionInfo;
import com.sap.jmx.provider.ProviderInterceptor;
import javax.management.ObjectName;

public class LazyMBeanLoader
implements Runnable {
    private static final int MAX_QUEUE_LENGTH = 1000;
    private static final int USED_UNUSED_STAMP_DIFF = 100;
    private static int timeStamp = 100;
    private LazyObjectNameCache cache;
    private ProviderInterceptor interceptor;
    private LazyMBeanInfo first;
    private LazyMBeanInfo last;
    private int loadPointer;
    private int count;
    private boolean waitFlag;
    private int lowestTimeStamp;

    public static synchronized int getTimeStamp() {
        return timeStamp++;
    }

    public LazyMBeanLoader(LazyObjectNameCache cache, ProviderInterceptor interceptor) {
        this.cache = cache;
        this.interceptor = interceptor;
        this.lowestTimeStamp = -1;
        this.loadPointer = 0;
        this.count = 0;
        this.waitFlag = false;
        new Thread(this).start();
    }

    public void lazyLoad(ObjectName name) {
        LazyMBeanInfo info = this.cache.getLazyMBeanInfo(name);
        if (info != null) {
            info.setLazyLoadTimeStamp(info.getObjectTimeStamp() - 100);
            this.insertFirst(info);
        }
    }

    private synchronized LazyMBeanInfo getFirst() {
        LazyMBeanInfo info = this.first;
        this.first = this.first.getNextToLoad();
        if (this.first != null) {
            this.first.setPrevToLoad(null);
        }
        info.setNextToLoad(null);
        if (this.last == info) {
            this.last = null;
        }
        --this.count;
        return info;
    }

    private synchronized void insertFirst(LazyMBeanInfo info) {
        if (info.getNextToLoad() != null) {
            info.getNextToLoad().setPrevToLoad(info.getPrevToLoad());
        }
        if (info.getPrevToLoad() != null) {
            info.getPrevToLoad().setNextToLoad(info.getNextToLoad());
        }
        if (this.first == info) {
            this.first = info.getNextToLoad();
        }
        if (this.last == info) {
            this.last = info.getPrevToLoad();
        }
        info.setNextToLoad(this.first);
        info.setPrevToLoad(null);
        if (this.first != null) {
            this.first.setPrevToLoad(info);
        }
        this.first = info;
        if (this.last == null) {
            this.last = info;
        }
        if (this.waitFlag) {
            this.notify();
        }
        ++this.count;
        if (this.count > 1000) {
            this.removeLast();
        }
    }

    private synchronized void removeLast() {
        if (this.first == this.last) {
            this.first = null;
        }
        this.last = this.last.getPrevToLoad();
        if (this.last != null) {
            this.last.getNextToLoad().setPrevToLoad(null);
            this.last.setNextToLoad(null);
        }
        --this.count;
    }

    public void run() {
        while (true) {
            LazyMBeanInfo info = null;
            LazyMBeanLoader lazyMBeanLoader = this;
            synchronized (lazyMBeanLoader) {
                if (this.count == 0) {
                    this.waitFlag = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException iException) {
                        // empty catch block
                    }
                    this.waitFlag = false;
                }
            }
            info = this.getFirst();
            if (info == null || !info.isRegistered()) continue;
            ProviderConnectionInfo provider = info.getProvider();
            try {
                ObjectName[] connected = provider.getConnection().getConnected(info.getObjectName(), info.getMBean());
                if (connected == null) continue;
                this.registerConnectedMBeans(connected, provider, info.getLazyLoadTimeStamp());
            }
            catch (Exception e) {
            }
        }
    }

    private void registerConnectedMBeans(ObjectName[] names, ProviderConnectionInfo provider, int timeStamp) {
        int i = 0;
        while (i < names.length) {
            LazyMBeanInfo info = this.cache.getLazyMBeanInfo(names[i]);
            if (info == null) {
                this.interceptor.registerMBean(names[i], provider, timeStamp);
            }
            ++i;
        }
    }
}

